/*  $Id: common_tax.inc 657661 2022-10-13 19:12:08Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Colleen Bollin
 *
 * File Description:
 *   Built-in copy of common_tax.txt.
 *
 */

/* time_t value corresponding to Wed Feb 13 13:29:56 EST 2019; formally
 * expressed as unsigned long so output can stand fully on its own. */
static const unsigned long kOrgRefList_Timestamp = 1550082596UL;
static const char* const kOrgRefList[] = {
    "Acanthisitta chloris\trifleman\t1\t2\t-\t57068\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Acanthisittidae; Acanthisitta",
    "Acanthoscurria geniculata\t-\t1\t5\t-\t575412\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Arachnida; Araneae; Mygalomorphae; Theraphosidae; Acanthoscurria",
    "Acartia tonsa\t-\t1\t5\t-\t136180\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Hexanauplia; Copepoda; Calanoida; Acartiidae; Acartia",
    "Acidobacteria bacterium\t-\t11\t0\t-\t1978231\tBCT\tBacteria; Acidobacteria",
    "Acinetobacter\t-\t11\t0\t-\t469\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Pseudomonadales; Moraxellaceae; Acinetobacter",
    "Acinetobacter baumannii\t-\t11\t0\t-\t470\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Pseudomonadales; Moraxellaceae; Acinetobacter; Acinetobacter calcoaceticus/baumannii complex",
    "Acropora cervicornis\t-\t1\t4\t-\t6130\tINV\tEukaryota; Metazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Astrocoeniina; Acroporidae; Acropora",
    "Acropora millepora\t-\t1\t4\t-\t45264\tINV\tEukaryota; Metazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Astrocoeniina; Acroporidae; Acropora",
    "Acropora tenuis\tpurple tipped acropora\t1\t4\t-\t70783\tINV\tEukaryota; Metazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Astrocoeniina; Acroporidae; Acropora",
    "Actinidia\t-\t1\t1\t11\t3624\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; Ericales; Actinidiaceae; Actinidia",
    "Acyrthosiphon\t-\t1\t5\t-\t7028\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Aphidomorpha; Aphidoidea; Aphididae; Macrosiphini; Acyrthosiphon",
    "Acyrthosiphon pisum\tpea aphid\t1\t5\t-\t7029\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Aphidomorpha; Aphidoidea; Aphididae; Macrosiphini; Acyrthosiphon",
    "Aedes\t-\t1\t5\t-\t7158\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Nematocera; Culicoidea; Culicidae; Culicinae; Aedini; Aedes",
    "Aedes aegypti\tyellow fever mosquito\t1\t5\t-\t7159\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Nematocera; Culicoidea; Culicidae; Culicinae; Aedini; Aedes; Stegomyia",
    "Aedes albopictus\tAsian tiger mosquito\t1\t5\t-\t7160\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Nematocera; Culicoidea; Culicidae; Culicinae; Aedini; Aedes; Stegomyia",
    "Aegilops tauschii\t-\t1\t1\t11\t37682\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Aegilops",
    "Aegilops tauschii subsp. tauschii\t-\t1\t1\t11\t169297\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Aegilops",
    "Agave deserti\t-\t1\t1\t11\t382119\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Asparagales; Asparagaceae; Agavoideae; Agave",
    "Agave tequilana\t-\t1\t1\t11\t386106\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Asparagales; Asparagaceae; Agavoideae; Agave",
    "Ailuropoda melanoleuca\tgiant panda\t1\t2\t-\t9646\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Caniformia; Ursidae; Ailuropoda",
    "Alexandrium tamarense\t-\t1\t4\t11\t2926\tPLN\tEukaryota; Alveolata; Dinophyceae; Gonyaulacales; Gonyaulacaceae; Alexandrium",
    "Allium cepa\tonion\t1\t1\t11\t4679\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Asparagales; Amaryllidaceae; Allioideae; Allieae; Allium",
    "Allium sativum\tgarlic\t1\t1\t11\t4682\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Asparagales; Amaryllidaceae; Allioideae; Allieae; Allium",
    "Alvinella\t-\t1\t5\t-\t6375\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Polychaeta; Scolecida; Terebellida; Alvinellidae; Alvinella",
    "Alvinella pompejana\t-\t1\t5\t-\t6376\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Polychaeta; Scolecida; Terebellida; Alvinellidae; Alvinella",
    "Amaranthus tricolor\t-\t1\t1\t11\t29722\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Amaranthaceae; Amaranthus",
    "Amborella\t-\t1\t1\t11\t13332\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Amborellales; Amborellaceae; Amborella",
    "Amborella trichopoda\t-\t1\t1\t11\t13333\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Amborellales; Amborellaceae; Amborella",
    "Ameiurus nebulosus\tbrown bullhead\t1\t2\t-\t27778\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Siluriformes; Ictaluridae; Ameiurus",
    "Amoebidium parasiticum JAP-7-2\t-\t1\t4\t-\t1069442\tINV\tEukaryota; Ichthyosporea; Ichthyophonida; Amoebidiaceae; Amoebidium",
    "Amphimedon queenslandica\t-\t1\t4\t-\t400682\tINV\tEukaryota; Metazoa; Porifera; Demospongiae; Heteroscleromorpha; Haplosclerida; Niphatidae; Amphimedon",
    "Anas platyrhynchos\tmallard\t1\t2\t-\t8839\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Anseriformes; Anatidae; Anatinae; Anas",
    "Ancylostoma\t-\t1\t5\t-\t29169\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Rhabditomorpha; Strongyloidea; Ancylostomatidae; Ancylostomatinae; Ancylostoma",
    "Ancylostoma caninum\tdog hookworm\t1\t5\t-\t29170\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Rhabditomorpha; Strongyloidea; Ancylostomatidae; Ancylostomatinae; Ancylostoma",
    "Ancylostoma ceylanicum\t-\t1\t5\t-\t53326\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Rhabditomorpha; Strongyloidea; Ancylostomatidae; Ancylostomatinae; Ancylostoma",
    "Anguilla anguilla\tEuropean eel\t1\t2\t-\t7936\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Anguilliformes; Anguillidae; Anguilla",
    "Anguilla japonica\tJapanese eel\t1\t2\t-\t7937\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Anguilliformes; Anguillidae; Anguilla",
    "Annulipalpia sp. AD-2013\t-\t1\t5\t-\t1499517\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Trichoptera; Annulipalpia; unclassified Annulipalpia",
    "Anolis\t-\t1\t2\t-\t28376\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Iguania; Dactyloidae; Anolis",
    "Anolis carolinensis\tgreen anole\t1\t2\t-\t28377\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Iguania; Dactyloidae; Anolis",
    "Anopheles\t-\t1\t5\t-\t7164\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Nematocera; Culicoidea; Culicidae; Anophelinae; Anopheles",
    "Anopheles gambiae\tAfrican malaria mosquito\t1\t5\t-\t7165\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Nematocera; Culicoidea; Culicidae; Anophelinae; Anopheles",
    "Anoplopoma fimbria\tsablefish\t1\t2\t-\t229290\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Perciformes; Cottioidei; Anoplopomatales; Anoplopomatidae; Anoplopoma",
    "Anthopleura elegantissima\tclonal anemone\t1\t4\t-\t6110\tINV\tEukaryota; Metazoa; Cnidaria; Anthozoa; Hexacorallia; Actiniaria; Actiniidae; Anthopleura",
    "Antrostomus carolinensis\tchuck-will's-widow\t1\t2\t-\t279965\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Caprimulgiformes; Caprimulgidae; Antrostomus",
    "Aotus nancymaae\tMa's night monkey\t1\t2\t-\t37293\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Platyrrhini; Aotidae; Aotus",
    "Apaloderma vittatum\tbar-tailed trogon\t1\t2\t-\t57397\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Trogoniformes; Trogonidae; Apaloderma",
    "Aphanomyces astaci\t-\t1\t1\t11\t112090\tPLN\tEukaryota; Stramenopiles; Oomycetes; Saprolegniales; Saprolegniaceae; Aphanomyces",
    "Aphis\t-\t1\t5\t-\t80764\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Aphidomorpha; Aphidoidea; Aphididae; Aphidini; Aphis",
    "Aphis gossypii\tcotton aphid\t1\t5\t-\t80765\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Aphidomorpha; Aphidoidea; Aphididae; Aphidini; Aphis; Aphis",
    "Apis\t-\t1\t5\t-\t7459\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Apis",
    "Apis mellifera\thoney bee\t1\t5\t-\t7460\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Apis",
    "Apis mellifera carnica\tCarniolan honeybee\t1\t5\t-\t88217\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Apis",
    "Aplysia\t-\t1\t5\t-\t6499\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Euopisthobranchia; Aplysiida; Aplysioidea; Aplysiidae; Aplysia",
    "Aplysia californica\tCalifornia sea hare\t1\t5\t-\t6500\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Euopisthobranchia; Aplysiida; Aplysioidea; Aplysiidae; Aplysia",
    "Apostichopus japonicus\tJapanese sea cucumber\t1\t9\t-\t307972\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Holothuroidea; Aspidochirotacea; Aspidochirotida; Stichopodidae; Apostichopus",
    "Apteryx australis mantelli\t-\t1\t2\t-\t202946\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Palaeognathae; Apterygiformes; Apterygidae; Apteryx",
    "Aquilegia\t-\t1\t1\t11\t3450\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Ranunculales; Ranunculaceae; Thalictroideae; Aquilegia",
    "Aquilegia coerulea\t-\t1\t1\t11\t218851\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Ranunculales; Ranunculaceae; Thalictroideae; Aquilegia",
    "Aquilegia formosa x Aquilegia pubescens\t-\t1\t1\t11\t338618\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Ranunculales; Ranunculaceae; Thalictroideae; Aquilegia",
    "Ara macao\tScarlet macaw\t1\t2\t-\t176014\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Psittaciformes; Psittacidae; Ara",
    "Arabidopsis\t-\t1\t1\t11\t3701\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Camelineae; Arabidopsis",
    "Arabidopsis thaliana\tthale cress\t1\t1\t11\t3702\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Camelineae; Arabidopsis",
    "Arachis\t-\t1\t1\t11\t3817\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; dalbergioids sensu lato; Dalbergieae; Pterocarpus clade; Arachis",
    "Arachis duranensis\t-\t1\t1\t11\t130453\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; dalbergioids sensu lato; Dalbergieae; Pterocarpus clade; Arachis",
    "Arachis hypogaea\tpeanut\t1\t1\t11\t3818\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; dalbergioids sensu lato; Dalbergieae; Pterocarpus clade; Arachis",
    "Arachis hypogaea var. vulgaris\t-\t1\t1\t11\t925390\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; dalbergioids sensu lato; Dalbergieae; Pterocarpus clade; Arachis",
    "Arachis ipaensis\t-\t1\t1\t11\t130454\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; dalbergioids sensu lato; Dalbergieae; Pterocarpus clade; Arachis",
    "Aretaon asperrimus\tthorny stick insect\t1\t5\t-\t173775\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Polyneoptera; Phasmatodea; Verophasmatodea; Areolatae; Bacilloidea; Heteropterygidae; Obriminae; Obrimini; Aretaon",
    "Arion vulgaris\t-\t1\t5\t-\t1028688\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Panpulmonata; Eupulmonata; Stylommatophora; Sigmurethra; Arionoidea; Arionidae; Arion",
    "Artemisia\t-\t1\t1\t11\t4219\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Anthemideae; Artemisiinae; Artemisia",
    "Artemisia annua\tsweet wormwood\t1\t1\t11\t35608\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Anthemideae; Artemisiinae; Artemisia",
    "Arundo donax\tgiant reed\t1\t1\t11\t35708\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Arundinoideae; Arundineae; Arundo",
    "Ascaris\t-\t1\t5\t-\t6251\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Spirurina; Ascaridomorpha; Ascaridoidea; Ascarididae; Ascaris",
    "Ascaris suum\tpig roundworm\t1\t5\t-\t6253\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Spirurina; Ascaridomorpha; Ascaridoidea; Ascarididae; Ascaris",
    "Aspergillus\t-\t1\t4\t-\t5052\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Eurotiomycetes; Eurotiomycetidae; Eurotiales; Aspergillaceae; Aspergillus",
    "Astacus leptodactylus\tnarrow-clawed crayfish\t1\t5\t-\t6717\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Astacidea; Astacoidea; Astacidae; Astacus",
    "Astyanax\t-\t1\t2\t-\t7993\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Characiformes; Characoidei; Characidae; Characidae incertae sedis; Astyanax clade; Astyanax",
    "Astyanax mexicanus\tMexican tetra\t1\t2\t-\t7994\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Characiformes; Characoidei; Characidae; Characidae incertae sedis; Astyanax clade; Astyanax",
    "Athetis lepigone\t-\t1\t5\t-\t1223490\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Noctuoidea; Noctuidae; Noctuinae; Athetis",
    "Atractaspis aterrima\tmole viper\t1\t2\t-\t1355159\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Colubroidea; Lamprophiidae; Atractaspidinae; Atractaspis",
    "Aurelia aurita\tmoon jelly\t1\t4\t-\t6145\tINV\tEukaryota; Metazoa; Cnidaria; Scyphozoa; Semaeostomeae; Ulmaridae; Aurelia",
    "Avicennia marina\t-\t1\t1\t11\t82927\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Acanthaceae; Avicennioideae; Avicennia",
    "Bacillus cereus\t-\t11\t0\t-\t1396\tBCT\tBacteria; Firmicutes; Bacilli; Bacillales; Bacillaceae; Bacillus; Bacillus cereus group",
    "Bacillus thuringiensis\t-\t11\t0\t-\t1428\tBCT\tBacteria; Firmicutes; Bacilli; Bacillales; Bacillaceae; Bacillus; Bacillus cereus group",
    "bacterium\t-\t11\t0\t-\t1869227\tBCT\tBacteria",
    "Balaenoptera bonaerensis\tAntarctic minke whale\t1\t2\t-\t33556\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Cetacea; Mysticeti; Balaenopteridae; Balaenoptera",
    "Balearica regulorum gibbericeps\tEast African grey crowned-crane\t1\t2\t-\t100784\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gruiformes; Gruidae; Balearica",
    "Bemisia tabaci\t-\t1\t5\t-\t7038\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Aleyrodoidea; Aleyrodidae; Aleyrodinae; Bemisia",
    "Beta\t-\t1\t1\t11\t3554\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Chenopodiaceae; Betoideae; Beta",
    "Beta vulgaris\t-\t1\t1\t11\t161934\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Chenopodiaceae; Betoideae; Beta",
    "Beta vulgaris subsp. vulgaris\t-\t1\t1\t11\t3555\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Chenopodiaceae; Betoideae; Beta",
    "Betula platyphylla\t-\t1\t1\t11\t78630\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Betulaceae; Betula",
    "Bicyclus\tbush browns\t1\t5\t-\t110367\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Papilionoidea; Nymphalidae; Satyrinae; Satyrini; Mycalesina; Bicyclus",
    "Bicyclus anynana\tsquinting bush brown\t1\t5\t-\t110368\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Papilionoidea; Nymphalidae; Satyrinae; Satyrini; Mycalesina; Bicyclus",
    "Biomphalaria glabrata\t-\t1\t5\t-\t6526\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Panpulmonata; Hygrophila; Lymnaeoidea; Planorbidae; Biomphalaria",
    "Bison bison bison\t-\t1\t2\t-\t43346\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Bovinae; Bison",
    "Bithynia siamensis goniomphalos\t-\t1\t5\t-\t479249\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Gastropoda; Caenogastropoda; Littorinimorpha; Truncatelloidea; Bithyniidae; Bithynia",
    "Boechera\t-\t1\t1\t11\t76872\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Boechereae; Boechera",
    "Boechera gunnisoniana\t-\t1\t1\t11\t93888\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Boechereae; Boechera",
    "Boechera stricta\t-\t1\t1\t11\t72658\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Boechereae; Boechera",
    "Bombina bombina\tfire-bellied toad\t1\t2\t-\t8345\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Amphibia; Batrachia; Anura; Bombinatoridae; Bombina",
    "Bombina variegata variegata\t-\t1\t2\t-\t191472\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Amphibia; Batrachia; Anura; Bombinatoridae; Bombina",
    "Bombus terrestris\tbuff-tailed bumblebee\t1\t5\t-\t30195\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Bombus; Bombus",
    "Bombyx\t-\t1\t5\t-\t7090\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Bombycoidea; Bombycidae; Bombycinae; Bombyx",
    "Bombyx mori\tdomestic silkworm\t1\t5\t-\t7091\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Bombycoidea; Bombycidae; Bombycinae; Bombyx",
    "Bordetella pertussis\t-\t11\t0\t-\t520\tBCT\tBacteria; Proteobacteria; Betaproteobacteria; Burkholderiales; Alcaligenaceae; Bordetella",
    "Bos\toxen, cattle\t1\t2\t-\t9903\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Bovinae; Bos",
    "Bos mutus\twild yak\t1\t2\t-\t72004\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Bovinae; Bos",
    "Bos taurus\tcattle\t1\t2\t-\t9913\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Bovinae; Bos",
    "Botryllus\t-\t1\t13\t-\t30300\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Ascidiacea; Stolidobranchia; Styelidae; Botryllus",
    "Botryllus schlosseri\t-\t1\t13\t-\t30301\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Ascidiacea; Stolidobranchia; Styelidae; Botryllus",
    "Botryococcus\t-\t1\t1\t11\t38880\tPLN\tEukaryota; Viridiplantae; Chlorophyta; Trebouxiophyceae; Elliptochloris clade; Botryococcus",
    "Botryococcus braunii\t-\t1\t1\t11\t38881\tPLN\tEukaryota; Viridiplantae; Chlorophyta; Trebouxiophyceae; Elliptochloris clade; Botryococcus",
    "Brachypodium\tfalse bromes\t1\t1\t11\t15367\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Brachypodieae; Brachypodium",
    "Brachypodium distachyon\tstiff brome\t1\t1\t11\t15368\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Brachypodieae; Brachypodium",
    "Bragasellus molinai\t-\t1\t5\t-\t1281925\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Bragasellus",
    "Bragasellus peltatus\t-\t1\t5\t-\t1282048\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Bragasellus",
    "Branchiostoma\t-\t1\t5\t-\t7737\tINV\tEukaryota; Metazoa; Chordata; Cephalochordata; Branchiostomidae; Branchiostoma",
    "Branchiostoma floridae\tFlorida lancelet\t1\t5\t-\t7739\tINV\tEukaryota; Metazoa; Chordata; Cephalochordata; Branchiostomidae; Branchiostoma",
    "Brassica\t-\t1\t1\t11\t3705\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica juncea\t-\t1\t1\t11\t3707\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica napus\trape\t1\t1\t11\t3708\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica oleracea\twild cabbage\t1\t1\t11\t3712\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica oleracea var. oleracea\t-\t1\t1\t11\t109376\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica oleracea var. viridis\tkale\t1\t1\t11\t3713\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica rapa\tfield mustard\t1\t1\t11\t3711\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica rapa subsp. pekinensis\tChinese cabbage\t1\t1\t11\t51351\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Breviolum\t-\t1\t4\t11\t2499524\tPLN\tEukaryota; Alveolata; Dinophyceae; Suessiales; Symbiodiniaceae; Breviolum",
    "Breviolum minutum\t-\t1\t4\t11\t2499525\tPLN\tEukaryota; Alveolata; Dinophyceae; Suessiales; Symbiodiniaceae; Breviolum; Breviolum minutum",
    "Brugia malayi\t-\t1\t5\t-\t6279\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Spirurina; Spiruromorpha; Filarioidea; Onchocercidae; Brugia",
    "Bubalus bubalis\twater buffalo\t1\t2\t-\t89462\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Bovinae; Bubalus",
    "Buceros rhinoceros silvestris\t-\t1\t2\t-\t175836\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Bucerotiformes; Bucerotidae; Buceros",
    "Burkholderia cenocepacia\t-\t11\t0\t-\t95486\tBCT\tBacteria; Proteobacteria; Betaproteobacteria; Burkholderiales; Burkholderiaceae; Burkholderia; Burkholderia cepacia complex",
    "Burkholderia pseudomallei\t-\t11\t0\t-\t28450\tBCT\tBacteria; Proteobacteria; Betaproteobacteria; Burkholderiales; Burkholderiaceae; Burkholderia; pseudomallei group",
    "Caenorhabditis\t-\t1\t5\t-\t6237\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Rhabditomorpha; Rhabditoidea; Rhabditidae; Peloderinae; Caenorhabditis",
    "Caenorhabditis elegans\t-\t1\t5\t-\t6239\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Rhabditomorpha; Rhabditoidea; Rhabditidae; Peloderinae; Caenorhabditis",
    "Cajanus\t-\t1\t1\t11\t3820\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Cajanus",
    "Cajanus cajan\tpigeon pea\t1\t1\t11\t3821\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Cajanus",
    "Calanus finmarchicus\t-\t1\t5\t-\t6837\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Hexanauplia; Copepoda; Calanoida; Calanidae; Calanus",
    "Calanus glacialis\t-\t1\t5\t-\t113644\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Hexanauplia; Copepoda; Calanoida; Calanidae; Calanus",
    "Callithrix\t-\t1\t2\t-\t9481\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Platyrrhini; Cebidae; Callitrichinae; Callithrix",
    "Callithrix jacchus\twhite-tufted-ear marmoset\t1\t2\t-\t9483\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Platyrrhini; Cebidae; Callitrichinae; Callithrix; Callithrix",
    "Callorhinchus\t-\t1\t2\t-\t7866\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Chondrichthyes; Holocephali; Chimaeriformes; Callorhinchidae; Callorhinchus",
    "Callorhinchus milii\telephant shark\t1\t2\t-\t7868\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Chondrichthyes; Holocephali; Chimaeriformes; Callorhinchidae; Callorhinchus",
    "Calvadosia cruxmelitensis\t-\t1\t4\t-\t1843192\tINV\tEukaryota; Metazoa; Cnidaria; Staurozoa; Stauromedusae; Amyostaurida; Kishinouyeidae; Calvadosia",
    "Camelina sativa\tfalse flax\t1\t1\t11\t90675\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Camelineae; Camelina",
    "Camellia sinensis\t-\t1\t1\t11\t4442\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; Ericales; Theaceae; Camellia",
    "Camellia sinensis var. sinensis\t-\t1\t1\t11\t542762\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; Ericales; Theaceae; Camellia",
    "Camelus bactrianus\tBactrian camel\t1\t2\t-\t9837\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Tylopoda; Camelidae; Camelus",
    "Camelus dromedarius\tArabian camel\t1\t2\t-\t9838\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Tylopoda; Camelidae; Camelus",
    "Camptotheca acuminata\t-\t1\t1\t11\t16922\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; Cornales; Nyssaceae; Camptotheca",
    "Campylobacter jejuni\t-\t11\t0\t-\t197\tBCT\tBacteria; Proteobacteria; Epsilonproteobacteria; Campylobacterales; Campylobacteraceae; Campylobacter",
    "Canis\t-\t1\t2\t-\t9611\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Caniformia; Canidae; Canis",
    "Canis lupus dingo\tdingo\t1\t2\t-\t286419\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Caniformia; Canidae; Canis",
    "Canis lupus familiaris\tdog\t1\t2\t-\t9615\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Caniformia; Canidae; Canis",
    "Capitella\t-\t1\t5\t-\t51293\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Polychaeta; Scolecida; Capitellida; Capitellidae; Capitella",
    "Capitella teleta\t-\t1\t5\t-\t283909\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Polychaeta; Scolecida; Capitellida; Capitellidae; Capitella",
    "Capra hircus\tgoat\t1\t2\t-\t9925\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Caprinae; Capra",
    "Capsicum\tpeppers\t1\t1\t11\t4071\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Capsiceae; Capsicum",
    "Capsicum annuum\t-\t1\t1\t11\t4072\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Capsiceae; Capsicum",
    "Carassius auratus\tgoldfish\t1\t2\t-\t7957\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Carassius",
    "Cariama cristata\tRed-legged seriema\t1\t2\t-\t54380\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Cariamiformes; Cariamidae; Cariama",
    "Carica\t-\t1\t1\t11\t3648\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Caricaceae; Carica",
    "Carica papaya\tpapaya\t1\t1\t11\t3649\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Caricaceae; Carica",
    "Caridina multidentata\t-\t1\t5\t-\t293153\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Caridea; Atyoidea; Atyidae; Caridina",
    "Carlito syrichta\tPhilippine tarsier\t1\t2\t-\t1868482\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Tarsiiformes; Tarsiidae; Carlito",
    "Catharanthus roseus\tMadagascar periwinkle\t1\t1\t11\t4058\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Apocynaceae; Rauvolfioideae; Vinceae; Catharanthinae; Catharanthus",
    "Cavia porcellus\tdomestic guinea pig\t1\t2\t-\t10141\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Hystricomorpha; Caviidae; Cavia",
    "Cenchrus americanus\t-\t1\t1\t11\t4543\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Cenchrinae; Cenchrus",
    "Centaurea\t-\t1\t1\t11\t41503\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Carduoideae; Cardueae; Centaureinae; Centaurea",
    "Ceratotherium simum simum\tsouthern white rhinoceros\t1\t2\t-\t73337\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Perissodactyla; Rhinocerotidae; Ceratotherium",
    "Cercocebus atys\tsooty mangabey\t1\t2\t-\t9531\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Cercocebus",
    "Chelonia\t-\t1\t2\t-\t8468\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Testudines; Cryptodira; Durocryptodira; Americhelydia; Chelonioidea; Cheloniidae; Chelonia",
    "Chelonia mydas\tGreen sea turtle\t1\t2\t-\t8469\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Testudines; Cryptodira; Durocryptodira; Americhelydia; Chelonioidea; Cheloniidae; Chelonia",
    "Cherax quadricarinatus\t-\t1\t5\t-\t27406\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Astacidea; Parastacoidea; Parastacidae; Cherax",
    "Chinchilla lanigera\tlong-tailed chinchilla\t1\t2\t-\t34839\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Hystricomorpha; Chinchillidae; Chinchilla",
    "Chlamydia trachomatis\t-\t11\t0\t-\t813\tBCT\tBacteria; Chlamydiae; Chlamydiales; Chlamydiaceae; Chlamydia/Chlamydophila group; Chlamydia",
    "Chlamydomonas\t-\t1\t1\t11\t3052\tPLN\tEukaryota; Viridiplantae; Chlorophyta; Chlorophyceae; Chlamydomonadales; Chlamydomonadaceae; Chlamydomonas",
    "Chlamydomonas reinhardtii\t-\t1\t1\t11\t3055\tPLN\tEukaryota; Viridiplantae; Chlorophyta; Chlorophyceae; Chlamydomonadales; Chlamydomonadaceae; Chlamydomonas",
    "Chlamydotis macqueenii\tMacqueen's bustard\t1\t2\t-\t187382\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gruiformes; Otididae; Chlamydotis",
    "Chlorocebus\t-\t1\t2\t-\t392815\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Chlorocebus",
    "Chlorocebus aethiops\tgrivet\t1\t2\t-\t9534\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Chlorocebus",
    "Chlorocebus sabaeus\tgreen monkey\t1\t2\t-\t60711\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Chlorocebus",
    "Chorispora bungeana\t-\t1\t1\t11\t238895\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Chorisporeae; Chorispora",
    "Chromolaena odorata\t-\t1\t1\t11\t103745\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Heliantheae alliance; Eupatorieae; Chromolaena",
    "Chrysemys picta bellii\twestern painted turtle\t1\t2\t-\t8478\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Testudines; Cryptodira; Durocryptodira; Testudinoidea; Emydidae; Chrysemys",
    "Chrysochloris asiatica\tCape golden mole\t1\t2\t-\t185453\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Afrotheria; Chrysochloridae; Chrysochlorinae; Chrysochloris",
    "Cicer\t-\t1\t1\t11\t3826\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Cicereae; Cicer",
    "Cicer arietinum\tchickpea\t1\t1\t11\t3827\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Cicereae; Cicer",
    "Ciona\t-\t1\t13\t-\t7718\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Ascidiacea; Enterogona; Phlebobranchia; Cionidae; Ciona",
    "Ciona intestinalis\tvase tunicate\t1\t13\t-\t7719\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Ascidiacea; Enterogona; Phlebobranchia; Cionidae; Ciona",
    "Ciona savignyi\tPacific transparent sea squirt\t1\t13\t-\t51511\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Ascidiacea; Enterogona; Phlebobranchia; Cionidae; Ciona",
    "Citrus\t-\t1\t1\t11\t2706\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Sapindales; Rutaceae; Aurantioideae; Citrus",
    "Citrus clementina\t-\t1\t1\t11\t85681\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Sapindales; Rutaceae; Aurantioideae; Citrus",
    "Citrus sinensis\tsweet orange\t1\t1\t11\t2711\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Sapindales; Rutaceae; Aurantioideae; Citrus",
    "Clonorchis\t-\t1\t9\t-\t79922\tINV\tEukaryota; Metazoa; Platyhelminthes; Trematoda; Digenea; Opisthorchiida; Opisthorchiata; Opisthorchiidae; Clonorchis",
    "Clonorchis sinensis\t-\t1\t9\t-\t79923\tINV\tEukaryota; Metazoa; Platyhelminthes; Trematoda; Digenea; Opisthorchiida; Opisthorchiata; Opisthorchiidae; Clonorchis",
    "Clostridioides difficile\t-\t11\t0\t-\t1496\tBCT\tBacteria; Firmicutes; Clostridia; Clostridiales; Peptostreptococcaceae; Clostridioides",
    "Clytia\t-\t1\t4\t-\t13436\tINV\tEukaryota; Metazoa; Cnidaria; Hydrozoa; Hydroidolina; Leptothecata; Campanulariidae; Clytia",
    "Clytia hemisphaerica\t-\t1\t4\t-\t252671\tINV\tEukaryota; Metazoa; Cnidaria; Hydrozoa; Hydroidolina; Leptothecata; Campanulariidae; Clytia",
    "Coccidioides\t-\t1\t4\t-\t5500\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Eurotiomycetes; Eurotiomycetidae; Onygenales; Onygenales incertae sedis; Coccidioides",
    "Coccidioides posadasii\t-\t1\t4\t-\t199306\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Eurotiomycetes; Eurotiomycetidae; Onygenales; Onygenales incertae sedis; Coccidioides",
    "Cocos nucifera\tcoconut palm\t1\t1\t11\t13894\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Arecaceae; Arecoideae; Cocoseae; Attaleinae; Cocos",
    "Coffea\t-\t1\t1\t11\t13442\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Rubiaceae; Ixoroideae; Gardenieae complex; Bertiereae - Coffeeae clade; Coffeeae; Coffea",
    "Coffea arabica\tcoffee\t1\t1\t11\t13443\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Rubiaceae; Ixoroideae; Gardenieae complex; Bertiereae - Coffeeae clade; Coffeeae; Coffea",
    "Coffea canephora\t-\t1\t1\t11\t49390\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Rubiaceae; Ixoroideae; Gardenieae complex; Bertiereae - Coffeeae clade; Coffeeae; Coffea",
    "Colius striatus\tspeckled mousebird\t1\t2\t-\t57412\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Coliiformes; Coliidae; Colius",
    "Colletotrichum\t-\t1\t4\t-\t5455\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Sordariomycetes; Hypocreomycetidae; Glomerellales; Glomerellaceae; Colletotrichum",
    "Colletotrichum graminicola\t-\t1\t4\t-\t31870\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Sordariomycetes; Hypocreomycetidae; Glomerellales; Glomerellaceae; Colletotrichum",
    "Condylura cristata\tstar-nosed mole\t1\t2\t-\t143302\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Eulipotyphla; Talpidae; Condylura",
    "Coptotermes\t-\t1\t5\t-\t36986\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Polyneoptera; Dictyoptera; Blattodea; Blattoidea; Termitoidae; Rhinotermitidae; Coptotermes",
    "Coptotermes formosanus\tFormosan subterranean termite\t1\t5\t-\t36987\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Polyneoptera; Dictyoptera; Blattodea; Blattoidea; Termitoidae; Rhinotermitidae; Coptotermes",
    "Crassostrea\t-\t1\t5\t-\t6564\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Bivalvia; Pteriomorphia; Ostreoida; Ostreoidea; Ostreidae; Crassostrea",
    "Crassostrea gigas\tPacific oyster\t1\t5\t-\t29159\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Bivalvia; Pteriomorphia; Ostreoida; Ostreoidea; Ostreidae; Crassostrea",
    "Cricetulus griseus\tChinese hamster\t1\t2\t-\t10029\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Cricetidae; Cricetinae; Cricetulus",
    "Cryptomeria\t-\t1\t1\t11\t3368\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Pinidae; Cupressales; Cupressaceae; Cryptomeria",
    "Cryptomeria japonica\tJapanese cedar\t1\t1\t11\t3369\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Pinidae; Cupressales; Cupressaceae; Cryptomeria",
    "Cryptosporidium\t-\t1\t4\t4\t5806\tINV\tEukaryota; Alveolata; Apicomplexa; Conoidasida; Coccidia; Eucoccidiorida; Eimeriorina; Cryptosporidiidae; Cryptosporidium",
    "Cryptotermes secundus\t-\t1\t5\t-\t105785\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Polyneoptera; Dictyoptera; Blattodea; Blattoidea; Termitoidae; Kalotermitidae; Cryptotermitinae; Cryptotermes",
    "Cucumis\t-\t1\t1\t11\t3655\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Cucurbitales; Cucurbitaceae; Benincaseae; Cucumis",
    "Cucumis melo\tmuskmelon\t1\t1\t11\t3656\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Cucurbitales; Cucurbitaceae; Benincaseae; Cucumis",
    "Cucumis sativus\tcucumber\t1\t1\t11\t3659\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Cucurbitales; Cucurbitaceae; Benincaseae; Cucumis",
    "Culex\t-\t1\t5\t-\t7174\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Nematocera; Culicoidea; Culicidae; Culicinae; Culicini; Culex",
    "Culex quinquefasciatus\tsouthern house mosquito\t1\t5\t-\t7176\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Nematocera; Culicoidea; Culicidae; Culicinae; Culicini; Culex; Culex",
    "Cuscuta pentagona\t-\t1\t1\t11\t112407\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Cuscuteae; Cuscuta; Grammica; Cuscuta sect. Cleistogrammica",
    "Cynara cardunculus var. scolymus\t-\t1\t1\t11\t59895\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Carduoideae; Cardueae; Carduinae; Cynara",
    "Cynoglossus semilaevis\ttongue sole\t1\t2\t-\t244447\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Carangaria; Pleuronectiformes; Pleuronectoidei; Cynoglossidae; Cynoglossinae; Cynoglossus",
    "Cynopterus sphinx\tIndian short-nosed fruit bat\t1\t2\t-\t9400\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Megachiroptera; Pteropodidae; Pteropodinae; Cynopterus",
    "Cyprinus\t-\t1\t2\t-\t7961\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Cyprinus",
    "Cyprinus carpio\tcommon carp\t1\t2\t-\t7962\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Cyprinus",
    "Danio\t-\t1\t2\t-\t7954\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Danio",
    "Danio rerio\tzebrafish\t1\t2\t-\t7955\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Danio",
    "Daphnia\tcommon water fleas\t1\t5\t-\t6668\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Branchiopoda; Diplostraca; Cladocera; Anomopoda; Daphniidae; Daphnia",
    "Daphnia magna\t-\t1\t5\t-\t35525\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Branchiopoda; Diplostraca; Cladocera; Anomopoda; Daphniidae; Daphnia",
    "Daphnia pulex\tcommon water flea\t1\t5\t-\t6669\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Branchiopoda; Diplostraca; Cladocera; Anomopoda; Daphniidae; Daphnia",
    "Dasypus novemcinctus\tnine-banded armadillo\t1\t2\t-\t9361\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Xenarthra; Cingulata; Dasypodidae; Dasypus",
    "Dendrobium catenatum\t-\t1\t1\t11\t906689\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Asparagales; Orchidaceae; Epidendroideae; Malaxideae; Dendrobiinae; Dendrobium",
    "Dendroctonus\t-\t1\t5\t-\t77156\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Coleoptera; Polyphaga; Cucujiformia; Curculionidae; Scolytinae; Dendroctonus",
    "Dendroctonus ponderosae\tmountain pine beetle\t1\t5\t-\t77166\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Coleoptera; Polyphaga; Cucujiformia; Curculionidae; Scolytinae; Dendroctonus",
    "Diacamma sp. Okinawa-2006a\t-\t1\t5\t-\t655490\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Ponerinae; Ponerini; Diacamma",
    "Diaphorina citri\tAsian citrus psyllid\t1\t5\t-\t121845\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Psylloidea; Liviidae; Diaphorina",
    "Dicentrarchus labrax\tEuropean seabass\t1\t2\t-\t13489\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Moronidae; Dicentrarchus",
    "Dicrocoelium dendriticum\t-\t1\t9\t-\t57078\tINV\tEukaryota; Metazoa; Platyhelminthes; Trematoda; Digenea; Plagiorchiida; Xiphidiata; Gorgoderoidea; Dicrocoeliidae; Dicrocoelium",
    "Dictyostelium\t-\t1\t1\t11\t5782\tINV\tEukaryota; Amoebozoa; Mycetozoa; Dictyostelids; Dictyosteliales; Dictyosteliaceae; Dictyostelium",
    "Dictyostelium discoideum\t-\t1\t1\t11\t44689\tINV\tEukaryota; Amoebozoa; Mycetozoa; Dictyostelids; Dictyosteliales; Dictyosteliaceae; Dictyostelium",
    "Diospyros lotus\t-\t1\t1\t11\t55363\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; Ericales; Ebenaceae; Diospyros",
    "Diploscapter\t-\t1\t5\t-\t55799\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Rhabditomorpha; Rhabditoidea; Rhabditidae; Diploscapter",
    "Diploscapter coronatus\t-\t1\t5\t-\t288516\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Rhabditomorpha; Rhabditoidea; Rhabditidae; Diploscapter",
    "Dipodomys ordii\tOrd's kangaroo rat\t1\t2\t-\t10020\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Castorimorpha; Heteromyidae; Dipodomyinae; Dipodomys",
    "Dorcoceras hygrometricum\t-\t1\t1\t11\t472368\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Gesneriaceae; Didymocarpoideae; Trichosporeae; Loxocarpinae; Dorcoceras",
    "Drosophila\tfruit flies\t1\t5\t-\t7215\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Ephydroidea; Drosophilidae; Drosophila",
    "Drosophila ananassae\t-\t1\t5\t-\t7217\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Ephydroidea; Drosophilidae; Drosophila; Sophophora",
    "Drosophila melanogaster\tfruit fly\t1\t5\t-\t7227\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Ephydroidea; Drosophilidae; Drosophila; Sophophora",
    "Drosophila sechellia\t-\t1\t5\t-\t7238\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Ephydroidea; Drosophilidae; Drosophila; Sophophora",
    "Drosophila simulans\t-\t1\t5\t-\t7240\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Ephydroidea; Drosophilidae; Drosophila; Sophophora",
    "Dugesia japonica\t-\t1\t9\t-\t6161\tINV\tEukaryota; Metazoa; Platyhelminthes; Rhabditophora; Seriata; Tricladida; Continenticola; Geoplanoidea; Dugesiidae; Dugesia",
    "Echinarachnius parma\t-\t1\t9\t-\t869203\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Gnathostomata; Clypeasteroida; Echinarachniidae; Echinarachnius",
    "Echinaster spinulosus\t-\t1\t9\t-\t1451296\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Spinulosacea; Spinulosida; Echinasteridae; Echinaster",
    "Echinococcus multilocularis\t-\t1\t9\t-\t6211\tINV\tEukaryota; Metazoa; Platyhelminthes; Cestoda; Eucestoda; Cyclophyllidea; Taeniidae; Echinococcus",
    "Echinops telfairi\tsmall Madagascar hedgehog\t1\t2\t-\t9371\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Afrotheria; Tenrecidae; Tenrecinae; Echinops",
    "Eimeria\t-\t1\t4\t4\t5800\tINV\tEukaryota; Alveolata; Apicomplexa; Conoidasida; Coccidia; Eucoccidiorida; Eimeriorina; Eimeriidae; Eimeria",
    "Elaeis guineensis\tAfrican oil palm\t1\t1\t11\t51953\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Arecaceae; Arecoideae; Cocoseae; Elaeidinae; Elaeis",
    "Elephantulus edwardii\tCape elephant shrew\t1\t2\t-\t28737\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Afrotheria; Macroscelidea; Macroscelididae; Elephantulus",
    "Elliptio complanata\teastern elliptio\t1\t5\t-\t55832\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Bivalvia; Palaeoheterodonta; Unionoida; Unionoidea; Unionidae; Ambleminae; Elliptio",
    "Elodea nuttallii\t-\t1\t1\t11\t55313\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Hydrocharitaceae; Elodea",
    "Emiliania\t-\t1\t4\t11\t2902\tPLN\tEukaryota; Haptophyceae; Isochrysidales; Noelaerhabdaceae; Emiliania",
    "Emiliania huxleyi\t-\t1\t4\t11\t2903\tPLN\tEukaryota; Haptophyceae; Isochrysidales; Noelaerhabdaceae; Emiliania",
    "Entamoeba\t-\t1\t1\t11\t5758\tINV\tEukaryota; Amoebozoa; Archamoebae; Entamoebidae; Entamoeba",
    "Entamoeba histolytica\t-\t1\t1\t11\t5759\tINV\tEukaryota; Amoebozoa; Archamoebae; Entamoebidae; Entamoeba",
    "Enterococcus faecalis\t-\t11\t0\t-\t1351\tBCT\tBacteria; Firmicutes; Bacilli; Lactobacillales; Enterococcaceae; Enterococcus",
    "Enterococcus faecium\t-\t11\t0\t-\t1352\tBCT\tBacteria; Firmicutes; Bacilli; Lactobacillales; Enterococcaceae; Enterococcus",
    "Eptesicus fuscus\tbig brown bat\t1\t2\t-\t29078\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Microchiroptera; Vespertilionidae; Eptesicus",
    "Equus caballus\thorse\t1\t2\t-\t9796\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Perissodactyla; Equidae; Equus",
    "Equus przewalskii\tPrzewalski's horse\t1\t2\t-\t9798\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Perissodactyla; Equidae; Equus",
    "Erinaceus europaeus\twestern European hedgehog\t1\t2\t-\t9365\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Eulipotyphla; Erinaceidae; Erinaceinae; Erinaceus",
    "Eriocheir sinensis\tChinese mitten crab\t1\t5\t-\t95602\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Brachyura; Eubrachyura; Grapsoidea; Varunidae; Eriocheir",
    "Erythranthe\t-\t1\t1\t11\t1502711\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Phrymaceae; Erythranthe",
    "Erythranthe guttata\tspotted monkey flower\t1\t1\t11\t4155\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Phrymaceae; Erythranthe",
    "Escherichia\t-\t11\t0\t-\t561\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Escherichia",
    "Escherichia coli\t-\t11\t0\t-\t562\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Escherichia",
    "Escherichia coli O26:H11\t-\t11\t0\t-\t244319\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Escherichia",
    "Esox lucius\tnorthern pike\t1\t2\t-\t8010\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Esociformes; Esocidae; Esox",
    "Eucalyptus\t-\t1\t1\t11\t3932\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Myrtales; Myrtaceae; Myrtoideae; Eucalypteae; Eucalyptus",
    "Eucalyptus camaldulensis\tMurray red gum\t1\t1\t11\t34316\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Myrtales; Myrtaceae; Myrtoideae; Eucalypteae; Eucalyptus",
    "Eucalyptus grandis\t-\t1\t1\t11\t71139\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Myrtales; Myrtaceae; Myrtoideae; Eucalypteae; Eucalyptus",
    "Eucidaris tribuloides\t-\t1\t9\t-\t7632\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Perischoechinoidea; Cidaroida; Cidaridae; Eucidaris",
    "Eufriesea mexicana\t-\t1\t5\t-\t516756\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Eufriesea",
    "Eurypyga helias\tsunbittern\t1\t2\t-\t54383\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gruiformes; Eurypygidae; Eurypyga",
    "Exaiptasia pallida\t-\t1\t4\t-\t1720309\tINV\tEukaryota; Metazoa; Cnidaria; Anthozoa; Hexacorallia; Actiniaria; Aiptasiidae; Exaiptasia",
    "Extatosoma tiaratum\tgiant prickly stick insect\t1\t5\t-\t7024\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Polyneoptera; Phasmatodea; Verophasmatodea; Anareolatae; Phasmatidae; Tropidoderinae; Extatosoma",
    "Fagopyrum esculentum\tcommon buckwheat\t1\t1\t11\t3617\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Polygonaceae; Polygonoideae; Fagopyreae; Fagopyrum",
    "Fagus sylvatica\tEuropean beech\t1\t1\t11\t28930\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Fagaceae; Fagus",
    "Falco\tfalcons\t1\t2\t-\t8952\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Falconiformes; Falconidae; Falco",
    "Fasciola hepatica\tliver fluke\t1\t9\t-\t6192\tINV\tEukaryota; Metazoa; Platyhelminthes; Trematoda; Digenea; Plagiorchiida; Echinostomata; Echinostomatoidea; Fasciolidae; Fasciola",
    "Felis catus\tdomestic cat\t1\t2\t-\t9685\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Feliformia; Felidae; Felinae; Felis",
    "Festuca\t-\t1\t1\t11\t4605\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Poodae; Poeae; Poeae Chloroplast Group 2 (Poeae type); Loliinae; Festuca",
    "Festuca arundinacea\t-\t1\t1\t11\t4606\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Poodae; Poeae; Poeae Chloroplast Group 2 (Poeae type); Loliinae; Festuca",
    "Ficus carica\tcommon fig\t1\t1\t11\t3494\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Moraceae; Ficus",
    "fish metagenome\t-\t11\t2\t11\t496924\tENV\tunclassified sequences; metagenomes; organismal metagenomes",
    "Formica aquilonia\t-\t1\t5\t-\t258703\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Formicinae; Formica",
    "Formica cinerea\t-\t1\t5\t-\t609761\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Formicinae; Formica",
    "Formica exsecta\t-\t1\t5\t-\t72781\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Formicinae; Formica",
    "Formica fusca\t-\t1\t5\t-\t72779\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Formicinae; Formica",
    "Formica pratensis\t-\t1\t5\t-\t221681\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Formicinae; Formica",
    "Formica pressilabris\t-\t1\t5\t-\t609858\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Formicinae; Formica",
    "Formica truncorum\t-\t1\t5\t-\t72783\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Formicinae; Formica",
    "Fragaria x ananassa\tstrawberry\t1\t1\t11\t3747\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Rosoideae; Potentilleae; Fragariinae; Fragaria",
    "Frankliniella occidentalis\twestern flower thrips\t1\t5\t-\t133901\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Thysanoptera; Terebrantia; Thripoidea; Thripidae; Frankliniella",
    "Fukomys damarensis\tDamara mole-rat\t1\t2\t-\t885580\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Hystricomorpha; Bathyergidae; Fukomys",
    "Fulmarus glacialis\tNorthern fulmar\t1\t2\t-\t30455\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Procellariiformes; Procellariidae; Fulmarus",
    "Fundulus\t-\t1\t2\t-\t8077\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Fundulidae; Fundulus",
    "Fundulus grandis\tGulf killifish\t1\t2\t-\t34779\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Fundulidae; Fundulus",
    "Fundulus heteroclitus\tmummichog\t1\t2\t-\t8078\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Fundulidae; Fundulus",
    "Fusarium\t-\t1\t4\t-\t5506\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Sordariomycetes; Hypocreomycetidae; Hypocreales; Nectriaceae; Fusarium",
    "Fusarium verticillioides\t-\t1\t4\t-\t117187\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Sordariomycetes; Hypocreomycetidae; Hypocreales; Nectriaceae; Fusarium; Fusarium fujikuroi species complex",
    "Gadus\t-\t1\t2\t-\t8048\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Zeiogadaria; Gadariae; Gadiformes; Gadoidei; Gadidae; Gadus",
    "Gadus morhua\tAtlantic cod\t1\t2\t-\t8049\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Zeiogadaria; Gadariae; Gadiformes; Gadoidei; Gadidae; Gadus",
    "Galeopterus variegatus\tSunda flying lemur\t1\t2\t-\t482537\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Dermoptera; Cynocephalidae; Galeopterus",
    "Gallus\t-\t1\t2\t-\t9030\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Galliformes; Phasianidae; Phasianinae; Gallus",
    "Gallus gallus\tchicken\t1\t2\t-\t9031\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Galliformes; Phasianidae; Phasianinae; Gallus",
    "Gardenia jasminoides\t-\t1\t1\t11\t114476\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Rubiaceae; Ixoroideae; Gardenieae complex; Gardenieae - Pavetteae clade; Gardenieae; Gardenia",
    "Gasterosteus\t-\t1\t2\t-\t69292\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Perciformes; Cottioidei; Gasterosteales; Gasterosteidae; Gasterosteus",
    "Gasterosteus aculeatus\tthree-spined stickleback\t1\t2\t-\t69293\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Perciformes; Cottioidei; Gasterosteales; Gasterosteidae; Gasterosteus",
    "Gavia stellata\tred-throated loon\t1\t2\t-\t37040\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gaviiformes; Gaviidae; Gavia",
    "Gekko japonicus\t-\t1\t2\t-\t146911\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Gekkota; Gekkonidae; Gekkoninae; Gekko",
    "Gene trapping vector VICTR76\t-\t11\t0\t11\t447635\tSYN\tother sequences; artificial sequences; vectors",
    "Geranium pyrenaicum\t-\t1\t1\t11\t379953\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Geraniales; Geraniaceae; Geranium",
    "Geranium robertianum\t-\t1\t1\t11\t122183\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Geraniales; Geraniaceae; Geranium",
    "Gigaspora margarita\t-\t1\t4\t-\t4874\tPLN\tEukaryota; Fungi; Fungi incertae sedis; Mucoromycota; Glomeromycotina; Glomeromycetes; Diversisporales; Gigasporaceae; Gigaspora",
    "Glossoscolex paulistus\t-\t1\t5\t-\t1046353\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Clitellata; Oligochaeta; Haplotaxida; Lumbricina; Glossoscolecidae; Glossoscolex",
    "Glycera dibranchiata\t-\t1\t5\t-\t6350\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Polychaeta; Palpata; Aciculata; Phyllodocida; Glyceridae; Glycera",
    "Glycine\t-\t1\t1\t11\t3846\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine",
    "Glycine canescens\t-\t1\t1\t11\t48924\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine; Glycine",
    "Glycine cyrtoloba\t-\t1\t1\t11\t45689\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine; Glycine",
    "Glycine dolichocarpa\t-\t1\t1\t11\t82538\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine; Glycine",
    "Glycine falcata\t-\t1\t1\t11\t45690\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine; Glycine",
    "Glycine max\tsoybean\t1\t1\t11\t3847\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine; Soja",
    "Glycine soja\t-\t1\t1\t11\t3848\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine; Soja",
    "Glycine stenophita\t-\t1\t1\t11\t96944\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine; Glycine",
    "Glycine syndetika\t-\t1\t1\t11\t713886\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine; Glycine",
    "Glycine tomentella\t-\t1\t1\t11\t44015\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Glycine; Glycine",
    "Gorilla gorilla gorilla\twestern lowland gorilla\t1\t2\t-\t9595\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Hominidae; Gorilla",
    "Gossypium\t-\t1\t1\t11\t3633\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Malvoideae; Gossypium",
    "Gossypium arboreum\t-\t1\t1\t11\t29729\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Malvoideae; Gossypium",
    "Gossypium hirsutum\tcotton\t1\t1\t11\t3635\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Malvoideae; Gossypium",
    "Gossypium raimondii\t-\t1\t1\t11\t29730\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Malvoideae; Gossypium",
    "gut metagenome\t-\t11\t2\t11\t749906\tENV\tunclassified sequences; metagenomes; organismal metagenomes",
    "Haemophilus influenzae\t-\t11\t0\t-\t727\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Pasteurellales; Pasteurellaceae; Haemophilus",
    "Haliaeetus albicilla\twhite-tailed eagle\t1\t2\t-\t8969\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Falconiformes; Accipitridae; Accipitrinae; Haliaeetus",
    "Haliclystus sanjuanensis\t-\t1\t4\t-\t168739\tINV\tEukaryota; Metazoa; Cnidaria; Staurozoa; Stauromedusae; Myostaurida; Haliclystidae; Haliclystus",
    "Halocynthia\t-\t1\t13\t-\t7728\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Ascidiacea; Stolidobranchia; Pyuridae; Halocynthia",
    "Halocynthia roretzi\t-\t1\t13\t-\t7729\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Ascidiacea; Stolidobranchia; Pyuridae; Halocynthia",
    "Haplochromis burtoni\tBurton's mouthbrooder\t1\t2\t-\t8153\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Haplochromini; Haplochromis",
    "Helianthus\t-\t1\t1\t11\t4231\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Heliantheae alliance; Heliantheae; Helianthus",
    "Helianthus annuus\tcommon sunflower\t1\t1\t11\t4232\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Heliantheae alliance; Heliantheae; Helianthus",
    "Helicobacter pylori\t-\t11\t0\t-\t210\tBCT\tBacteria; Proteobacteria; Epsilonproteobacteria; Campylobacterales; Helicobacteraceae; Helicobacter",
    "Helicoverpa armigera\tcotton bollworm\t1\t5\t-\t29058\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Noctuoidea; Noctuidae; Heliothinae; Helicoverpa",
    "Helobdella\t-\t1\t5\t-\t6411\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Clitellata; Hirudinea; Hirudinida; Glossiphoniiformes; Glossiphoniidae; Helobdella",
    "Helobdella robusta\t-\t1\t5\t-\t6412\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Clitellata; Hirudinea; Hirudinida; Glossiphoniiformes; Glossiphoniidae; Helobdella",
    "Hemicentrotus pulcherrimus\t-\t1\t9\t-\t7650\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Echinoida; Strongylocentrotidae; Hemicentrotus",
    "Henricia sp. AR-2014\t-\t1\t9\t-\t1462731\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Spinulosacea; Spinulosida; Echinasteridae; Henricia",
    "Hepacivirus C\t-\t1\t0\t-\t11103\tVRL\tViruses; ssRNA viruses; ssRNA positive-strand viruses, no DNA stage; Flaviviridae; Hepacivirus",
    "Hepatitis B virus\t-\t1\t0\t-\t10407\tVRL\tViruses; Retro-transcribing viruses; Hepadnaviridae; Orthohepadnavirus",
    "Heterocephalus glaber\tnaked mole-rat\t1\t2\t-\t10181\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Hystricomorpha; Bathyergidae; Heterocephalus",
    "Hevea brasiliensis\trubber tree\t1\t1\t11\t3981\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Crotonoideae; Micrandreae; Hevea",
    "Hippocampus comes\ttiger tail seahorse\t1\t2\t-\t109280\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Syngnathiaria; Syngnathiformes; Syngnathoidei; Syngnathidae; Hippocampus",
    "Hirudo\t-\t1\t5\t-\t6420\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Clitellata; Hirudinea; Hirudinida; Hirudiniformes; Hirudinidae; Hirudo",
    "Hirudo medicinalis\tmedicinal leech\t1\t5\t-\t6421\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Clitellata; Hirudinea; Hirudinida; Hirudiniformes; Hirudinidae; Hirudo",
    "Homo\t-\t1\t2\t-\t9605\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Hominidae; Homo",
    "Homo sapiens\thuman\t1\t2\t-\t9606\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Hominidae; Homo",
    "Hordeum\t-\t1\t1\t11\t4512\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Hordeinae; Hordeum",
    "Hordeum pubiflorum\t-\t1\t1\t11\t112521\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Hordeinae; Hordeum",
    "Hordeum vulgare\t-\t1\t1\t11\t4513\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Hordeinae; Hordeum",
    "Hordeum vulgare subsp. vulgare\tdomesticated barley\t1\t1\t11\t112509\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Hordeinae; Hordeum",
    "Hucho taimen\ttaimen\t1\t2\t-\t201498\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Hucho",
    "human gut metagenome\t-\t11\t2\t11\t408170\tENV\tunclassified sequences; metagenomes; organismal metagenomes",
    "Human immunodeficiency virus 1\t-\t1\t0\t-\t11676\tVRL\tViruses; Ortervirales; Retroviridae; Orthoretrovirinae; Lentivirus",
    "Humulus lupulus\tEuropean hop\t1\t1\t11\t3486\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Cannabaceae; Humulus",
    "Humulus lupulus var. cordifolius\t-\t1\t1\t11\t278022\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Cannabaceae; Humulus",
    "Humulus lupulus var. lupulus\t-\t1\t1\t11\t1571165\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Cannabaceae; Humulus",
    "Hydra\t-\t1\t4\t-\t6083\tINV\tEukaryota; Metazoa; Cnidaria; Hydrozoa; Hydroidolina; Anthoathecata; Aplanulata; Hydridae; Hydra",
    "Hydra vulgaris\t-\t1\t4\t-\t6087\tINV\tEukaryota; Metazoa; Cnidaria; Hydrozoa; Hydroidolina; Anthoathecata; Aplanulata; Hydridae; Hydra",
    "Hynobius chinensis\tChinese salamander\t1\t2\t-\t288313\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Amphibia; Batrachia; Caudata; Cryptobranchoidea; Hynobiidae; Hynobius; Hynobius",
    "Hynobius retardatus\tHokkaido salamander\t1\t2\t-\t36312\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Amphibia; Batrachia; Caudata; Cryptobranchoidea; Hynobiidae; Hynobius; Satobius",
    "Ictalurus\t-\t1\t2\t-\t7997\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Siluriformes; Ictaluridae; Ictalurus",
    "Ictalurus furcatus\tblue catfish\t1\t2\t-\t66913\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Siluriformes; Ictaluridae; Ictalurus",
    "Ictalurus punctatus\tchannel catfish\t1\t2\t-\t7998\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Siluriformes; Ictaluridae; Ictalurus",
    "Ictidomys tridecemlineatus\tthirteen-lined ground squirrel\t1\t2\t-\t43179\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Sciuromorpha; Sciuridae; Xerinae; Marmotini; Ictidomys",
    "Influenza A virus\t-\t1\t0\t-\t11320\tVRL\tViruses; ssRNA viruses; ssRNA negative-strand viruses; Negarnaviricota; Polyploviricotina; Insthoviricetes; Articulavirales; Orthomyxoviridae; Alphainfluenzavirus",
    "Ipomoea\t-\t1\t1\t11\t4119\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Ipomoeeae; Ipomoea",
    "Ipomoea batatas\tsweet potato\t1\t1\t11\t4120\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Ipomoeeae; Ipomoea",
    "Ipomoea nil\tJapanese morning glory\t1\t1\t11\t35883\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Ipomoeeae; Ipomoea",
    "Ipomoea purpurea\tcommon morning-glory\t1\t1\t11\t4121\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Ipomoeeae; Ipomoea",
    "Ipomoea trifida\t-\t1\t1\t11\t35884\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Ipomoeeae; Ipomoea",
    "Ixodes\t-\t1\t5\t-\t6944\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Ixodida; Ixodoidea; Ixodidae; Ixodinae; Ixodes",
    "Ixodes scapularis\tblack-legged tick\t1\t5\t-\t6945\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Ixodida; Ixodoidea; Ixodidae; Ixodinae; Ixodes",
    "Jaculus jaculus\tlesser Egyptian jerboa\t1\t2\t-\t51337\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Dipodoidea; Dipodidae; Dipodinae; Jaculus",
    "Jatropha curcas\t-\t1\t1\t11\t180498\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Crotonoideae; Jatropheae; Jatropha",
    "Juglans regia\tEnglish walnut\t1\t1\t11\t51240\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Juglandaceae; Juglans",
    "Karelinia caspia\t-\t1\t1\t11\t313960\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Inuleae; Plucheinae; Karelinia",
    "Kerria lacca\tcommon lac scale\t1\t5\t-\t473130\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Coccoidea; Kerriidae; Kerria",
    "Klebsiella pneumoniae\t-\t11\t0\t-\t573\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Klebsiella",
    "Klebsiella pneumoniae subsp. pneumoniae\t-\t11\t0\t-\t72407\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Klebsiella",
    "Lactuca\t-\t1\t1\t11\t4235\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Cichorioideae; Cichorieae; Lactucinae; Lactuca",
    "Lactuca sativa\t-\t1\t1\t11\t4236\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Cichorioideae; Cichorieae; Lactucinae; Lactuca",
    "Lactuca serriola\t-\t1\t1\t11\t75943\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Cichorioideae; Cichorieae; Lactucinae; Lactuca",
    "Lasius neglectus\t-\t1\t5\t-\t111072\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Formicinae; Lasius; Lasius",
    "Lasius turcicus\t-\t1\t5\t-\t235463\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Formicinae; Lasius; Lasius",
    "Lates calcarifer\tbarramundi perch\t1\t2\t-\t8187\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Carangaria; Carangaria incertae sedis; Centropomidae; Lates",
    "Lathyrus sativus\t-\t1\t1\t11\t3860\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Fabeae; Lathyrus",
    "Latimeria chalumnae\tcoelacanth\t1\t2\t-\t7897\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Coelacanthiformes; Coelacanthidae; Latimeria",
    "Latrodectus hesperus\twestern black widow\t1\t5\t-\t256737\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Arachnida; Araneae; Araneomorphae; Entelegynae; Araneoidea; Theridiidae; Latrodectus",
    "Lepeophtheirus\t-\t1\t5\t-\t72035\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Hexanauplia; Copepoda; Siphonostomatoida; Caligidae; Lepeophtheirus",
    "Lepeophtheirus salmonis\tsalmon louse\t1\t5\t-\t72036\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Hexanauplia; Copepoda; Siphonostomatoida; Caligidae; Lepeophtheirus",
    "Lepidonotothen nudifrons\tyellowfin notie\t1\t2\t-\t83203\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Perciformes; Notothenioidei; Nototheniidae; Lepidonotothen",
    "Lepisosteus oculatus\tspotted gar\t1\t2\t-\t7918\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Holostei; Semionotiformes; Lepisosteidae; Lepisosteus",
    "Leptasterias sp. AR-2014\t-\t1\t9\t-\t1462732\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Forcipulatacea; Forcipulatida; Asteriidae; Leptasterias",
    "Leptonychotes weddellii\tWeddell seal\t1\t2\t-\t9713\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Caniformia; Phocidae; Leptonychotes",
    "Leptosomus discolor\tcuckoo roller\t1\t2\t-\t188344\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Coraciiformes; Leptosomidae; Leptosomus",
    "Ligia exotica\t-\t1\t5\t-\t142080\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Oniscidea; Diplocheta; Ligiidae; Ligia",
    "Limulus polyphemus\tAtlantic horseshoe crab\t1\t5\t-\t6850\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Merostomata; Xiphosura; Limulidae; Limulus",
    "Linepithema humile\tArgentine ant\t1\t5\t-\t83485\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Dolichoderinae; Linepithema",
    "Lingulodinium polyedra\t-\t1\t4\t11\t160621\tPLN\tEukaryota; Alveolata; Dinophyceae; Gonyaulacales; Lingulodinium",
    "Linum\t-\t1\t1\t11\t4005\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Linaceae; Linum",
    "Linum usitatissimum\tflax\t1\t1\t11\t4006\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Linaceae; Linum",
    "Listeria monocytogenes\t-\t11\t0\t-\t1639\tBCT\tBacteria; Firmicutes; Bacilli; Bacillales; Listeriaceae; Listeria",
    "Litchi chinensis\t-\t1\t1\t11\t151069\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Sapindales; Sapindaceae; Litchi",
    "Lolium\t-\t1\t1\t11\t4520\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Poodae; Poeae; Poeae Chloroplast Group 2 (Poeae type); Loliinae; Lolium",
    "Lolium perenne\t-\t1\t1\t11\t4522\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Poodae; Poeae; Poeae Chloroplast Group 2 (Poeae type); Loliinae; Lolium",
    "Lottia\t-\t1\t5\t-\t72691\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Gastropoda; Patellogastropoda; Lottioidea; Lottiidae; Lottia",
    "Lottia gigantea\towl limpet\t1\t5\t-\t225164\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Gastropoda; Patellogastropoda; Lottioidea; Lottiidae; Lottia",
    "Lotus\t-\t1\t1\t11\t3867\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; robinioid clade; Loteae; Lotus",
    "Lotus japonicus\t-\t1\t1\t11\t34305\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; robinioid clade; Loteae; Lotus",
    "Lucernaria quadricornis\t-\t1\t4\t-\t1843199\tINV\tEukaryota; Metazoa; Cnidaria; Staurozoa; Stauromedusae; Myostaurida; Lucernariidae; Lucernaria",
    "Luidia clathrata\t-\t1\t9\t-\t133437\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Valvatacea; Paxillosida; Luidiidae; Luidia",
    "Lupinus angustifolius\tnarrow-leaved blue lupine\t1\t1\t11\t3871\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; genistoids sensu lato; core genistoids; Genisteae; Lupinus",
    "Lygus hesperus\tlygus bug\t1\t5\t-\t30085\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Heteroptera; Panheteroptera; Cimicomorpha; Miridae; Mirini; Lygus",
    "Lymnaea stagnalis\tgreat pond snail\t1\t5\t-\t6523\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Panpulmonata; Hygrophila; Lymnaeoidea; Lymnaeidae; Lymnaea",
    "Lytechinus variegatus\tgreen sea urchin\t1\t9\t-\t7654\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Temnopleuroida; Toxopneustidae; Lytechinus",
    "Macaca\tmacaques\t1\t2\t-\t9539\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Macaca",
    "Macaca fascicularis\tcrab-eating macaque\t1\t2\t-\t9541\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Macaca",
    "Macaca fuscata fuscata\tJapanese macaque\t1\t2\t-\t9543\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Macaca",
    "Macaca mulatta\tRhesus monkey\t1\t2\t-\t9544\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Macaca",
    "Macaca nemestrina\tpig-tailed macaque\t1\t2\t-\t9545\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Macaca",
    "Machilis hrabei\t-\t1\t5\t-\t438506\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Monocondylia; Archaeognatha; Machilidae; Machilis",
    "Magnaporthe\t-\t1\t4\t-\t148303\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Sordariomycetes; Sordariomycetidae; Magnaporthales; Magnaporthaceae; Magnaporthe",
    "Magnaporthe grisea\t-\t1\t4\t-\t148305\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Sordariomycetes; Sordariomycetidae; Magnaporthales; Magnaporthaceae; Magnaporthe",
    "Malus\t-\t1\t1\t11\t3749\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Amygdaloideae; Maleae; Malus",
    "Malus domestica\tapple\t1\t1\t11\t3750\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Amygdaloideae; Maleae; Malus",
    "Manacus vitellinus\tgolden-collared manakin\t1\t2\t-\t328815\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Pipridae; Manacus",
    "Mangifera indica\tmango\t1\t1\t11\t29780\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Sapindales; Anacardiaceae; Mangifera",
    "Manihot\t-\t1\t1\t11\t3982\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Crotonoideae; Manihoteae; Manihot",
    "Manihot esculenta\tcassava\t1\t1\t11\t3983\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Crotonoideae; Manihoteae; Manihot",
    "Manis javanica\tMalayan pangolin\t1\t2\t-\t9974\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Pholidota; Manidae; Manis",
    "marine metagenome\t-\t11\t2\t11\t408172\tENV\tunclassified sequences; metagenomes; ecological metagenomes",
    "marine sediment metagenome\t-\t11\t2\t11\t412755\tENV\tunclassified sequences; metagenomes; ecological metagenomes",
    "Marthasterias glacialis\tspiny starfish\t1\t9\t-\t7609\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Forcipulatacea; Forcipulatida; Asteriidae; Marthasterias",
    "Maylandia zebra\tzebra mbuna\t1\t2\t-\t106582\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Haplochromini; Maylandia; Maylandia zebra complex",
    "Medauroidea extradentata\t-\t1\t5\t-\t614211\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Polyneoptera; Phasmatodea; Verophasmatodea; Anareolatae; Phasmatidae; Phasmatinae; Clitumnini; Medauroidea",
    "Medicago\tmedics\t1\t1\t11\t3877\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Trifolieae; Medicago",
    "Medicago sativa\t-\t1\t1\t11\t3879\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Trifolieae; Medicago",
    "Medicago truncatula\tbarrel medic\t1\t1\t11\t3880\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Trifolieae; Medicago",
    "Megaderma lyra\tIndian false vampire\t1\t2\t-\t9413\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Microchiroptera; Megadermatidae; Megaderma",
    "Megaselia scalaris\t-\t1\t5\t-\t36166\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Platypezoidea; Phoridae; Megaseliini; Megaselia",
    "Melampyrum\t-\t1\t1\t11\t52724\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Orobanchaceae; Rhinantheae; Melampyrum",
    "Melampyrum roseum\t-\t1\t1\t11\t321415\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Orobanchaceae; Rhinantheae; Melampyrum",
    "Meleagris gallopavo\tturkey\t1\t2\t-\t9103\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Galliformes; Phasianidae; Meleagridinae; Meleagris",
    "Meloidogyne\t-\t1\t5\t-\t189290\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Tylenchina; Tylenchomorpha; Tylenchoidea; Meloidogynidae; Meloidogyninae; Meloidogyne",
    "Mengenilla moldrzyki\t-\t1\t5\t-\t1155016\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Strepsiptera; Mengenillidia; Mengenillidae; Mengenilla",
    "Meriones unguiculatus\tMongolian gerbil\t1\t2\t-\t10047\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Muridae; Gerbillinae; Meriones",
    "Merops nubicus\tcarmine bee-eater\t1\t2\t-\t57421\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Coraciiformes; Meropidae; Merops",
    "Mesembryanthemum crystallinum\tcommon iceplant\t1\t1\t11\t3544\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Aizoaceae; Mesembryanthemum; Cryophytum",
    "Mesitornis unicolor\tbrown roatelo\t1\t2\t-\t54374\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gruiformes; Mesitornithidae; Mesitornis",
    "Mesocricetus auratus\tgolden hamster\t1\t2\t-\t10036\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Cricetidae; Cricetinae; Mesocricetus",
    "Mesorhizobium\t-\t11\t0\t-\t68287\tBCT\tBacteria; Proteobacteria; Alphaproteobacteria; Rhizobiales; Phyllobacteriaceae; Mesorhizobium",
    "Micoletzkya japonica\t-\t1\t5\t-\t1250332\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Diplogasteromorpha; Diplogasteroidea; Diplogasteridae; Micoletzkya",
    "Microcebus murinus\tgray mouse lemur\t1\t2\t-\t30608\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Strepsirrhini; Lemuriformes; Cheirogaleidae; Microcebus",
    "Microplitis demolitor\t-\t1\t5\t-\t69319\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Parasitoida; Ichneumonoidea; Braconidae; Microgastrinae; Microplitis",
    "Micropterix calthella\t-\t1\t5\t-\t41027\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Zeugloptera; Micropterigidae; Micropterix",
    "Micropterus floridanus\tFlorida bass\t1\t2\t-\t225391\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Centrarchiformes; Centrarchoidei; Centrarchidae; Micropterus",
    "Micropterus salmoides\tlargemouth bass\t1\t2\t-\t27706\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Centrarchiformes; Centrarchoidei; Centrarchidae; Micropterus",
    "Micropterus salmoides salmoides\tnorthern largemouth bass\t1\t2\t-\t489037\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Centrarchiformes; Centrarchoidei; Centrarchidae; Micropterus",
    "Micrurus corallinus\tpainted coral snake\t1\t2\t-\t54390\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Colubroidea; Elapidae; Elapinae; Micrurus",
    "Micrurus lemniscatus carvalhoi\t-\t1\t2\t-\t129465\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Colubroidea; Elapidae; Elapinae; Micrurus",
    "Micrurus lemniscatus lemniscatus\t-\t1\t2\t-\t129467\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Colubroidea; Elapidae; Elapinae; Micrurus",
    "Mizuhopecten yessoensis\tYesso scallop\t1\t5\t-\t6573\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Bivalvia; Pteriomorphia; Pectinoida; Pectinoidea; Pectinidae; Mizuhopecten",
    "Molgula\t-\t1\t13\t-\t27574\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Ascidiacea; Stolidobranchia; Molgulidae; Molgula",
    "Molgula tectiformis\t-\t1\t13\t-\t30286\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Ascidiacea; Stolidobranchia; Molgulidae; Molgula",
    "Momordica charantia\tbitter melon\t1\t1\t11\t3673\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Cucurbitales; Cucurbitaceae; Momordiceae; Momordica",
    "Monomorium chinense\t-\t1\t5\t-\t482359\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Myrmicinae; Monomorium",
    "Monomorium pharaonis\tpharaoh ant\t1\t5\t-\t307658\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Myrmicinae; Monomorium",
    "Monosiga\t-\t1\t1\t-\t81525\tINV\tEukaryota; Choanoflagellida; Craspedida; Salpingoecidae; Monosiga",
    "Monosiga ovata\t-\t1\t1\t-\t81526\tINV\tEukaryota; Choanoflagellida; Craspedida; Salpingoecidae; Monosiga",
    "Morone chrysops\twhite bass\t1\t2\t-\t46259\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Moronidae; Morone",
    "Morone saxatilis\tstriped sea-bass\t1\t2\t-\t34816\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Moronidae; Morone",
    "Morus notabilis\t-\t1\t1\t11\t981085\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Moraceae; Morus",
    "Mus\t-\t1\t2\t-\t10088\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Muridae; Murinae; Mus",
    "Mus musculus\thouse mouse\t1\t2\t-\t10090\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Muridae; Murinae; Mus; Mus",
    "Mus musculus domesticus\twestern European house mouse\t1\t2\t-\t10092\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Muridae; Murinae; Mus; Mus",
    "Mus musculus molossinus\tJapanese wild mouse\t1\t2\t-\t57486\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Muridae; Murinae; Mus; Mus",
    "Musa acuminata AAA Group\tdessert banana\t1\t1\t11\t214697\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Zingiberales; Musaceae; Musa",
    "Musa acuminata subsp. malaccensis\twild Malaysian banana\t1\t1\t11\t214687\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Zingiberales; Musaceae; Musa",
    "Musca domestica\thouse fly\t1\t5\t-\t7370\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Muscoidea; Muscidae; Musca",
    "Mustela putorius furo\tdomestic ferret\t1\t2\t-\t9669\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Caniformia; Mustelidae; Mustelinae; Mustela",
    "Mycobacterium tuberculosis\t-\t11\t0\t-\t1773\tBCT\tBacteria; Actinobacteria; Corynebacteriales; Mycobacteriaceae; Mycobacterium; Mycobacterium tuberculosis complex",
    "Mycobacteroides abscessus subsp. abscessus\t-\t11\t0\t-\t1185650\tBCT\tBacteria; Actinobacteria; Corynebacteriales; Mycobacteriaceae; Mycobacteroides; Mycobacteroides abscessus",
    "Myotis brandtii\tBrandt's bat\t1\t2\t-\t109478\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Microchiroptera; Vespertilionidae; Myotis",
    "Myotis davidii\t-\t1\t2\t-\t225400\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Microchiroptera; Vespertilionidae; Myotis",
    "Myotis ricketti\tRickett's big-footed Myotis\t1\t2\t-\t203696\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Microchiroptera; Vespertilionidae; Myotis",
    "Myrmica rubra\t-\t1\t5\t-\t106198\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Myrmicinae; Myrmica",
    "Mytilus galloprovincialis\tMediterranean mussel\t1\t5\t-\t29158\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Bivalvia; Pteriomorphia; Mytiloida; Mytiloidea; Mytilidae; Mytilinae; Mytilus",
    "Nannospalax galili\tUpper Galilee mountains blind mole rat\t1\t2\t-\t1026970\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Spalacidae; Spalacinae; Nannospalax",
    "Nasonia\t-\t1\t5\t-\t7424\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Parasitoida; Chalcidoidea; Pteromalidae; Pteromalinae; Nasonia",
    "Nasonia vitripennis\tjewel wasp\t1\t5\t-\t7425\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Parasitoida; Chalcidoidea; Pteromalidae; Pteromalinae; Nasonia",
    "Neisseria gonorrhoeae\t-\t11\t0\t-\t485\tBCT\tBacteria; Proteobacteria; Betaproteobacteria; Neisseriales; Neisseriaceae; Neisseria",
    "Neisseria meningitidis\t-\t11\t0\t-\t487\tBCT\tBacteria; Proteobacteria; Betaproteobacteria; Neisseriales; Neisseriaceae; Neisseria",
    "Nematostella\t-\t1\t4\t-\t45350\tINV\tEukaryota; Metazoa; Cnidaria; Anthozoa; Hexacorallia; Actiniaria; Edwardsiidae; Nematostella",
    "Nematostella vectensis\tstarlet sea anemone\t1\t4\t-\t45351\tINV\tEukaryota; Metazoa; Cnidaria; Anthozoa; Hexacorallia; Actiniaria; Edwardsiidae; Nematostella",
    "Neolamprologus brichardi\t-\t1\t2\t-\t32507\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Lamprologini; Neolamprologus",
    "Neopelma\t-\t1\t2\t-\t114328\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Pipridae; Neopelma",
    "Neopelma chrysocephalum\tsaffron-crested tyrant-manakin\t1\t2\t-\t114329\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Pipridae; Neopelma",
    "Neurospora\t-\t1\t4\t-\t5140\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Sordariomycetes; Sordariomycetidae; Sordariales; Sordariaceae; Neurospora",
    "Neurospora crassa\t-\t1\t4\t-\t5141\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Sordariomycetes; Sordariomycetidae; Sordariales; Sordariaceae; Neurospora",
    "Nicotiana\t-\t1\t1\t11\t4085\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicotiana attenuata\t-\t1\t1\t11\t49451\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicotiana benthamiana\t-\t1\t1\t11\t4100\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicotiana sylvestris\twood tobacco\t1\t1\t11\t4096\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicotiana tabacum\tcommon tobacco\t1\t1\t11\t4097\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicotiana tomentosiformis\t-\t1\t1\t11\t4098\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nilaparvata\t-\t1\t5\t-\t108930\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Auchenorrhyncha; Fulgoroidea; Delphacidae; Delphacinae; Nilaparvata",
    "Nilaparvata lugens\tbrown planthopper\t1\t5\t-\t108931\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Auchenorrhyncha; Fulgoroidea; Delphacidae; Delphacinae; Nilaparvata",
    "Nitella\t-\t1\t1\t11\t3148\tPLN\tEukaryota; Viridiplantae; Streptophyta; Charophyceae; Charales; Characeae; Nitella",
    "Nitella hyalina\t-\t1\t1\t11\t181804\tPLN\tEukaryota; Viridiplantae; Streptophyta; Charophyceae; Charales; Characeae; Nitella",
    "Noccaea caerulescens\t-\t1\t1\t11\t107243\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Coluteocarpeae; Noccaea",
    "Notamacropus\t-\t1\t2\t-\t1960649\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Metatheria; Diprotodontia; Macropodidae; Notamacropus",
    "Notamacropus eugenii\ttammar wallaby\t1\t2\t-\t9315\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Metatheria; Diprotodontia; Macropodidae; Notamacropus",
    "Notechis scutatus\tmainland tiger snake\t1\t2\t-\t8663\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Colubroidea; Elapidae; Acanthophiinae; Notechis",
    "Nothobranchius\t-\t1\t2\t-\t28779\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Nothobranchiidae; Nothobranchius",
    "Nothobranchius furzeri\tturquoise killifish\t1\t2\t-\t105023\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Nothobranchiidae; Nothobranchius",
    "Numida meleagris\thelmeted guineafowl\t1\t2\t-\t8996\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Galliformes; Numididae; Numida",
    "Ochotona princeps\tAmerican pika\t1\t2\t-\t9978\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Lagomorpha; Ochotonidae; Ochotona",
    "Octodon degus\tdegu\t1\t2\t-\t10160\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Hystricomorpha; Octodontidae; Octodon",
    "Octopus bimaculoides\t-\t1\t5\t-\t37653\tINV\tEukaryota; Metazoa; Lophotrochozoa; Mollusca; Cephalopoda; Coleoidea; Neocoleoidea; Octopodiformes; Octopoda; Incirrata; Octopodidae; Octopus",
    "Oenococcus oeni\t-\t11\t0\t-\t1247\tBCT\tBacteria; Firmicutes; Bacilli; Lactobacillales; Leuconostocaceae; Oenococcus",
    "Oikopleura\t-\t1\t5\t-\t34763\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Appendicularia; Copelata; Oikopleuridae; Oikopleura",
    "Oikopleura dioica\t-\t1\t5\t-\t34765\tINV\tEukaryota; Metazoa; Chordata; Tunicata; Appendicularia; Copelata; Oikopleuridae; Oikopleura",
    "Olavius algarvensis\t-\t1\t5\t-\t188229\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Clitellata; Oligochaeta; Haplotaxida; Tubificina; Naididae; Phallodrilinae; Olavius",
    "Olea europaea\tcommon olive\t1\t1\t11\t4146\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Oleaceae; Oleeae; Olea",
    "Olea europaea var. sylvestris\t-\t1\t1\t11\t158386\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Oleaceae; Oleeae; Olea",
    "Oncorhynchus\t-\t1\t2\t-\t8016\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Oncorhynchus",
    "Oncorhynchus kisutch\tcoho salmon\t1\t2\t-\t8019\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Oncorhynchus",
    "Oncorhynchus masou masou\tcherry salmon\t1\t2\t-\t90313\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Oncorhynchus",
    "Oncorhynchus mykiss\trainbow trout\t1\t2\t-\t8022\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Oncorhynchus",
    "Oncorhynchus tshawytscha\tChinook salmon\t1\t2\t-\t74940\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Oncorhynchus",
    "Ophiocoma echinata\t-\t1\t9\t-\t331088\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Asterozoa; Ophiuroidea; Ophiuridea; Ophiurida; Ophiurina; Gnathophiurina; Ophiocomidae; Ophiocoma",
    "Opisthorchis viverrini\t-\t1\t9\t-\t6198\tINV\tEukaryota; Metazoa; Platyhelminthes; Trematoda; Digenea; Opisthorchiida; Opisthorchiata; Opisthorchiidae; Opisthorchis",
    "Oreochromis\t-\t1\t2\t-\t8139\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Oreochromini; Oreochromis",
    "Oreochromis niloticus\tNile tilapia\t1\t2\t-\t8128\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Oreochromini; Oreochromis",
    "Ornithorhynchus anatinus\tplatypus\t1\t2\t-\t9258\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Monotremata; Ornithorhynchidae; Ornithorhynchus",
    "Orobanche\t-\t1\t1\t11\t36747\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Orobanchaceae; Orobancheae; Orobanche",
    "Orobanche minor\t-\t1\t1\t11\t36748\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Orobanchaceae; Orobancheae; Orobanche",
    "Orycteropus afer afer\t-\t1\t2\t-\t1230840\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Afrotheria; Tubulidentata; Orycteropodidae; Orycteropus",
    "Oryctolagus cuniculus\trabbit\t1\t2\t-\t9986\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Lagomorpha; Leporidae; Oryctolagus",
    "Oryza\t-\t1\t1\t11\t4527\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza alta\t-\t1\t1\t11\t52545\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza australiensis\t-\t1\t1\t11\t4532\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza brachyantha\tmalo sina\t1\t1\t11\t4533\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza coarctata\t-\t1\t1\t11\t77588\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza glaberrima\tAfrican rice\t1\t1\t11\t4538\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza longistaminata\t-\t1\t1\t11\t4528\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza meyeriana var. granulata\t-\t1\t1\t11\t110450\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza; Oryza meyeriana",
    "Oryza minuta\t-\t1\t1\t11\t63629\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza officinalis\t-\t1\t1\t11\t4535\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza ridleyi\t-\t1\t1\t11\t83308\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza rufipogon\t-\t1\t1\t11\t4529\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza sativa\trice\t1\t1\t11\t4530\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza; Oryza sativa",
    "Oryza sativa f. spontanea\t-\t1\t1\t11\t4536\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza; Oryza sativa",
    "Oryza sativa Indica Group\tlong-grained rice\t1\t1\t11\t39946\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza; Oryza sativa",
    "Oryza sativa Japonica Group\tJapanese rice\t1\t1\t11\t39947\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza; Oryza sativa",
    "Oryzias\t-\t1\t2\t-\t8089\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Atherinomorphae; Beloniformes; Adrianichthyidae; Oryziinae; Oryzias",
    "Oryzias latipes\tJapanese medaka\t1\t2\t-\t8090\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Atherinomorphae; Beloniformes; Adrianichthyidae; Oryziinae; Oryzias",
    "Osmia cornuta\t-\t1\t5\t-\t185587\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Apoidea; Megachilidae; Megachilinae; Osmia",
    "Otolemur garnettii\tsmall-eared galago\t1\t2\t-\t30611\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Strepsirrhini; Lorisiformes; Galagidae; Otolemur",
    "Ovis\t-\t1\t2\t-\t9935\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Caprinae; Ovis",
    "Ovis aries\tsheep\t1\t2\t-\t9940\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Caprinae; Ovis",
    "Pachypsylla venusta\thackberry petiole gall psyllid\t1\t5\t-\t38123\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Psylloidea; Aphalaridae; Pachypsylla",
    "Pagrus\t-\t1\t2\t-\t8172\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Spariformes; Sparidae; Pagrus",
    "Pagrus major\tred seabream\t1\t2\t-\t143350\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Spariformes; Sparidae; Pagrus",
    "Pan troglodytes\tchimpanzee\t1\t2\t-\t9598\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Hominidae; Pan",
    "Pan troglodytes troglodytes\t-\t1\t2\t-\t37011\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Hominidae; Pan",
    "Pan troglodytes verus\t-\t1\t2\t-\t37012\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Hominidae; Pan",
    "Panagrolaimus\t-\t1\t5\t-\t55784\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Tylenchina; Panagrolaimomorpha; Panagrolaimoidea; Panagrolaimidae; Panagrolaimus",
    "Panagrolaimus davidi\t-\t1\t5\t-\t227884\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Tylenchina; Panagrolaimomorpha; Panagrolaimoidea; Panagrolaimidae; Panagrolaimus",
    "Panax ginseng\t-\t1\t1\t11\t4054\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Apiales; Araliaceae; Panax",
    "Panicum\t-\t1\t1\t11\t4539\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Panicinae; Panicum",
    "Panicum hallii\t-\t1\t1\t11\t206008\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Panicinae; Panicum; Panicum sect. Panicum",
    "Panicum hallii var. hallii\t-\t1\t1\t11\t1504633\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Panicinae; Panicum; Panicum sect. Panicum",
    "Panicum virgatum\tswitchgrass\t1\t1\t11\t38727\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Panicinae; Panicum; Panicum sect. Hiantes",
    "Panthera pardus\tleopard\t1\t2\t-\t9691\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Feliformia; Felidae; Pantherinae; Panthera",
    "Papaver somniferum\topium poppy\t1\t1\t11\t3469\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Ranunculales; Papaveraceae; Papaveroideae; Papaver",
    "Papilio\t-\t1\t5\t-\t7145\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Papilionoidea; Papilionidae; Papilioninae; Papilio",
    "Papilio polytes\tcommon Mormon\t1\t5\t-\t76194\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Papilionoidea; Papilionidae; Papilioninae; Papilio",
    "Papilio xuthus\tAsian swallowtail\t1\t5\t-\t66420\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Papilionoidea; Papilionidae; Papilioninae; Papilio",
    "Papio\tbaboons\t1\t2\t-\t9554\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Papio",
    "Papio anubis\tolive baboon\t1\t2\t-\t9555\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Cercopithecinae; Papio",
    "Paracentrotus\t-\t1\t9\t-\t7655\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Echinoida; Echinidae; Paracentrotus",
    "Paracentrotus lividus\tcommon urchin\t1\t9\t-\t7656\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Echinoida; Echinidae; Paracentrotus",
    "Paramecium tetraurelia\t-\t6\t4\t11\t5888\tINV\tEukaryota; Alveolata; Ciliophora; Intramacronucleata; Oligohymenophorea; Peniculida; Parameciidae; Paramecium",
    "Parasteatoda tepidariorum\tcommon house spider\t1\t5\t-\t114398\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Arachnida; Araneae; Araneomorphae; Entelegynae; Araneoidea; Theridiidae; Parasteatoda",
    "Patiria miniata\tbat star\t1\t9\t-\t46514\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Valvatacea; Valvatida; Asterinidae; Patiria",
    "Patiria pectinifera\t-\t1\t9\t-\t7594\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Valvatacea; Valvatida; Asterinidae; Patiria",
    "Pedicularis\tlouseworts\t1\t1\t11\t43174\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Orobanchaceae; Pedicularideae; Pedicularis",
    "Pedicularis keiskei\t-\t1\t1\t11\t1392158\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Orobanchaceae; Pedicularideae; Pedicularis",
    "Pelecanus crispus\tDalmatian pelican\t1\t2\t-\t36300\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Pelecaniformes; Pelecanidae; Pelecanus",
    "Pelodiscus sinensis\tChinese soft-shelled turtle\t1\t2\t-\t13735\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Testudines; Cryptodira; Trionychia; Trionychidae; Pelodiscus",
    "Penaeus\t-\t1\t5\t-\t133894\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Dendrobranchiata; Penaeoidea; Penaeidae; Penaeus",
    "Penaeus monodon\tblack tiger shrimp\t1\t5\t-\t6687\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Dendrobranchiata; Penaeoidea; Penaeidae; Penaeus",
    "Penaeus vannamei\tPacific white shrimp\t1\t5\t-\t6689\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Dendrobranchiata; Penaeoidea; Penaeidae; Penaeus",
    "Penium margaritaceum\t-\t1\t1\t11\t102169\tPLN\tEukaryota; Viridiplantae; Streptophyta; Zygnemophyceae; Desmidiales; Peniaceae; Penium",
    "Peromyscus\t-\t1\t2\t-\t10040\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Cricetidae; Neotominae; Peromyscus",
    "Peromyscus maniculatus bairdii\tprairie deer mouse\t1\t2\t-\t230844\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Cricetidae; Neotominae; Peromyscus",
    "Persicaria minor\t-\t1\t1\t11\t488003\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Polygonaceae; Polygonoideae; Persicarieae; Persicaria",
    "Petrolisthes\t-\t1\t5\t-\t84661\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Anomura; Galatheoidea; Porcellanidae; Petrolisthes",
    "Petrolisthes cinctipes\tflat porcelain crab\t1\t5\t-\t88211\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Anomura; Galatheoidea; Porcellanidae; Petrolisthes",
    "Petromyzon\t-\t1\t2\t-\t7756\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Cyclostomata; Hyperoartia; Petromyzontiformes; Petromyzontidae; Petromyzon",
    "Petromyzon marinus\tsea lamprey\t1\t2\t-\t7757\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Cyclostomata; Hyperoartia; Petromyzontiformes; Petromyzontidae; Petromyzon",
    "Petunia integrifolia subsp. inflata\t-\t1\t1\t11\t212142\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Petunioideae; Petunia",
    "Phaeodactylum\t-\t1\t1\t11\t2849\tPLN\tEukaryota; Stramenopiles; Bacillariophyta; Bacillariophyceae; Bacillariophycidae; Naviculales; Phaeodactylaceae; Phaeodactylum",
    "Phaeodactylum tricornutum\t-\t1\t1\t11\t2850\tPLN\tEukaryota; Stramenopiles; Bacillariophyta; Bacillariophyceae; Bacillariophycidae; Naviculales; Phaeodactylaceae; Phaeodactylum",
    "Phaethon lepturus\tWhite-tailed tropicbird\t1\t2\t-\t97097\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Pelecaniformes; Phaethontidae; Phaethon",
    "Phalacrocorax carbo\tgreat cormorant\t1\t2\t-\t9209\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Pelecaniformes; Phalacrocoracidae; Phalacrocorax",
    "Phalaenopsis aphrodite\t-\t1\t1\t11\t212056\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Asparagales; Orchidaceae; Epidendroideae; Vandeae; Aeridinae; Phalaenopsis",
    "Phalaenopsis equestris\t-\t1\t1\t11\t78828\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Asparagales; Orchidaceae; Epidendroideae; Vandeae; Aeridinae; Phalaenopsis",
    "Phaseolus\t-\t1\t1\t11\t3883\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Phaseolus",
    "Phaseolus coccineus\t-\t1\t1\t11\t3886\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Phaseolus",
    "Phaseolus vulgaris\t-\t1\t1\t11\t3885\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Phaseolus",
    "Phoca largha\tspotted seal\t1\t2\t-\t39090\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Caniformia; Phocidae; Phoca",
    "Phoenix dactylifera\tdate palm\t1\t1\t11\t42345\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Arecaceae; Coryphoideae; Phoeniceae; Phoenix",
    "Photinus pyralis\tcommon eastern firefly\t1\t5\t-\t7054\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Coleoptera; Polyphaga; Elateriformia; Elateroidea; Lampyridae; Lampyrinae; Photinus",
    "Physalis peruviana\t-\t1\t1\t11\t126903\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Physaleae; Physalis",
    "Physcomitrella\t-\t1\t1\t11\t3217\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Bryophyta; Bryophytina; Bryopsida; Funariidae; Funariales; Funariaceae; Physcomitrella",
    "Physcomitrella patens\t-\t1\t1\t11\t3218\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Bryophyta; Bryophytina; Bryopsida; Funariidae; Funariales; Funariaceae; Physcomitrella",
    "Physeter catodon\tsperm whale\t1\t2\t-\t9755\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Cetacea; Odontoceti; Physeteridae; Physeter",
    "Phytophthora\t-\t1\t1\t11\t4783\tPLN\tEukaryota; Stramenopiles; Oomycetes; Peronosporales; Peronosporaceae; Phytophthora",
    "Phytophthora infestans\tpotato late blight agent\t1\t1\t11\t4787\tPLN\tEukaryota; Stramenopiles; Oomycetes; Peronosporales; Peronosporaceae; Phytophthora",
    "Picea\t-\t1\t1\t11\t3328\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Pinidae; Pinales; Pinaceae; Picea",
    "Picea glauca\twhite spruce\t1\t1\t11\t3330\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Pinidae; Pinales; Pinaceae; Picea",
    "Picea sitchensis\tSitka spruce\t1\t1\t11\t3332\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Pinidae; Pinales; Pinaceae; Picea",
    "Piliocolobus tephrosceles\tUgandan red Colobus\t1\t2\t-\t591936\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Colobinae; Piliocolobus",
    "Pimephales\t-\t1\t2\t-\t51137\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Pimephales",
    "Pimephales promelas\tfathead minnow\t1\t2\t-\t90988\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Pimephales",
    "Pinus\t-\t1\t1\t11\t139271\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Pinidae; Pinales; Pinaceae; Pinus; Pinus",
    "Pinus sylvestris\tScots pine\t1\t1\t11\t3349\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Pinidae; Pinales; Pinaceae; Pinus; Pinus",
    "Pinus taeda\tloblolly pine\t1\t1\t11\t3352\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Pinidae; Pinales; Pinaceae; Pinus; Pinus",
    "Pisum sativum\tpea\t1\t1\t11\t3888\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Fabeae; Pisum",
    "Pisum sativum subsp. sativum\t-\t1\t1\t11\t208194\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Fabeae; Pisum",
    "Plasmodium\t-\t1\t4\t11\t5820\tINV\tEukaryota; Alveolata; Apicomplexa; Aconoidasida; Haemosporida; Plasmodiidae; Plasmodium",
    "Plasmodium falciparum\tmalaria parasite P. falciparum\t1\t4\t11\t5833\tINV\tEukaryota; Alveolata; Apicomplexa; Aconoidasida; Haemosporida; Plasmodiidae; Plasmodium; Plasmodium (Laverania)",
    "Platynereis dumerilii\tDumeril's clam worm\t1\t5\t-\t6359\tINV\tEukaryota; Metazoa; Lophotrochozoa; Annelida; Polychaeta; Palpata; Aciculata; Phyllodocida; Nereididae; Platynereis",
    "Plutella xylostella\tdiamondback moth\t1\t5\t-\t51655\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Yponomeutoidea; Plutellidae; Plutella",
    "Poeciliopsis prolifica\tblackstripe livebearer\t1\t2\t-\t188132\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Poeciliidae; Poeciliinae; Poeciliopsis",
    "Pogonomyrmex californicus\t-\t1\t5\t-\t144036\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Myrmicinae; Pogonomyrmex",
    "Pongo abelii\tSumatran orangutan\t1\t2\t-\t9601\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Hominidae; Pongo",
    "Populus\tpoplars\t1\t1\t11\t3689\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Salicaceae; Saliceae; Populus",
    "Populus euphratica\tEuphrates poplar\t1\t1\t11\t75702\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Salicaceae; Saliceae; Populus",
    "Populus trichocarpa\tblack cottonwood\t1\t1\t11\t3694\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Salicaceae; Saliceae; Populus",
    "Porphyridium\t-\t1\t1\t11\t2791\tPLN\tEukaryota; Rhodophyta; Bangiophyceae; Porphyridiales; Porphyridiaceae; Porphyridium",
    "Porphyridium purpureum\t-\t1\t1\t11\t35688\tPLN\tEukaryota; Rhodophyta; Bangiophyceae; Porphyridiales; Porphyridiaceae; Porphyridium",
    "Priapulus caudatus\t-\t1\t5\t-\t37621\tINV\tEukaryota; Metazoa; Ecdysozoa; Scalidophora; Priapulida; Priapulimorpha; Priapulimorphida; Priapulidae; Priapulus",
    "Pristionchus\t-\t1\t5\t-\t54125\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Diplogasteromorpha; Diplogasteroidea; Neodiplogasteridae; Pristionchus",
    "Pristionchus mayeri\t-\t1\t5\t-\t1317129\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Diplogasteromorpha; Diplogasteroidea; Neodiplogasteridae; Pristionchus",
    "Pristionchus pacificus\t-\t1\t5\t-\t54126\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditina; Diplogasteromorpha; Diplogasteroidea; Neodiplogasteridae; Pristionchus",
    "Proasellus aragonensis\t-\t1\t5\t-\t1281939\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus arthrodilus\t-\t1\t5\t-\t1281940\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus assaforensis\t-\t1\t5\t-\t1282049\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus beticus\t-\t1\t5\t-\t1281946\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus cantabricus\t-\t1\t5\t-\t1281948\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus cavaticus\t-\t1\t5\t-\t1281949\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus coiffaiti\t-\t1\t5\t-\t1281953\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus coxalis\t-\t1\t5\t-\t63229\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus ebrensis\t-\t1\t5\t-\t1281961\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus escolai\t-\t1\t5\t-\t1281963\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus grafi\t-\t1\t5\t-\t1281973\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus granadensis\t-\t1\t5\t-\t1281974\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus hercegovinensis\t-\t1\t5\t-\t1281977\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus ibericus\t-\t1\t5\t-\t1281981\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus jaloniacus\t-\t1\t5\t-\t1281986\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus karamani\t-\t1\t5\t-\t1281987\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus margalefi\t-\t1\t5\t-\t1281998\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus meridianus\t-\t1\t5\t-\t1282001\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus ortizi\t-\t1\t5\t-\t1282012\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus parvulus\t-\t1\t5\t-\t1282015\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus racovitzai\t-\t1\t5\t-\t1282023\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus rectus\t-\t1\t5\t-\t1282025\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus solanasi\t-\t1\t5\t-\t1282031\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Procambarus clarkii\tred swamp crayfish\t1\t5\t-\t6728\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Astacidea; Astacoidea; Cambaridae; Procambarus",
    "Protobothrops mucrosquamatus\t-\t1\t2\t-\t103944\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Colubroidea; Viperidae; Crotalinae; Protobothrops",
    "Protophormia terraenovae\tnorthern blowfly\t1\t5\t-\t34676\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Oestroidea; Calliphoridae; Chrysomyinae; Protophormia",
    "Prunus\t-\t1\t1\t11\t3754\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Amygdaloideae; Amygdaleae; Prunus",
    "Prunus armeniaca\tapricot\t1\t1\t11\t36596\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Amygdaloideae; Amygdaleae; Prunus",
    "Prunus persica\tpeach\t1\t1\t11\t3760\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Amygdaloideae; Amygdaleae; Prunus",
    "Pseudodiploria strigosa\t-\t1\t4\t-\t1428006\tINV\tEukaryota; Metazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Faviina; Mussidae; Faviinae; Pseudodiploria",
    "Pseudomonas aeruginosa\t-\t11\t0\t-\t287\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Pseudomonadales; Pseudomonadaceae; Pseudomonas",
    "Pseudomonas sp. 286\t-\t11\t0\t-\t1705700\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Pseudomonadales; Pseudomonadaceae; Pseudomonas",
    "Pseudorca crassidens\tfalse killer whale\t1\t2\t-\t82174\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Cetacea; Odontoceti; Delphinidae; Pseudorca",
    "Pterocles gutturalis\tyellow-throated sandgrouse\t1\t2\t-\t240206\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Ciconiiformes; Pteroclidae; Pterocles",
    "Pteronotus parnellii\tParnell's mustached bat\t1\t2\t-\t59476\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Microchiroptera; Mormoopidae; Pteronotus",
    "Pteropus alecto\tblack flying fox\t1\t2\t-\t9402\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Megachiroptera; Pteropodidae; Pteropodinae; Pteropus",
    "Pteropus vampyrus\tlarge flying fox\t1\t2\t-\t132908\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Megachiroptera; Pteropodidae; Pteropodinae; Pteropus",
    "Ptychodera flava\t-\t1\t9\t-\t63121\tINV\tEukaryota; Metazoa; Hemichordata; Enteropneusta; Ptychoderidae; Ptychodera",
    "Pundamilia nyererei\t-\t1\t2\t-\t303518\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Haplochromini; Pundamilia",
    "Punica granatum\tpomegranate\t1\t1\t11\t22663\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Myrtales; Lythraceae; Punica",
    "Pygocentrus nattereri\tred-bellied piranha\t1\t2\t-\t42514\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Characiformes; Characoidei; Pygocentrus",
    "Pyrus x bretschneideri\tChinese white pear\t1\t1\t11\t225117\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Amygdaloideae; Maleae; Pyrus",
    "Pythium\t-\t1\t1\t11\t4797\tPLN\tEukaryota; Stramenopiles; Oomycetes; Pythiales; Pythiaceae; Pythium",
    "Pythium ultimum DAOM BR144\t-\t1\t1\t11\t431595\tPLN\tEukaryota; Stramenopiles; Oomycetes; Pythiales; Pythiaceae; Pythium",
    "Python bivittatus\tBurmese python\t1\t2\t-\t176946\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Henophidia; Pythonidae; Python",
    "Quercus\t-\t1\t1\t11\t3511\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Fagaceae; Quercus",
    "Quercus robur\t-\t1\t1\t11\t38942\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Fagaceae; Quercus",
    "Quercus suber\t-\t1\t1\t11\t58331\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Fagaceae; Quercus",
    "Ramazzottius varieornatus\t-\t1\t5\t-\t947166\tINV\tEukaryota; Metazoa; Ecdysozoa; Tardigrada; Eutardigrada; Parachela; Ramazzottiidae; Ramazzottius",
    "Ramulus artemis\t-\t1\t5\t-\t1390046\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Polyneoptera; Phasmatodea; Verophasmatodea; Anareolatae; Phasmatidae; Phasmatinae; Clitumnini; Ramulus",
    "Rana catesbeiana\tAmerican bullfrog\t1\t2\t-\t8400\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Amphibia; Batrachia; Anura; Neobatrachia; Ranoidea; Ranidae; Rana; Aquarana",
    "Raphanus\t-\t1\t1\t11\t3725\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Raphanus",
    "Raphanus sativus\tradish\t1\t1\t11\t3726\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Raphanus",
    "Rattus\t-\t1\t2\t-\t10114\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Muridae; Murinae; Rattus",
    "Rattus norvegicus\tNorway rat\t1\t2\t-\t10116\tROD\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Myomorpha; Muroidea; Muridae; Murinae; Rattus",
    "Rauvolfia serpentina\tserpentwood\t1\t1\t11\t4060\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Apocynaceae; Rauvolfioideae; Vinceae; Rauvolfiinae; Rauvolfia",
    "Reaumuria trigyna\t-\t1\t1\t11\t1091135\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Tamaricaceae; Reaumuria",
    "Rhagoletis zephyria\tsnowberry fruit fly\t1\t5\t-\t28612\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Tephritoidea; Tephritidae; Rhagoletis",
    "Rhincodon typus\twhale shark\t1\t2\t-\t259920\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Chondrichthyes; Elasmobranchii; Galeomorphii; Galeoidea; Orectolobiformes; Rhincodontidae; Rhincodon",
    "Rhinolophus sinicus\tChinese rufous horseshoe bat\t1\t2\t-\t89399\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Chiroptera; Microchiroptera; Rhinolophidae; Rhinolophinae; Rhinolophus",
    "Rhinopithecus bieti\tblack snub-nosed monkey\t1\t2\t-\t61621\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Colobinae; Rhinopithecus",
    "Rhinopithecus roxellana\tgolden snub-nosed monkey\t1\t2\t-\t61622\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Catarrhini; Cercopithecidae; Colobinae; Rhinopithecus",
    "Rhipicephalus\t-\t1\t5\t-\t34630\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Ixodida; Ixodoidea; Ixodidae; Rhipicephalinae; Rhipicephalus",
    "Rhipicephalus microplus\tsouthern cattle tick\t1\t5\t-\t6941\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Ixodida; Ixodoidea; Ixodidae; Rhipicephalinae; Rhipicephalus; Boophilus",
    "Rhizobiales bacterium\t-\t11\t0\t-\t1909294\tBCT\tBacteria; Proteobacteria; Alphaproteobacteria; Rhizobiales",
    "Ricinus communis\tcastor bean\t1\t1\t11\t3988\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Acalyphoideae; Acalypheae; Ricinus",
    "Saccharomyces cerevisiae\tbaker's yeast\t1\t3\t-\t4932\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Saccharomycotina; Saccharomycetes; Saccharomycetales; Saccharomycetaceae; Saccharomyces",
    "Saccharomyces pastorianus\t-\t1\t3\t-\t27292\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Saccharomycotina; Saccharomycetes; Saccharomycetales; Saccharomycetaceae; Saccharomyces",
    "Saccharum\t-\t1\t1\t11\t4546\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Saccharinae; Saccharum",
    "Saccharum hybrid cultivar SP80-3280\t-\t1\t1\t11\t193079\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Saccharinae; Saccharum; Saccharum officinarum complex",
    "Saccoglossus\t-\t1\t5\t-\t10222\tINV\tEukaryota; Metazoa; Hemichordata; Enteropneusta; Harrimaniidae; Saccoglossus",
    "Saccoglossus kowalevskii\t-\t1\t9\t-\t10224\tINV\tEukaryota; Metazoa; Hemichordata; Enteropneusta; Harrimaniidae; Saccoglossus",
    "Saimiri boliviensis boliviensis\tBolivian squirrel monkey\t1\t2\t-\t39432\tPRI\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini; Platyrrhini; Cebidae; Saimiriinae; Saimiri",
    "Salicornia europaea\t-\t1\t1\t11\t206448\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Chenopodiaceae; Salicornioideae; Salicornia; Salicornia subg. Salicornia",
    "Salmo\t-\t1\t2\t-\t8028\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Salmo",
    "Salmo salar\tAtlantic salmon\t1\t2\t-\t8030\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Salmo",
    "Salmonella enterica\t-\t11\t0\t-\t28901\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Salmonella",
    "Salmonella enterica subsp. enterica serovar Typhi\t-\t11\t0\t-\t90370\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Salmonella",
    "Salmonella enterica subsp. enterica serovar Typhimurium\t-\t11\t0\t-\t90371\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Salmonella",
    "Salvelinus alpinus\tArctic char\t1\t2\t-\t8036\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Salvelinus",
    "Sarcophilus harrisii\tTasmanian devil\t1\t2\t-\t9305\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Metatheria; Dasyuromorphia; Dasyuridae; Sarcophilus",
    "Schistosoma\t-\t1\t9\t-\t6181\tINV\tEukaryota; Metazoa; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Schistosoma",
    "Schistosoma japonicum\t-\t1\t9\t-\t6182\tINV\tEukaryota; Metazoa; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Schistosoma",
    "Schistosoma mansoni\t-\t1\t9\t-\t6183\tINV\tEukaryota; Metazoa; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Schistosoma",
    "Schizosaccharomyces\t-\t1\t4\t-\t4895\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Taphrinomycotina; Schizosaccharomycetes; Schizosaccharomycetales; Schizosaccharomycetaceae; Schizosaccharomyces",
    "Schizosaccharomyces pombe\tfission yeast\t1\t4\t-\t4896\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Taphrinomycotina; Schizosaccharomycetes; Schizosaccharomycetales; Schizosaccharomycetaceae; Schizosaccharomyces",
    "Schmidtea mediterranea\t-\t1\t9\t-\t79327\tINV\tEukaryota; Metazoa; Platyhelminthes; Rhabditophora; Seriata; Tricladida; Continenticola; Geoplanoidea; Dugesiidae; Schmidtea",
    "Scylla olivacea\torange mud crab\t1\t5\t-\t85551\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Multicrustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Brachyura; Eubrachyura; Portunoidea; Portunidae; Scylla",
    "Selaginella\t-\t1\t1\t11\t3246\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Lycopodiopsida; Selaginellales; Selaginellaceae; Selaginella",
    "Selaginella moellendorffii\t-\t1\t1\t11\t88036\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Lycopodiopsida; Selaginellales; Selaginellaceae; Selaginella",
    "Serinus canaria\tcommon canary\t1\t2\t-\t9135\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Passeroidea; Fringillidae; Carduelinae; Serinus",
    "Seriola dumerili\tgreater amberjack\t1\t2\t-\t41447\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Carangaria; Carangiformes; Carangidae; Seriola",
    "Seriola lalandi dorsalis\t-\t1\t2\t-\t1841481\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Carangaria; Carangiformes; Carangidae; Seriola",
    "Serratia marcescens\t-\t11\t0\t-\t615\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Yersiniaceae; Serratia",
    "Sesamum indicum\tsesame\t1\t1\t11\t4182\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Pedaliaceae; Sesamum",
    "Setaria\t-\t1\t1\t11\t4554\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Cenchrinae; Setaria",
    "Setaria italica\tfoxtail millet\t1\t1\t11\t4555\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Cenchrinae; Setaria",
    "Setaria viridis\t-\t1\t1\t11\t4556\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Cenchrinae; Setaria",
    "Shigella flexneri\t-\t11\t0\t-\t623\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Shigella",
    "Shigella sonnei\t-\t11\t0\t-\t624\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Shigella",
    "Sinocyclocheilus angustiporus\t-\t1\t2\t-\t307947\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Sinocyclocheilus",
    "Sinocyclocheilus anophthalmus\teyeless golden-line fish\t1\t2\t-\t307955\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Sinocyclocheilus",
    "Sinocyclocheilus anshuiensis\t-\t1\t2\t-\t1608454\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Sinocyclocheilus",
    "Sinocyclocheilus grahami\t-\t1\t2\t-\t75366\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Sinocyclocheilus",
    "Sinocyclocheilus rhinocerous\t-\t1\t2\t-\t307959\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Ostariophysi; Cypriniformes; Cyprinidae; Sinocyclocheilus",
    "Sipyloidea sipylus\t-\t1\t5\t-\t202427\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Polyneoptera; Phasmatodea; Verophasmatodea; Anareolatae; Lonchodidae; Necrosciinae; Sipyloidea",
    "Sisymbrium\t-\t1\t1\t11\t3729\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Sisymbrieae; Sisymbrium",
    "Sisymbrium irio\t-\t1\t1\t11\t3730\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Sisymbrieae; Sisymbrium",
    "Solanum\t-\t1\t1\t11\t4107\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum",
    "Solanum lycopersicum\ttomato\t1\t1\t11\t4081\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum; Lycopersicon",
    "Solanum melongena\teggplant\t1\t1\t11\t4111\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum",
    "Solanum phureja\t-\t1\t1\t11\t172790\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum",
    "Solanum torvum\t-\t1\t1\t11\t119830\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum",
    "Solanum tuberosum\tpotato\t1\t1\t11\t4113\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum",
    "Solenopsis invicta\tred fire ant\t1\t5\t-\t13686\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Myrmicinae; Solenopsis",
    "Sorex araneus\tEuropean shrew\t1\t2\t-\t42254\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Eulipotyphla; Soricidae; Soricinae; Sorex",
    "Sorghum\t-\t1\t1\t11\t4557\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Sorghinae; Sorghum",
    "Sorghum bicolor\tsorghum\t1\t1\t11\t4558\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Sorghinae; Sorghum",
    "Sparus aurata\tgilthead seabream\t1\t2\t-\t8175\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Spariformes; Sparidae; Sparus",
    "Speleonectes cf. tulumensis BMR-2011\t-\t1\t5\t-\t1032549\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Crustacea; Remipedia; Nectiopoda; Speleonectidae; Speleonectes",
    "Sphaerechinus granularis\t-\t1\t9\t-\t39374\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Temnopleuroida; Toxopneustidae; Sphaerechinus",
    "Spinacia oleracea\tspinach\t1\t1\t11\t3562\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Chenopodiaceae; Chenopodioideae; Anserineae; Spinacia",
    "Spirometra erinaceieuropaei\t-\t1\t9\t-\t99802\tINV\tEukaryota; Metazoa; Platyhelminthes; Cestoda; Eucestoda; Diphyllobothriidea; Diphyllobothriidae; Spirometra",
    "Spodoptera\t-\t1\t5\t-\t7106\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Noctuoidea; Noctuidae; Amphipyrinae; Spodoptera",
    "Spodoptera exigua\tbeet armyworm\t1\t5\t-\t7107\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Noctuoidea; Noctuidae; Amphipyrinae; Spodoptera",
    "Spodoptera frugiperda\tfall armyworm\t1\t5\t-\t7108\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Noctuoidea; Noctuidae; Amphipyrinae; Spodoptera",
    "Squalus acanthias\tspiny dogfish\t1\t2\t-\t7797\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Chondrichthyes; Elasmobranchii; Squalimorphii; Squaliformes; Squalidae; Squalus",
    "Staphylococcus aureus\t-\t11\t0\t-\t1280\tBCT\tBacteria; Firmicutes; Bacilli; Bacillales; Staphylococcaceae; Staphylococcus",
    "Staphylococcus epidermidis\t-\t11\t0\t-\t1282\tBCT\tBacteria; Firmicutes; Bacilli; Bacillales; Staphylococcaceae; Staphylococcus",
    "Stegodyphus mimosarum\t-\t1\t5\t-\t407821\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Arachnida; Araneae; Araneomorphae; Entelegynae; Eresoidea; Eresidae; Stegodyphus",
    "Stenotrophomonas maltophilia\t-\t11\t0\t-\t40324\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Xanthomonadales; Xanthomonadaceae; Stenotrophomonas; Stenotrophomonas maltophilia group",
    "Streptococcus agalactiae\t-\t11\t0\t-\t1311\tBCT\tBacteria; Firmicutes; Bacilli; Lactobacillales; Streptococcaceae; Streptococcus",
    "Streptococcus pneumoniae\t-\t11\t0\t-\t1313\tBCT\tBacteria; Firmicutes; Bacilli; Lactobacillales; Streptococcaceae; Streptococcus",
    "Streptococcus suis\t-\t11\t0\t-\t1307\tBCT\tBacteria; Firmicutes; Bacilli; Lactobacillales; Streptococcaceae; Streptococcus",
    "Strongylocentrotus\t-\t1\t9\t-\t7664\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Echinoida; Strongylocentrotidae; Strongylocentrotus",
    "Strongylocentrotus purpuratus\tpurple sea urchin\t1\t9\t-\t7668\tINV\tEukaryota; Metazoa; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Echinoida; Strongylocentrotidae; Strongylocentrotus",
    "Stylophora pistillata\t-\t1\t4\t-\t50429\tINV\tEukaryota; Metazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Astrocoeniina; Pocilloporidae; Stylophora",
    "Sus\t-\t1\t2\t-\t9822\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Suina; Suidae; Sus",
    "Sus scrofa\tpig\t1\t2\t-\t9823\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Suina; Suidae; Sus",
    "Symbiodinium sp. A1\t-\t1\t4\t11\t503409\tPLN\tEukaryota; Alveolata; Dinophyceae; Suessiales; Symbiodiniaceae; Symbiodinium; Symbiodinium sp. clade A",
    "Symbiodinium sp. B2\t-\t1\t4\t11\t154560\tPLN\tEukaryota; Alveolata; Dinophyceae; Suessiales; Symbiodiniaceae; Symbiodinium; Symbiodinium sp. clade B",
    "synthetic construct\t-\t11\t0\t11\t32630\tSYN\tother sequences; artificial sequences",
    "Taeniopygia\t-\t1\t2\t-\t59728\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Passeroidea; Estrildidae; Estrildinae; Taeniopygia",
    "Taeniopygia guttata\tzebra finch\t1\t2\t-\t59729\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Passeroidea; Estrildidae; Estrildinae; Taeniopygia",
    "Takifugu\t-\t1\t2\t-\t31032\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Tetraodontiformes; Tetradontoidea; Tetraodontidae; Takifugu",
    "Takifugu rubripes\ttorafugu\t1\t2\t-\t31033\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Tetraodontiformes; Tetradontoidea; Tetraodontidae; Takifugu",
    "Tauraco erythrolophus\tred-crested turaco\t1\t2\t-\t121530\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Musophagiformes; Musophagidae; Tauraco",
    "Teladorsagia circumcincta\t-\t1\t5\t-\t45464\tINV\tEukaryota; Metazoa; Ecdysozoa; Nematoda; Chromadorea; Strongylida; Trichostrongyloidea; Haemonchidae; Teladorsagia",
    "Teleopsis dalmanni\t-\t1\t5\t-\t139649\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Diptera; Brachycera; Muscomorpha; Diopsoidea; Diopsidae; Teleopsis",
    "Terrapene mexicana triunguis\tThree-toed box turtle\t1\t2\t-\t1415176\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Testudines; Cryptodira; Durocryptodira; Testudinoidea; Emydidae; Terrapene",
    "Tetragonula carbonaria\t-\t1\t5\t-\t148810\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Tetragonula",
    "Tetrahymena\t-\t6\t4\t11\t5890\tINV\tEukaryota; Alveolata; Ciliophora; Intramacronucleata; Oligohymenophorea; Hymenostomatida; Tetrahymenina; Tetrahymenidae; Tetrahymena",
    "Tetrahymena thermophila\t-\t6\t4\t11\t5911\tINV\tEukaryota; Alveolata; Ciliophora; Intramacronucleata; Oligohymenophorea; Hymenostomatida; Tetrahymenina; Tetrahymenidae; Tetrahymena",
    "Tetranychus urticae\ttwo-spotted spider mite\t1\t5\t-\t32264\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Chelicerata; Arachnida; Acari; Acariformes; Trombidiformes; Prostigmata; Eleutherengona; Raphignathae; Tetranychoidea; Tetranychidae; Tetranychus",
    "Tetraodon nigroviridis\tspotted green pufferfish\t1\t2\t-\t99883\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Tetraodontiformes; Tetradontoidea; Tetraodontidae; Tetraodon",
    "Theobroma\t-\t1\t1\t11\t3640\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Byttnerioideae; Theobroma",
    "Theobroma cacao\tcacao\t1\t1\t11\t3641\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Byttnerioideae; Theobroma",
    "Tinamus guttatus\twhite-throated tinamou\t1\t2\t-\t94827\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Palaeognathae; Tinamiformes; Tinamidae; Tinamus",
    "Toxoplasma\t-\t1\t4\t4\t5810\tINV\tEukaryota; Alveolata; Apicomplexa; Conoidasida; Coccidia; Eucoccidiorida; Eimeriorina; Sarcocystidae; Toxoplasma",
    "Toxoplasma gondii\t-\t1\t4\t4\t5811\tINV\tEukaryota; Alveolata; Apicomplexa; Conoidasida; Coccidia; Eucoccidiorida; Eimeriorina; Sarcocystidae; Toxoplasma",
    "Trachemys scripta elegans\t-\t1\t2\t-\t31138\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Testudines; Cryptodira; Durocryptodira; Testudinoidea; Emydidae; Trachemys",
    "Trematomus bernacchii\temerald rockcod\t1\t2\t-\t40690\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Eupercaria; Perciformes; Notothenioidei; Nototheniidae; Trematomus",
    "Tribolium\t-\t1\t1\t11\t89526\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Danthonioideae; Danthonieae; Tribolium",
    "Tribolium castaneum\tred flour beetle\t1\t5\t-\t7070\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Coleoptera; Polyphaga; Cucujiformia; Tenebrionidae; Tenebrionidae incertae sedis; Tribolium",
    "Trichechus manatus latirostris\tFlorida manatee\t1\t2\t-\t127582\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Afrotheria; Sirenia; Trichechidae; Trichechus",
    "Trichoderma\t-\t1\t4\t-\t5543\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Sordariomycetes; Hypocreomycetidae; Hypocreales; Hypocreaceae; Trichoderma",
    "Trichomonas vaginalis G3\t-\t1\t0\t11\t412133\tINV\tEukaryota; Parabasalia; Trichomonadida; Trichomonadidae; Trichomonas",
    "Trichoplusia ni\tcabbage looper\t1\t5\t-\t7111\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Lepidoptera; Glossata; Ditrysia; Noctuoidea; Noctuidae; Plusiinae; Trichoplusia",
    "Trichosurus\tbrush-tailed possums\t1\t2\t-\t9336\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Metatheria; Diprotodontia; Phalangeridae; Trichosurus",
    "Trichosurus vulpecula\tcommon brushtail\t1\t2\t-\t9337\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Metatheria; Diprotodontia; Phalangeridae; Trichosurus",
    "Trifolium\t-\t1\t1\t11\t3898\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Trifolieae; Trifolium",
    "Trifolium pratense\t-\t1\t1\t11\t57577\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; Hologalegina; IRL clade; Trifolieae; Trifolium",
    "Triphysaria\t-\t1\t1\t11\t64092\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Orobanchaceae; Pedicularideae; Castillejinae; Triphysaria",
    "Tripterygion delaisi\t-\t1\t2\t-\t57862\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Actinopterygii; Neopterygii; Teleostei; Neoteleostei; Acanthomorphata; Ovalentaria; Blenniimorphae; Blenniiformes; Blennioidei; Tripterygiidae; Tripterygiinae; Tripterygion",
    "Triticum\t-\t1\t1\t11\t4564\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Triticum",
    "Triticum aestivum\tbread wheat\t1\t1\t11\t4565\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Triticum",
    "Triticum turgidum\t-\t1\t1\t11\t4571\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Triticum",
    "Triticum urartu\t-\t1\t1\t11\t4572\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Triticum",
    "Trypanosoma\t-\t1\t4\t11\t5690\tINV\tEukaryota; Euglenozoa; Kinetoplastida; Trypanosomatidae; Trypanosoma",
    "Trypanosoma brucei\t-\t1\t4\t11\t5691\tINV\tEukaryota; Euglenozoa; Kinetoplastida; Trypanosomatidae; Trypanosoma",
    "Trypanosoma cruzi\t-\t1\t4\t11\t5693\tINV\tEukaryota; Euglenozoa; Kinetoplastida; Trypanosomatidae; Trypanosoma; Schizotrypanum",
    "Trypoxylus dichotomus\t-\t1\t5\t-\t273928\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Coleoptera; Polyphaga; Scarabaeiformia; Scarabaeidae; Dynastinae; Trypoxylus",
    "Tuber\ttruffles\t1\t4\t-\t36048\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Pezizomycetes; Pezizales; Tuberaceae; Tuber",
    "Tuber melanosporum\tPerigord truffle\t1\t4\t-\t39416\tPLN\tEukaryota; Fungi; Dikarya; Ascomycota; Pezizomycotina; Pezizomycetes; Pezizales; Tuberaceae; Tuber",
    "Tupaia\t-\t1\t2\t-\t9394\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Scandentia; Tupaiidae; Tupaia",
    "Tupaia chinensis\tChinese tree shrew\t1\t2\t-\t246437\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Euarchontoglires; Scandentia; Tupaiidae; Tupaia",
    "Turritopsis sp. SK-2016\t-\t1\t4\t-\t1784781\tINV\tEukaryota; Metazoa; Cnidaria; Hydrozoa; Hydroidolina; Anthoathecata; Filifera; Oceaniidae; Turritopsis",
    "Tursiops truncatus\tbottlenose dolphin\t1\t2\t-\t9739\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Cetacea; Odontoceti; Delphinidae; Tursiops",
    "Tyto alba\tBarn owl\t1\t2\t-\t56313\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Strigiformes; Tytonidae; Tyto",
    "uncultured archaeon\t-\t11\t0\t-\t115547\tENV\tArchaea; environmental samples",
    "uncultured bacterium\t-\t11\t0\t-\t77133\tENV\tBacteria; environmental samples",
    "uncultured eukaryote\t-\t1\t1\t11\t100272\tENV\tEukaryota; environmental samples",
    "uncultured fungus\t-\t1\t4\t-\t175245\tENV\tEukaryota; Fungi; environmental samples",
    "uncultured microorganism\t-\t11\t2\t11\t358574\tENV\tunclassified sequences; environmental samples",
    "uncultured Neocallimastigales\t-\t1\t0\t-\t325898\tENV\tEukaryota; Fungi; Fungi incertae sedis; Chytridiomycota; Neocallimastigomycetes; Neocallimastigales; environmental samples",
    "uncultured organism\t-\t11\t2\t11\t155900\tENV\tunclassified sequences; environmental samples",
    "uncultured prokaryote\t-\t11\t0\t11\t198431\tENV\tunclassified sequences; environmental samples",
    "unidentified\t-\t1\t2\t11\t32644\tUNA\tunclassified sequences",
    "Ursus maritimus\tpolar bear\t1\t2\t-\t29073\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Caniformia; Ursidae; Ursus",
    "Ustilago\t-\t1\t4\t-\t5269\tPLN\tEukaryota; Fungi; Dikarya; Basidiomycota; Ustilaginomycotina; Ustilaginomycetes; Ustilaginales; Ustilaginaceae; Ustilago",
    "Ustilago maydis\t-\t1\t4\t-\t5270\tPLN\tEukaryota; Fungi; Dikarya; Basidiomycota; Ustilaginomycotina; Ustilaginomycetes; Ustilaginales; Ustilaginaceae; Ustilago",
    "Vibrio cholerae\t-\t11\t0\t-\t666\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Vibrionales; Vibrionaceae; Vibrio",
    "Vibrio parahaemolyticus\t-\t11\t0\t-\t670\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Vibrionales; Vibrionaceae; Vibrio",
    "Vicugna pacos\talpaca\t1\t2\t-\t30538\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Cetartiodactyla; Tylopoda; Camelidae; Vicugna",
    "Vigna\t-\t1\t1\t11\t3913\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Vigna",
    "Vigna angularis\tadzuki bean\t1\t1\t11\t3914\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Vigna",
    "Vigna unguiculata\tcowpea\t1\t1\t11\t3917\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; 50 kb inversion clade; NPAAA clade; indigoferoid/millettioid clade; Phaseoleae; Vigna",
    "Vitis\t-\t1\t1\t11\t3603\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; Vitales; Vitaceae; Viteae; Vitis",
    "Vitis rotundifolia\t-\t1\t1\t11\t103349\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; Vitales; Vitaceae; Viteae; Vitis",
    "Vitis vinifera\twine grape\t1\t1\t11\t29760\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; eudicotyledons; Gunneridae; Pentapetalae; rosids; Vitales; Vitaceae; Viteae; Vitis",
    "Volvox\t-\t1\t1\t11\t3066\tPLN\tEukaryota; Viridiplantae; Chlorophyta; Chlorophyceae; Chlamydomonadales; Volvocaceae; Volvox",
    "Volvox carteri f. nagariensis\t-\t1\t1\t11\t3068\tPLN\tEukaryota; Viridiplantae; Chlorophyta; Chlorophyceae; Chlamydomonadales; Volvocaceae; Volvox",
    "Vulpes vulpes\tred fox\t1\t2\t-\t9627\tMAM\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Mammalia; Eutheria; Laurasiatheria; Carnivora; Caniformia; Canidae; Vulpes",
    "Wasmannia auropunctata\tlittle fire ant\t1\t5\t-\t64793\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Holometabola; Hymenoptera; Apocrita; Aculeata; Formicoidea; Formicidae; Myrmicinae; Wasmannia",
    "Xanthomonas\t-\t11\t0\t-\t338\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Xanthomonadales; Xanthomonadaceae; Xanthomonas",
    "Xanthomonas oryzae pv. oryzae\t-\t11\t0\t-\t64187\tBCT\tBacteria; Proteobacteria; Gammaproteobacteria; Xanthomonadales; Xanthomonadaceae; Xanthomonas",
    "Xenopus\t-\t1\t2\t-\t8353\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Amphibia; Batrachia; Anura; Pipoidea; Pipidae; Xenopodinae; Xenopus",
    "Xenopus laevis\tAfrican clawed frog\t1\t2\t-\t8355\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Amphibia; Batrachia; Anura; Pipoidea; Pipidae; Xenopodinae; Xenopus; Xenopus",
    "Xenopus tropicalis\ttropical clawed frog\t1\t2\t-\t8364\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Amphibia; Batrachia; Anura; Pipoidea; Pipidae; Xenopodinae; Xenopus; Silurana",
    "Zantedeschia aethiopica\t-\t1\t1\t11\t69721\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Araceae; Philodendroideae; Zantedeschieae; Zantedeschia",
    "Zea\t-\t1\t1\t11\t4575\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Tripsacinae; Zea",
    "Zea mays\t-\t1\t1\t11\t4577\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Tripsacinae; Zea",
    "Zea mays subsp. mays\tmaize\t1\t1\t11\t381124\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Tripsacinae; Zea",
    "Zonotrichia albicollis\twhite-throated sparrow\t1\t2\t-\t44394\tVRT\tEukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Passerellidae; Zonotrichia",
    "Zootermopsis nevadensis\t-\t1\t5\t-\t136037\tINV\tEukaryota; Metazoa; Ecdysozoa; Arthropoda; Hexapoda; Insecta; Pterygota; Neoptera; Polyneoptera; Dictyoptera; Blattodea; Blattoidea; Termitoidae; Termopsidae; Zootermopsis",
    "Zostera\t-\t1\t1\t11\t27257\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Zosteraceae; Zostera",
    "Zostera marina\t-\t1\t1\t11\t29655\tPLN\tEukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta; Spermatophyta; Magnoliophyta; Liliopsida; Zosteraceae; Zostera"
};
