/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.StandardException;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails;
import edu.mit.broad.genome.parsers.GctParser;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.vdb.chip.Chip;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import xtools.api.AbstractTool;
import xtools.api.param.BadParamException;
import xtools.api.param.BooleanParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.Param;
import xtools.api.param.StringInputParam;
import xtools.gsea.AbstractGsea2Tool;
import xtools.gsea.ToolHelper;

public class Gsea
extends AbstractGsea2Tool {
    private final IntegerParam fShowDetailsForTopXSetsParam = new IntegerParam("plot_top_x", "Plot graphs for the top sets of each phenotype", "Plot GSEA mountain and related plots for the top sets of each phenotype", 20, false, Param.ADVANCED);
    private final BooleanParam fMakeZippedReportParam = AbstractTool.createZipReportParam(false);
    private final BooleanParam fMakeGeneSetReportsParam = new BooleanParam("make_sets", "Make detailed gene set report", "Create detailed gene set reports (heat-map, mountain plot etc) for every enriched gene set", true, false, Param.ADVANCED);
    private final BooleanParam fCreateSvgsParam = new BooleanParam("create_svgs", "Create SVG plot images", "Create SVG plot images along with PNGs (GZ compressed to save space as these are very large)", false, false, Param.ADVANCED);
    private final StringInputParam fAltDelimParam = new StringInputParam("altDelim", "Alternate delimiter", "Optional alternate delimiter character for gene set names instead of comma", null, false, new char[]{';'}, Param.ADVANCED);
    private final BooleanParam fCreateGctsParam = new BooleanParam("create_gcts", "Create GCT files", "Create GCT files for the data backing the Gene Set Enrichment Heatmaps", false, false, Param.ADVANCED);

    public Gsea(Properties properties) {
        super("Collapse");
        super.init(properties, "");
    }

    public Gsea(Properties properties, String paramFilePath) {
        super("Collapse");
        super.init(properties, paramFilePath);
    }

    public Gsea(String[] args) {
        super("Collapse");
        super.init(args);
    }

    public Gsea() {
        super("Collapse");
        this.declareParams();
    }

    @Override
    public String getName() {
        return "GSEA";
    }

    protected CollapsedDetails.Data getDataset(Dataset origDs) throws Exception {
        CollapsedDetails.Data cd = new CollapsedDetails.Data();
        cd.orig = origDs;
        if (this.fFeatureSpaceParam.isSymbols()) {
            if (!this.fChipParam.isSpecified()) {
                throw new BadParamException("Chip parameter must be specified as you asked to analyze in the space of gene symbols. Chip is used to collapse probe ids into symbols", 1002);
            }
            Chip chip = this.fChipParam.getChip();
            int collapseModeIndex = this.fFeatureSpaceParam.isRemap() ? 5 : this.fCollapseModeParam.getStringIndexChoosen();
            DatasetGenerators.CollapsedDataset cds = new DatasetGenerators().collapse(origDs, chip, this.fIncludeOnlySymbols.isTrue(), collapseModeIndex, null);
            Dataset collapsed = cds.symbolized;
            this.log.info("Collapsing dataset was done. Original: {} collapsed: {}", (Object)origDs.getQuickInfo(), (Object)collapsed.getQuickInfo());
            this.fReport.savePageTsv(cds.makeEtiologySdf());
            if (this.fCreateGctsParam.isSpecified() && this.fCreateGctsParam.isTrue()) {
                File reportDir = this.fReport.getReportDir();
                File edbDir = new File(reportDir, "edb");
                if (!edbDir.exists()) {
                    edbDir.mkdirs();
                }
                File collapsedGct = new File(edbDir, collapsed.getName() + ".gct");
                GctParser gctExporter = new GctParser();
                gctExporter.export((PersistentObject)collapsed, collapsedGct);
            }
            cd.chip = chip;
            cd.wasCollapsed = true;
            cd.collapsed = collapsed;
            if (cd.getNumRow_orig() != 0 && cd.getNumRow_collapsed() == 0) {
                throw new BadParamException("The collapsed dataset was empty when used with chip:" + cd.getChipName(), 1005);
            }
        } else {
            cd.wasCollapsed = false;
            cd.collapsed = origDs;
            this.log.info("No dataset collapsing was done .. using original as is");
        }
        return cd;
    }

    @Override
    public void execute() throws Exception {
        ReportIndexState state = new ReportIndexState(true, false, false, Gsea.createHeader(this.fDatasetParam));
        this.startExec(state);
        Template template = this.fTemplateParam.getTemplate();
        Metric metric = this.fMetricParam.getMetric();
        if (template.isCategorical()) {
            if (!metric.isCategorical()) {
                throw new StandardException("As the phenotype choosen was categorical, only categorical metrics are allowed. Got: " + metric.getName(), 1010);
            }
            if (!template.isCategorical()) {
                throw new IllegalArgumentException("Only categorical templates allowed. Got: " + template.getName());
            }
        }
        if (!template.isCategorical()) {
            if (!metric.isContinuous()) {
                throw new StandardException("As the phenotype choosen was continuous, only continuous class metrics are allowed. Got: " + metric.getName(), 1011);
            }
            if (!template.isContinuous()) {
                throw new IllegalArgumentException("Only continuous templates allowed. Got: " + template.getName());
            }
        }
        if (this.fAltDelimParam.isSpecified() && StringUtils.isNotBlank((CharSequence)this.fAltDelimParam.getValue().toString())) {
            this.fGeneSetMatrixParam.setAlternateDelimiter(this.fAltDelimParam.getValue().toString());
        }
        GeneSet[] origGeneSets = this.fGeneSetMatrixParam.getGeneSetMatrixCombo().getGeneSets();
        ToolHelper.validateMixedVersionAndSpecies(origGeneSets, this.fChipParam.getChip(), this.fReport, this.log);
        Dataset ds = this.fDatasetParam.getDataset(this.fChipParam);
        Dataset fullDs = this.uniquize(ds);
        CollapsedDetails.Data cd = this.getDataset(fullDs);
        this.execute_one_with_reporting(cd, template, origGeneSets, this.fShowDetailsForTopXSetsParam.getIValue(), this.fMakeZippedReportParam.isSpecified() && this.fMakeZippedReportParam.isTrue(), this.fMakeGeneSetReportsParam.isSpecified() && this.fMakeGeneSetReportsParam.isTrue(), this.fCreateSvgsParam.isSpecified() && this.fCreateSvgsParam.isTrue(), this.fCreateGctsParam.isSpecified() && this.fCreateGctsParam.isTrue());
        if (this.fMakeZippedReportParam.isTrue()) {
            this.fReport.closeReport(true);
            this.fReport.zipReport();
        }
        this.doneExec();
    }

    @Override
    protected Param[] getAdditionalParams() {
        return new Param[]{this.fShowDetailsForTopXSetsParam, this.fMakeZippedReportParam, this.fMakeGeneSetReportsParam, this.fCreateSvgsParam, this.fCreateGctsParam, this.fAltDelimParam};
    }

    @Override
    public String getDesc() {
        return "Set parameters and run enrichment tests";
    }

    public static void main(String[] args) {
        Gsea tool = new Gsea(args);
        Gsea.tool_main(tool);
    }

    public static String createHeader(DatasetReqdParam dsr) {
        try {
            if (dsr.isSpecified()) {
                Dataset ds = dsr.getDataset();
                StringBuffer buf = new StringBuffer();
                buf.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">GSEA Report for ").append("Dataset ").append(ds.getName()).append("</font></h3>\n").append("</div>");
                return buf.toString();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }
}

