/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GOptionsFieldPlusChooser;
import edu.mit.broad.genome.utils.DateUtils;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.tui.ReportStub;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import xtools.api.param.AbstractObjectChooserParam;

public class ReportCacheChooserParam
extends AbstractObjectChooserParam {
    public ReportCacheChooserParam(String nameEnglish) {
        super("rpt_dir", nameEnglish, Report.class, "Report directory", (Object[])new Report[0], (Object[])new Report[0], false);
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        super.setHints(this._getReportsInCache());
        GOptionsFieldPlusChooser chooser = (GOptionsFieldPlusChooser)super.getSelectionComponent();
        chooser.getJListWindow().getJList().setCellRenderer(new MyListRenderer());
        chooser.setListSelectionMode(1);
        return super.getSelectionComponent();
    }

    public File getReportDir() throws Exception {
        Object val = this.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        File file = new File(val.toString());
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        return this.getReport().getReportDir();
    }

    public Report getReport() throws Exception {
        Object val = this.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        if (val instanceof Report) {
            return (Report)val;
        }
        return ParserFactory.readReport(new File(val.toString()), true);
    }

    protected static String format(Object[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] instanceof Report) {
                Report report = (Report)vals[i];
                buf.append(report.getReportDir().getPath());
                if (i == vals.length - 1) continue;
                buf.append(',');
                continue;
            }
            klog.warn("Illegal state: {}", vals[i]);
        }
        return buf.toString();
    }

    @Override
    protected ActionListener getActionListener() {
        return new MyActionListener();
    }

    private Report[] _getReportsInCache() {
        File[] files = this.getReportFiles();
        ArrayList<Report> reports = new ArrayList<Report>();
        for (int i = 0; i < files.length; ++i) {
            try {
                Report report;
                File rptDir;
                File edbDir;
                ReportStub stub = new ReportStub(files[i]);
                if (stub.getName().indexOf("Gsea") == -1 || !(edbDir = new File(rptDir = (report = stub.getReport(false)).getReportDir(), "edb")).exists()) continue;
                reports.add(report);
                continue;
            }
            catch (Throwable t) {
                this.log.error(t.getMessage(), t);
            }
        }
        Comparator<Report> reportComparator = new Comparator<Report>(){

            @Override
            public int compare(Report o1, Report o2) {
                return o2.getDate().compareTo(o1.getDate());
            }
        };
        reports.sort(reportComparator);
        return reports.toArray(new Report[reports.size()]);
    }

    private File[] getReportFiles() {
        File dir = Application.getVdbManager().getReportsCacheDir();
        if (!dir.exists()) {
            this.log.warn("Report cache: " + dir + " not found");
            return new File[0];
        }
        return dir.listFiles(DataFormat.RPT_FORMAT.getFilenameFilter());
    }

    static class MyListRenderer
    extends DefaultListCellRenderer {
        MyListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Report) {
                Report rs = (Report)value;
                this.setToolTipText(rs.getReportDir().getPath());
                String text = rs.getName() + " [" + DateUtils.formatAsDayMonthYear(rs.getDate()) + "]";
                this.setText(text);
            }
            return this;
        }
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportCacheChooserParam.this.setHints(ReportCacheChooserParam.this._getReportsInCache());
            Object prev = ReportCacheChooserParam.this.getValue();
            Object[] sels = prev != null && prev instanceof Object[] ? ReportCacheChooserParam.this.fChooser.getJListWindow().show(ReportCacheChooserParam.this.getHints(), (Object[])prev) : ReportCacheChooserParam.this.fChooser.getJListWindow().show(ReportCacheChooserParam.this.getHints(), new Object[0]);
            if (sels != null && sels.length != 0) {
                String str = ReportCacheChooserParam.format(sels);
                ReportCacheChooserParam.this.fChooser.setText(str);
            }
        }
    }
}

