/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GComboBoxField;
import edu.mit.broad.genome.swing.fields.GFieldUtils;
import edu.mit.broad.xbench.core.ObjectBindery;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import xtools.api.param.Param;
import xtools.api.param.RandomSeedTypeParam;

public class ParamHelper {
    private ParamHelper() {
    }

    public static void addDocumentListener(final JTextField tf, final Param param) {
        tf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                param.setValue(tf.getText());
                if (param.isFileBased()) {
                    tf.setForeground(GFieldUtils.getFileFieldColor(tf.getText()));
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                param.setValue(tf.getText());
                if (param.isFileBased()) {
                    tf.setForeground(GFieldUtils.getFileFieldColor(tf.getText()));
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    static GComboBoxField createActionListenerBoundHintsComboBox(boolean editable, ActionListener al, Param param) {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(param.getHints());
        if (param.getValue() != null && model.getIndexOf(param.getValue()) == -1) {
            model.addElement(param.getValue());
        }
        JComboBox<Object> cb = new JComboBox<Object>(model);
        cb.setEditable(editable);
        cb.setSelectedItem(param.getValue());
        cb.addActionListener(al);
        return new GComboBoxField(cb);
    }

    static GComboBoxField createActionListenerBoundHintsComboBox(boolean editable, ActionListener al, RandomSeedTypeParam param) {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(param.getHints());
        if (param.getValue() != null && model.getIndexOf(param.getValue().toString()) == -1) {
            model.addElement(param.getValue());
        }
        JComboBox<Object> cb = new JComboBox<Object>(model);
        cb.setEditable(editable);
        cb.setSelectedItem(param.getValue());
        cb.addActionListener(al);
        return new GComboBoxField(cb);
    }

    static GComboBoxField createActionListenerBoundPobComboBox(ActionListener al, Class[] pobClasses) {
        JComboBox cb = new JComboBox();
        cb.setEditable(false);
        ObjectBindery.bind(cb, pobClasses);
        cb.addActionListener(al);
        return new GComboBoxField(cb);
    }

    static void safeSelectFirst(JComboBox cb) {
        if (cb.getModel().getSize() > 0) {
            cb.setSelectedIndex(0);
        }
    }

    static void safeSelectPobValueDefaultOrFirst(JComboBox cb, Param param) {
        int indx = -1;
        Object val = param.getValue();
        if (val != null) {
            indx = ParamHelper.findByPobPathIndex(cb, val);
        }
        if (indx == -1) {
            indx = ParamHelper.findByPobPathIndex(cb, param.getDefault());
        }
        if (indx == -1) {
            if (cb.getModel().getSize() > 0) {
                cb.setSelectedIndex(0);
            }
        } else {
            cb.setSelectedIndex(indx);
        }
    }

    static void safeSelectValueDefaultOrNone(JComboBox cb, Param param) {
        Object t = param.getValue();
        if (t == null) {
            t = param.getDefault();
        }
        if (t != null) {
            cb.setSelectedItem(t);
        }
    }

    static void safeSelectValueDefaultByString(JComboBox cb, Param param) {
        Object sel = ParamHelper.getIfHasValue(param.getValue(), cb);
        if (sel == null) {
            sel = param.getDefault();
        }
        if (sel == null) {
            return;
        }
        String sels = sel.toString();
        for (int i = 0; i < cb.getModel().getSize(); ++i) {
            if (!cb.getModel().getElementAt(i).toString().equals(sels)) continue;
            cb.setSelectedIndex(i);
            return;
        }
        ParamHelper.safeSelectFirst(cb);
    }

    private static Object getIfHasValue(Object val, JComboBox cb) {
        if (val == null) {
            return null;
        }
        String vals = val.toString();
        for (int i = 0; i < cb.getModel().getSize(); ++i) {
            if (!cb.getModel().getElementAt(i).toString().equals(vals)) continue;
            return val;
        }
        return null;
    }

    private static int findByPobPathIndex(JComboBox cb, Object path) {
        if (path == null) {
            return -1;
        }
        ComboBoxModel model = cb.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Object obj = model.getElementAt(i);
            File f = ParserFactory.getCache().getSourceFile(obj);
            if (f == null || !f.getPath().equals(path.toString())) continue;
            return i;
        }
        return -1;
    }
}

