/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import xtools.api.param.Param;

public class MissingReqdParamException
extends RuntimeException {
    private Param[] missingParams;
    private String msgInHtml;

    public MissingReqdParamException(Param[] missingParams) {
        super("\n\nSome required parameters (" + missingParams.length + ") were not specified. The parameters are:\n" + MissingReqdParamException._str(missingParams));
        this.missingParams = missingParams;
    }

    private static String _str(Param[] params) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            buf.append(">").append(params[i].getName()).append("<").append('\t').append(params[i].getDesc()).append('\n');
        }
        return buf.toString();
    }

    public String getMessageLongInHtml() {
        if (this.msgInHtml != null) {
            return this.msgInHtml;
        }
        StringBuffer buf = new StringBuffer("<html>\n<body>\n<p>Required parameter(s) were not specified:</p>\n<ul>\n");
        for (int i = 0; i < this.missingParams.length; ++i) {
            buf.append("<li> ").append(this.missingParams[i].getNameEnglish()).append("</li>\n");
        }
        buf.append("</ul>\n").append("<br><br>Please set these in the form and try again").append("</body>\n").append("</html>");
        return buf.toString();
    }
}

