/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu;

import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.genepattern.menu.PlotAction;

public abstract class AbstractPlotMenu
extends JMenu {
    protected JComponent plot;
    protected PlotAction[] plotActions;
    protected Frame parent;

    protected abstract PlotAction[] createPlotActions();

    public AbstractPlotMenu(String name, JComponent plot, Frame parent) {
        super(name);
        this.parent = parent;
        this.plotActions = this.createPlotActions();
        this.setPlot(plot);
        for (PlotAction a : this.plotActions) {
            JMenuItem[] menuItems = a.getSubMenuItems();
            if (menuItems == null) {
                this.add(a);
                continue;
            }
            JMenu menu = new JMenu(a);
            for (int j = 0; j < menuItems.length; ++j) {
                menu.add(menuItems[j]);
            }
            this.add(menu);
        }
    }

    public Frame getFrame() {
        return this.parent;
    }

    public void setPlot(JComponent plot) {
        this.plot = plot;
        int length = this.plotActions.length;
        for (int i = 0; i < length; ++i) {
            this.plotActions[i].setPlot(plot);
            this.plotActions[i].setEnabled(plot != null);
        }
    }
}

