/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.RowColorScheme;
import org.genepattern.heatmap.image.DisplaySettings;
import org.genepattern.heatmap.image.FeatureAnnotator;
import org.genepattern.heatmap.image.HeatMapHeader;
import org.genepattern.heatmap.image.SampleAnnotator;

public class HeatMap {
    public static int LOG_SCALE = 0;
    public static int LINEAR_SCALE = 1;
    public static int COLOR_RESPONSE_ROW = 0;
    public static int COLOR_RESPONSE_GLOBAL = 1;
    String[] rowDescriptions;
    IExpressionData data;
    Dimension elementSize = new Dimension(10, 10);
    private int contentWidth = 0;
    int height = 0;
    boolean antiAliasing = true;
    String fontFamilyName = "monospaced";
    int fontStyle = 0;
    private HeatMapHeader header;
    private int geneNameWidth;
    private int leftBorder = 0;
    private Font font;
    int maxGeneAnnotationsWidth = 0;
    int spaceAfterGeneNames = 10;
    private int annotationWidth = 6;
    private int numFeatureClasses;
    int numSampleClasses;
    private FeatureAnnotator featureAnnotator;
    SampleAnnotator sampleAnnotator;
    private int[] annotationWidths;
    DisplaySettings ds = new DisplaySettings();

    public HeatMap(IExpressionData data, Color[] colorMap) {
        this.data = data;
        this.rowDescriptions = new String[data.getRowCount()];
        int rows = data.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.rowDescriptions[i] = data.getRowMetadata(i, "description");
            if (this.rowDescriptions[i] != null) continue;
            this.rowDescriptions[i] = "";
        }
        this.header = new HeatMapHeader(this);
        this.ds.colorConverter = RowColorScheme.getRowInstance(colorMap);
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getHeightWithHeader() {
        return this.height + this.header.height;
    }

    public static HeatMap createHeatMap(IExpressionData data, DisplaySettings ds, FeatureAnnotator fa, SampleAnnotator sa) {
        HeatMap heatMap = new HeatMap(data, RowColorScheme.getDefaultColorMap());
        heatMap.setDisplaySettings(ds);
        heatMap.setSampleAnnotator(sa);
        heatMap.setFeatureAnnotator(fa);
        HeatMap.updateHeatMapSize(heatMap);
        return heatMap;
    }

    private static void updateHeatMapSize(HeatMap heatMap) {
        BufferedImage bi = new BufferedImage(100, 100, 5);
        Graphics2D g = bi.createGraphics();
        heatMap.updateSize(g);
        heatMap.header.updateSize(heatMap.contentWidth, heatMap.elementSize.width, g);
        g.dispose();
    }

    private void setDisplaySettings(DisplaySettings ds) {
        this.ds = ds;
        this.setElementSize(ds.rowSize, ds.columnSize);
        this.header.drawSampleNames = ds.drawColumnNames;
        ds.colorConverter.setDataset(this.data);
    }

    private void setSampleAnnotator(SampleAnnotator annotator) {
        this.sampleAnnotator = annotator;
        if (this.sampleAnnotator != null) {
            for (int j = 0; j < this.data.getColumnCount(); ++j) {
                List colors = this.sampleAnnotator.getColors(this.data.getColumnName(j));
                if (colors == null) continue;
                this.numSampleClasses = Math.max(this.numSampleClasses, colors.size());
            }
        }
    }

    private void setFeatureAnnotator(FeatureAnnotator annotator) {
        this.featureAnnotator = annotator;
        if (this.featureAnnotator != null) {
            for (int j = 0; j < this.data.getRowCount(); ++j) {
                List colors = this.featureAnnotator.getColors(this.data.getRowName(j));
                if (colors == null) continue;
                this.numFeatureClasses = Math.max(this.numFeatureClasses, colors.size());
            }
        }
    }

    void draw(Graphics2D g2) {
        int samples = this.data.getColumnCount();
        int left = 0;
        int right = samples;
        int top = 0;
        int bottom = this.data.getRowCount();
        for (int row = top; row < bottom; ++row) {
            for (int column = left; column < right; ++column) {
                int x = column * this.elementSize.width + this.leftBorder;
                int y = row * this.elementSize.height;
                g2.setColor(this.ds.colorConverter.getColor(row, column));
                g2.fillRect(x, y, this.elementSize.width, this.elementSize.height);
            }
        }
        int expWidth = samples * this.elementSize.width + 5;
        if (this.featureAnnotator != null) {
            for (int row = 0; row < this.data.getRowCount(); ++row) {
                List colors = this.featureAnnotator.getColors(this.data.getRowName(row));
                if (colors == null) continue;
                for (int j = 0; j < colors.size(); ++j) {
                    g2.setColor((Color)colors.get(j));
                    g2.fillRect(this.annotationWidth * j + expWidth + this.leftBorder, row * this.elementSize.height, this.annotationWidth, this.elementSize.height);
                }
            }
        }
        if (this.antiAliasing) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g2.getFontMetrics();
        int uniqX = this.elementSize.width * samples + 10;
        if (this.featureAnnotator != null) {
            uniqX += this.annotationWidth * this.numFeatureClasses;
        }
        if ((this.ds.drawRowNames || this.ds.drawRowDescriptions) && right >= samples) {
            g2.setColor(Color.black);
            for (int row = top; row < bottom; ++row) {
                String annot;
                int annY = row * this.elementSize.height + fm.getAscent();
                if (this.ds.drawRowNames) {
                    String label = this.data.getRowName(row);
                    g2.drawString(label, uniqX + this.leftBorder, annY);
                }
                if (!this.ds.drawRowDescriptions) continue;
                int geneAnnotationX = uniqX + this.leftBorder + this.geneNameWidth;
                if (this.ds.drawRowNames) {
                    geneAnnotationX += this.spaceAfterGeneNames;
                }
                if ((annot = this.rowDescriptions[row]) == null) continue;
                g2.drawString(annot, geneAnnotationX, annY);
            }
        }
        if (this.featureAnnotator != null) {
            int annotationStartX = uniqX + this.leftBorder;
            g2.setColor(Color.BLACK);
            if (this.ds.drawRowNames) {
                annotationStartX += this.geneNameWidth + this.spaceAfterGeneNames;
            }
            if (this.ds.drawRowDescriptions) {
                annotationStartX += this.maxGeneAnnotationsWidth + this.spaceAfterGeneNames;
            }
            int rows = this.data.getRowCount();
            for (int i = 0; i < rows; ++i) {
                String rowName = this.data.getRowName(i);
                int annY = i * this.elementSize.height + fm.getAscent();
                int cols = this.featureAnnotator.getColumnCount();
                for (int j = 0; j < cols; ++j) {
                    String s = this.featureAnnotator.getAnnotation(rowName, j);
                    if (s == null) continue;
                    int x = annotationStartX + 10 * j;
                    if (j > 0) {
                        x += this.annotationWidths[j - 1];
                    }
                    g2.drawString(s, x, annY);
                }
            }
        }
        if (this.ds.drawGrid || this.ds.showFeatureGridLines || this.ds.showSampleGridLines) {
            g2.setColor(this.ds.gridLinesColor);
            int leftx = left * this.elementSize.width + this.leftBorder;
            int rightx = right * this.elementSize.width + this.leftBorder;
            if (!this.ds.drawGrid && this.ds.showFeatureGridLines) {
                leftx = rightx;
            }
            if (this.ds.showFeatureGridLines) {
                rightx = this.contentWidth;
            }
            if (this.ds.drawGrid || this.ds.showFeatureGridLines) {
                for (int row = top; row <= bottom; ++row) {
                    int y = row * this.elementSize.height;
                    if (this.ds.upperTriangular) {
                        int leftDiag = row * this.elementSize.width + this.leftBorder;
                        g2.drawLine(leftDiag, y, rightx, y);
                        continue;
                    }
                    g2.drawLine(leftx, y, rightx, y);
                }
            }
            int topY = 0;
            int bottomy = bottom * this.elementSize.height;
            if (this.ds.showSampleGridLines && this.ds.drawGrid) {
                g2.translate(0, -this.header.height);
                bottomy = this.height + this.header.height;
            } else if (this.ds.showSampleGridLines && !this.ds.drawGrid) {
                g2.translate(0, -this.header.height);
                bottomy = this.header.height;
            }
            if (this.ds.drawGrid || this.ds.showSampleGridLines) {
                for (int column = left; column <= right; ++column) {
                    int x = column * this.elementSize.width + this.leftBorder;
                    if (this.ds.upperTriangular) {
                        int bottomDiag = this.elementSize.height * column;
                        g2.drawLine(x, topY, x, bottomDiag);
                        continue;
                    }
                    g2.drawLine(x, topY, x, bottomy);
                }
            }
        }
    }

    public BufferedImage snapshot() {
        BufferedImage bi = new BufferedImage(this.contentWidth, this.height + this.header.height, 5);
        Graphics2D g2 = bi.createGraphics();
        this.drawSnapshot(g2);
        g2.dispose();
        return bi;
    }

    public void drawSnapshot(Graphics2D graphics) {
        int headerHeight = this.header.height;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.contentWidth, this.height + headerHeight);
        graphics.setColor(Color.black);
        graphics.setFont(this.header.font);
        this.header.draw(graphics);
        graphics.translate(0, headerHeight);
        graphics.setFont(this.font);
        this.draw(graphics);
    }

    void updateSize(Graphics2D g) {
        int fontHeight = Math.min(14, this.elementSize.height);
        this.font = new Font(this.fontFamilyName, this.fontStyle, fontHeight);
        g.setFont(this.font);
        int width = this.elementSize.width * this.data.getColumnCount() + 1 + this.leftBorder;
        if (this.ds.drawRowNames) {
            this.geneNameWidth = this.getMaxGeneNamesWidth(g);
            width += 20 + this.geneNameWidth;
        }
        if (this.ds.drawRowDescriptions) {
            this.maxGeneAnnotationsWidth = this.getMaxGeneDescriptionsWidth(g);
            if (this.ds.drawRowNames) {
                width += this.spaceAfterGeneNames;
            }
            width += this.maxGeneAnnotationsWidth;
        }
        if (this.featureAnnotator != null) {
            width += this.annotationWidth * this.numFeatureClasses;
            this.annotationWidths = this.getAnnotationsWidth(g);
            for (int i = 0; i < this.annotationWidths.length; ++i) {
                width += this.annotationWidths[i] + 10;
            }
        }
        this.contentWidth = width;
        this.height = this.elementSize.height * this.data.getRowCount() + 1;
        if (!this.ds.drawHeatMapElements) {
            this.height = 0;
        }
    }

    private int[] getAnnotationsWidth(Graphics2D g) {
        FontMetrics fm = g.getFontMetrics();
        int[] widths = new int[this.featureAnnotator.getColumnCount()];
        int rows = this.data.getRowCount();
        for (int i = 0; i < rows; ++i) {
            String rowName = this.data.getRowName(i);
            int cols = this.featureAnnotator.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                String annot = this.featureAnnotator.getAnnotation(rowName, j);
                if (annot == null) continue;
                widths[j] = Math.max(widths[j], fm.stringWidth(annot));
            }
        }
        return widths;
    }

    public void setElementSize(int width, int height) {
        this.elementSize.width = width;
        this.elementSize.height = height;
    }

    int getMaxGeneNamesWidth(Graphics2D g) {
        return this.getMaxWidth(g, true);
    }

    int getMaxGeneDescriptionsWidth(Graphics2D g) {
        return this.getMaxWidth(g, false);
    }

    int getMaxWidth(Graphics2D g, boolean geneNames) {
        if (g == null) {
            return 0;
        }
        if (this.antiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        int max = 0;
        for (int i = 0; i < this.data.getRowCount(); ++i) {
            String str = geneNames ? this.data.getRowName(i) : this.rowDescriptions[i];
            if (str == null) continue;
            max = Math.max(max, fm.stringWidth(str));
        }
        return max;
    }
}

