/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.genepattern.annotation.SparseClassVector;
import org.genepattern.annotation.SparseClassVectorListener;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.PixelConverter;

public class SampleAnnotatorPanel
extends JPanel {
    private SparseClassVector classVector;
    private int heightPerClass = 6;
    private PixelConverter pixelConverter;
    private IExpressionData data;
    private int columnSize;
    private int numAnnotations = 0;
    private int spacer = 2;

    public SampleAnnotatorPanel(SparseClassVector _classVector, IExpressionData _data, int columnSize, final JComponent c) {
        this.setBackground(Color.WHITE);
        this.classVector = _classVector;
        this.data = _data;
        this.columnSize = columnSize;
        this.classVector.addListener(new SparseClassVectorListener(){

            @Override
            public void classChanged() {
                SampleAnnotatorPanel.this.numAnnotations = 0;
                for (int i = 0; i < SampleAnnotatorPanel.this.data.getColumnCount(); ++i) {
                    List classNumbers = SampleAnnotatorPanel.this.classVector.getClassNumbers(i);
                    if (classNumbers == null) continue;
                    SampleAnnotatorPanel.this.numAnnotations = Math.max(classNumbers.size(), SampleAnnotatorPanel.this.numAnnotations);
                }
                c.invalidate();
                c.validate();
                c.doLayout();
                Container a = c.getTopLevelAncestor();
                ((Component)a).invalidate();
                ((Component)a).validate();
                ((Component)a).doLayout();
                SampleAnnotatorPanel.this.repaint();
            }
        });
        this.pixelConverter = new PixelConverter(this);
        this.pixelConverter.setColumnSize(columnSize);
    }

    public void setColumnSize(int i) {
        this.columnSize = i;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.data.getColumnCount() * this.columnSize, this.numAnnotations * this.heightPerClass + this.numAnnotations * this.spacer);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle bounds = g.getClipBounds();
        int left = this.pixelConverter.getLeftIndex(bounds.x);
        int right = this.pixelConverter.getRightIndex(bounds.x + bounds.width, this.data.getColumnCount());
        for (int col = left; col < right; ++col) {
            List classNumbers = this.classVector.getClassNumbers(col);
            if (classNumbers == null) continue;
            int y = (this.numAnnotations - 1) * this.heightPerClass + (this.numAnnotations - 1) * this.spacer;
            for (int j = 0; j < classNumbers.size(); ++j) {
                Integer classNumber = (Integer)classNumbers.get(j);
                g.setColor(this.classVector.getColor(classNumber));
                g.fillRect(col * this.columnSize, y, this.columnSize, this.heightPerClass);
                y = y - this.heightPerClass - this.spacer;
            }
        }
    }
}

