/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.xchoosers;

import com.jidesoft.dialog.ButtonPanel;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateDerivative;
import edu.mit.broad.genome.objects.TemplateDerivatives;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateMode;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldUtils;
import edu.mit.broad.genome.swing.fields.GOptionsFieldPlusChooser;
import edu.mit.broad.xbench.RendererFactory2;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import edu.mit.broad.xbench.xchoosers.TemplateCreatorWidgets;
import edu.mit.broad.xbench.xchoosers.TemplateNonAuxBoxModel;
import edu.mit.broad.xbench.xchoosers.TemplateSelection;
import edu.mit.broad.xbench.xchoosers.TemplateSelectionMultiSource;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateChooserUI {
    protected JComboBox cbTemplates;
    private Logger log = LoggerFactory.getLogger(TemplateChooserUI.class);
    private boolean fIsMultiAllowed;
    private TemplateMode fMode;
    private JList jlOptions;
    private int fSelectionMode;
    private JPanel chooserPanel;
    private boolean fComboTemplateSourceMode;
    private TemplateCreatorWidgets.OnTheFlyFromSampleNames otf;
    private TemplateCreatorWidgets.GenePhenotype gtf;
    private Map fTemplateOptionsArrayCacheMap = new HashMap();

    public TemplateChooserUI(boolean isMultiAllowed, TemplateMode mode) {
        this.fIsMultiAllowed = isMultiAllowed;
        this.fMode = mode;
    }

    private void jbInit() {
        this.jlOptions = new JList();
        if (this.fIsMultiAllowed) {
            this.jlOptions.setBorder(BorderFactory.createTitledBorder("Select one or more phenotype(s)"));
        } else {
            this.jlOptions.setBorder(BorderFactory.createTitledBorder("Select one phenotype)"));
        }
        this.jlOptions.setCellRenderer(new Renderer());
        this.setListOptionsInComboMode(false);
        this.fSelectionMode = this.fIsMultiAllowed ? 2 : 0;
        this.cbTemplates = new JComboBox();
        this.cbTemplates.setBorder(BorderFactory.createTitledBorder("Select source file"));
        ComboBoxModel model = ParserFactory.getCache().createBoxModel(Template.class);
        this.cbTemplates.setModel(new TemplateNonAuxBoxModel(model));
        this.cbTemplates.setRenderer(new RendererFactory2.CommonLookListRenderer(true));
        this.cbTemplates.addItemListener(new MyItemListener());
        if (this.cbTemplates.getModel().getSize() > 0) {
            this.cbTemplates.setSelectedIndex(0);
        }
        this.doTemplateSelection(this.cbTemplates.getSelectedItem());
        JPanel tcPanel = new JPanel();
        tcPanel.setLayout(new BorderLayout());
        tcPanel.add((Component)this.cbTemplates, "North");
        tcPanel.add((Component)new JScrollPane(this.jlOptions), "Center");
        JButton bShowComboPhenotypes = new JButton("Show phenotypes from all source files");
        bShowComboPhenotypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List allTss_orig = ParserFactory.getCache().getCachedObjectsL(Template.class);
                List allTss = TemplateChooserUI.this.qualifyByTypeAndMode(allTss_orig, true);
                Collections.sort(allTss, new ComparatorFactory.PobComparator());
                ArrayList<TemplateDerivatives.PseudoTemplateDerivative> allTds = new ArrayList<TemplateDerivatives.PseudoTemplateDerivative>();
                for (int i = 0; i < allTss.size(); ++i) {
                    Template template = (Template)allTss.get(i);
                    TemplateDerivatives.PseudoTemplateDerivative td = new TemplateDerivatives.PseudoTemplateDerivative(template);
                    allTds.add(td);
                }
                DefaultComboBoxModel<TemplateDerivative> model = new DefaultComboBoxModel<TemplateDerivative>(allTds.toArray(new TemplateDerivative[allTds.size()]));
                TemplateChooserUI.this.jlOptions.setModel(model);
                TemplateChooserUI.this.jlOptions.setSelectionMode(TemplateChooserUI.this.fSelectionMode);
                TemplateChooserUI.this.setListOptionsInComboMode(true);
            }
        });
        this.chooserPanel = new JPanel(new BorderLayout());
        this.chooserPanel.add((Component)tcPanel, "Center");
        ButtonPanel bp = new ButtonPanel(1);
        bp.setBorder((Border)BorderFactory.createTitledBorder("Options"));
        bp.addButton((AbstractButton)bShowComboPhenotypes);
        JButton bOnTheFly = new JButton("Create an on-the-fly phenotype ...");
        bOnTheFly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TemplateChooserUI.this.otf == null) {
                    TemplateChooserUI.this.otf = new TemplateCreatorWidgets.OnTheFlyFromSampleNames();
                }
                DialogDescriptor dd = Application.getWindowManager().createDialogDescriptor("On-the-fly phenotype by sample names", TemplateChooserUI.this.otf, JarResources.createHelpAction("on_the_fly_phenotype"));
                dd.setOnlyShowCloseOption();
                dd.show();
            }
        });
        bp.addButton((AbstractButton)bOnTheFly);
        JButton bFromGene = new JButton("Use a gene as the phenotype ...");
        bFromGene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TemplateChooserUI.this.gtf == null) {
                    TemplateChooserUI.this.gtf = new TemplateCreatorWidgets.GenePhenotype();
                }
                DialogDescriptor dd = Application.getWindowManager().createDialogDescriptor("Use a gene as the phenotype", TemplateChooserUI.this.gtf, JarResources.createHelpAction("gene_profile_phenotype"));
                dd.setOnlyShowCloseOption();
                dd.show();
            }
        });
        bp.addButton((AbstractButton)bFromGene);
        this.chooserPanel.add((Component)bp, "South");
    }

    private void setListOptionsInComboMode(boolean value) {
        if (value) {
            this.fComboTemplateSourceMode = true;
            this.jlOptions.setForeground(Color.MAGENTA);
        } else {
            this.fComboTemplateSourceMode = false;
            this.jlOptions.setForeground(Color.BLACK);
        }
    }

    private JComponent createChooserPanel(TemplateSelection sel) throws Exception {
        if (this.chooserPanel == null) {
            this.jbInit();
        }
        TIntArrayList indices = new TIntArrayList();
        if (sel != null && !(sel instanceof TemplateSelectionMultiSource) && sel.getMainObject() != null) {
            TemplateDerivative[] options = this.createTemplateOptions_safe(sel.getMainObject(), false);
            DefaultListModel<TemplateDerivative> model = new DefaultListModel<TemplateDerivative>();
            for (int i = 0; i < options.length; ++i) {
                model.add(i, options[i]);
            }
            this.jlOptions.setModel(model);
            if (sel.getTemplateNames() != null && sel.getTemplateNames().size() < 3) {
                this.jlOptions.setSelectionMode(0);
            } else {
                this.jlOptions.setSelectionMode(this.fSelectionMode);
            }
            if (sel.getTemplateNames() != null) {
                for (Object obj : sel.getTemplateNames()) {
                    int index = model.indexOf(obj);
                    if (index == -1) continue;
                    indices.add(index);
                }
            }
        }
        if (indices.size() == 0) {
            this.safeSelectFirst(this.jlOptions);
        } else {
            this.jlOptions.setSelectedIndices(indices.toNativeArray());
        }
        return this.chooserPanel;
    }

    public TemplateSelection showChooser(TemplateSelection selBag) throws Exception {
        TemplateSelection sel;
        JComponent comp = this.createChooserPanel(selBag);
        String text = "Select a phenotype";
        if (this.fSelectionMode == 2) {
            text = "Select one or more phenotype(s)";
        }
        DialogDescriptor desc = Application.getWindowManager().createDialogDescriptor(text, comp, JarResources.createHelpAction("cls"));
        desc.enableDoubleClickableJList(this.jlOptions);
        int res = desc.show();
        if (res == 2) {
            return null;
        }
        Object[] objs = this.jlOptions.getSelectedValues();
        if (this.fComboTemplateSourceMode) {
            sel = new TemplateSelectionMultiSource();
            for (int i = 0; i < objs.length; ++i) {
                sel.add((TemplateDerivative)objs[i], false, true);
            }
        } else {
            sel = new TemplateSelection(this.cbTemplates.getSelectedItem());
            for (int i = 0; i < objs.length; ++i) {
                sel.add((TemplateDerivative)objs[i], false, false);
            }
        }
        return sel;
    }

    private TemplateDerivative[] createTemplateOptions_safe(Object fullTemplate, boolean onlyHashOnesForBiphasic) {
        try {
            if (fullTemplate instanceof Template) {
                return this.createTemplateOptions_from_template((Template)fullTemplate, onlyHashOnesForBiphasic);
            }
            if (fullTemplate instanceof TemplateNonAuxBoxModel.TemplateContWrapper) {
                return this.createTemplateOptions_file_cont(((TemplateNonAuxBoxModel.TemplateContWrapper)fullTemplate).sourceFile);
            }
            if (fullTemplate instanceof File) {
                return this.createTemplateOptions_file_cont((File)fullTemplate);
            }
            throw new IllegalArgumentException("Unknown object: " + fullTemplate + " " + fullTemplate.getClass());
        }
        catch (Exception e) {
            Application.getWindowManager().showError("Error making Template options", e);
            return new TemplateDerivative[0];
        }
    }

    private TemplateDerivative[] createTemplateOptions_file_cont(File fullTemplate_file) throws Exception {
        Object obj;
        if (fullTemplate_file == null) {
            return new TemplateDerivative[0];
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating template from source file: {}", (Object)fullTemplate_file.getPath());
        }
        if ((obj = this.fTemplateOptionsArrayCacheMap.get(fullTemplate_file)) != null) {
            return (TemplateDerivative[])obj;
        }
        Template[] cts = ParserFactory.readTemplates(fullTemplate_file);
        HashSet<Template> set = new HashSet<Template>();
        for (int i = 0; i < cts.length; ++i) {
            set.add(cts[i]);
        }
        cts = set.toArray(new Template[set.size()]);
        cts = this.qualifyByTypeAndMode(cts, false);
        TemplateDerivative[] tds = new TemplateDerivative[cts.length];
        for (int i = 0; i < cts.length; ++i) {
            tds[i] = new TemplateDerivatives.ContTemplateDerivative(cts[i].getName(), fullTemplate_file);
        }
        this.fTemplateOptionsArrayCacheMap.put(fullTemplate_file, tds);
        return tds;
    }

    private TemplateDerivative[] createTemplateOptions_from_template(Template fullTemplate, boolean onlyHashOnesForBiphasic) throws Exception {
        if (fullTemplate == null) {
            return new TemplateDerivative[0];
        }
        Object obj = this.fTemplateOptionsArrayCacheMap.get(fullTemplate);
        if (obj != null) {
            return (TemplateDerivative[])obj;
        }
        boolean addOrig = true;
        Template[] tss = TemplateFactory.extractAllPossibleTemplates(fullTemplate, addOrig);
        tss = this.qualifyByTypeAndMode(tss, onlyHashOnesForBiphasic);
        ArrayList<TemplateDerivatives.AuxTemplateDerivative> tdsList = new ArrayList<TemplateDerivatives.AuxTemplateDerivative>();
        for (int i = 0; i < tss.length; ++i) {
            tdsList.add(new TemplateDerivatives.AuxTemplateDerivative(tss[i].getName(), fullTemplate));
        }
        TemplateDerivative[] tds = tdsList.toArray(new TemplateDerivative[tdsList.size()]);
        this.fTemplateOptionsArrayCacheMap.put(fullTemplate, tds);
        return tds;
    }

    private void safeSelectFirst(JList jl) {
        if (jl.getModel().getSize() >= 1) {
            jl.setSelectedIndex(0);
        }
    }

    private void doTemplateSelection(Object selectedMainTemplate) {
        if (selectedMainTemplate == null) {
            return;
        }
        TemplateDerivative[] options = this.createTemplateOptions_safe(selectedMainTemplate, true);
        DefaultListModel<TemplateDerivative> model = new DefaultListModel<TemplateDerivative>();
        for (int i = 0; i < options.length; ++i) {
            model.add(i, options[i]);
        }
        this.jlOptions.setModel(model);
        if (options.length < 3) {
            this.jlOptions.setSelectionMode(0);
        } else {
            this.jlOptions.setSelectionMode(this.fSelectionMode);
        }
        this.safeSelectFirst(this.jlOptions);
    }

    private List qualifyByTypeAndMode(List templates, boolean onlyAuxForBiphasicOnes) {
        Template[] tss = this.qualifyByTypeAndMode(templates.toArray(new Template[templates.size()]), onlyAuxForBiphasicOnes);
        ArrayList<Template> list = new ArrayList<Template>();
        for (int i = 0; i < tss.length; ++i) {
            list.add(tss[i]);
        }
        return list;
    }

    private Template[] qualifyByTypeAndMode(Template[] tss, boolean onlyHashOnesForBiphasic) {
        ArrayList<Template> list = new ArrayList<Template>();
        if (this.fMode == TemplateMode.CONTINUOUS_ONLY) {
            for (int i = 0; i < tss.length; ++i) {
                if (!tss[i].isContinuous()) continue;
                list.add(tss[i]);
            }
        } else if (this.fMode == TemplateMode.CATEGORICAL_2_CLASS_ONLY) {
            for (int i = 0; i < tss.length; ++i) {
                if (onlyHashOnesForBiphasic) {
                    if (tss[i].isContinuous() || tss[i].getNumClasses() != 2 || tss[i].getName().indexOf(35) == -1) continue;
                    list.add(tss[i]);
                    continue;
                }
                if (tss[i].isContinuous() || tss[i].getNumClasses() != 2) continue;
                list.add(tss[i]);
            }
        } else if (this.fMode == TemplateMode.CATEGORICAL_ONLY) {
            for (int i = 0; i < tss.length; ++i) {
                if (tss[i].isContinuous()) continue;
                list.add(tss[i]);
            }
        } else if (this.fMode == TemplateMode.UNIPHASE_ONLY) {
            for (int i = 0; i < tss.length; ++i) {
                if (tss[i].getNumClasses() != 1) continue;
                list.add(tss[i]);
            }
        } else {
            if (this.fMode == TemplateMode.ALL) {
                return tss;
            }
            if (this.fMode == TemplateMode.CATEGORICAL_2_CLASS_AND_NUMERIC) {
                int i;
                for (i = 0; i < tss.length; ++i) {
                    if (!tss[i].isContinuous()) continue;
                    list.add(tss[i]);
                }
                for (i = 0; i < tss.length; ++i) {
                    if (onlyHashOnesForBiphasic) {
                        if (tss[i].isContinuous() || tss[i].getNumClasses() != 2 || tss[i].getName().indexOf(35) == -1) continue;
                        list.add(tss[i]);
                        continue;
                    }
                    if (tss[i].isContinuous() || tss[i].getNumClasses() != 2) continue;
                    list.add(tss[i]);
                }
            } else {
                throw new RuntimeException("Unknown mode: " + this.fMode);
            }
        }
        return list.toArray(new Template[list.size()]);
    }

    public static class Field
    extends GOptionsFieldPlusChooser {
        public Field(ActionListener al) {
            this.setLayout(new BorderLayout());
            this.tfEntry = new MyTextField();
            this.add((Component)this.tfEntry, "Center");
            this.add((Component)this.bEntry, "East");
            this.bEntry.addActionListener(al);
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            if (text == null) {
                return;
            }
            this.tfEntry.setForeground(GFieldUtils.getFileFieldColor(text));
        }

        private class MyTextField
        extends JTextField {
            private MyTextField() {
            }

            @Override
            public void processKeyEvent(KeyEvent ev) {
                Document doc = Field.this.tfEntry.getDocument();
                try {
                    String text = Field.this.tfEntry.getDocument().getText(0, doc.getLength());
                    this.setForeground(GFieldUtils.getFileFieldColor(text));
                    super.processKeyEvent(ev);
                }
                catch (BadLocationException e) {
                    super.processKeyEvent(ev);
                }
            }
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof TemplateDerivative)) {
                throw new RuntimeException("Unknown object to render: " + value);
            }
            String text = ((TemplateDerivative)value).getName(TemplateChooserUI.this.fComboTemplateSourceMode, false);
            this.setText(text);
            return this;
        }
    }

    class MyItemListener
    implements ItemListener {
        MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                if (e.getStateChange() == 1) {
                    Object sel = TemplateChooserUI.this.cbTemplates.getSelectedItem();
                    if (sel != null) {
                        TemplateChooserUI.this.doTemplateSelection(TemplateChooserUI.this.cbTemplates.getSelectedItem());
                    }
                    TemplateChooserUI.this.setListOptionsInComboMode(false);
                }
            }
            catch (Throwable t) {
                Application.getWindowManager().showError("Trouble making Templates", t);
            }
        }
    }
}

