/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.prefs;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.xbench.actions.XAction;
import edu.mit.broad.xbench.core.ApplicationDialog;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.prefs.BooleanPreference;
import edu.mit.broad.xbench.prefs.DirPreference;
import edu.mit.broad.xbench.prefs.IntPreference;
import edu.mit.broad.xbench.prefs.Preference;
import edu.mit.broad.xbench.prefs.PreferenceCategory;
import edu.mit.broad.xbench.prefs.StringPreference;
import edu.mit.broad.xbench.prefs.TabPlacementPreference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.prefs.BackingStoreException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class XPreferencesFactory {
    private static final Logger klog;
    public static File kAppRuntimeHomeDir;
    private static final String GSEA_HOME = "gsea_home";
    public static final IntPreference kCytoscapeRESTPort;
    public static String RESOURCES_DATA_FILE_NAME;
    public static final DirPreference kSpecialUserHomeDir;
    public static final StringPreference kEmail;
    public static final BooleanPreference kAskBeforeAppShutdown;
    public static final BooleanPreference kOnlineMode;
    public static final DirPreference kDefaultReportsOutputDir;
    public static final BooleanPreference kSplitFileExplorerDisplay;
    public static final TabPlacementPreference kTabPlacement;
    public static final BooleanPreference kToolDisplayComponent;
    public static final BooleanPreference kToolSelectorComponent;
    public static final BooleanPreference kMakeGseaUpdateCheck;
    public static final PreferenceCategory kGeneralCategory;
    public static final StringPreference kLastToolName;
    private static Dimension screenSize;
    public static final IntPreference kAppWidth;
    public static final IntPreference kAppHeight;
    public static final BooleanPreference kAppMaximized;
    public static final BooleanPreference kMedian;
    public static final BooleanPreference kFixLowVar;
    public static final BooleanPreference kBiasedVar;
    public static final PreferenceCategory kAlgCategory;
    public static PreferenceCategory[] ALL_CATEGORIES;

    public static int getToolTreeWidth() {
        if (Conf.isGseaApp()) {
            return 300;
        }
        return 250;
    }

    public static int getToolTreeWidth_min() {
        if (Conf.isGseaApp()) {
            return 150;
        }
        return 150;
    }

    public static int getToolTreeDivLocation() {
        return 350;
    }

    private XPreferencesFactory() {
    }

    public static void save() throws BackingStoreException {
        klog.info("Saving preferences to store");
        Preference.kPrefs.flush();
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(final BooleanPreference pref) {
        final JCheckBoxMenuItem mi = new JCheckBoxMenuItem(pref.getName(), (Boolean)pref.getValue());
        mi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    pref.setValue(mi.getState());
                    klog.debug("set pref: {} to: {}", (Object)pref.getName(), pref.getValue());
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError("Could not set preference: " + pref.getName(), t);
                }
            }
        });
        return mi;
    }

    public static Object showSetPreferenceDialog(Preference pref) {
        GFieldPlusChooser field = pref.getSelectionComponent();
        String title = "Set preference: " + pref.getName();
        JPanel input = new JPanel(new BorderLayout());
        JLabel label = new JLabel(pref.getName() + ": ");
        label.setFont(GuiHelper.FONT_DEFAULT_BOLD);
        input.add((Component)label, "West");
        input.add((Component)field.getComponent(), "Center");
        input.add((Component)new JLabel(pref.getDesc()), "South");
        ApplicationDialog dd = new ApplicationDialog(title, input);
        int res = dd.show();
        if (res == 0) {
            try {
                pref.setValue(field.getValue());
            }
            catch (Throwable t) {
                Application.getWindowManager().showError("Could not set preference: " + pref.getName(), t);
                return null;
            }
        }
        return pref.getValue();
    }

    public static JButton createActionButton(Preference pref) {
        return new JButton(new GenericPrefAction(pref));
    }

    static {
        boolean made;
        klog = LoggerFactory.getLogger(XPreferencesFactory.class);
        kCytoscapeRESTPort = new IntPreference("Cytoscape REST port", "Localhost network port for Cytoscape cyREST API", 1234, false, false);
        kSpecialUserHomeDir = new DirPreference("Special location for gsea_home folder", "Special (non-default) location of gsea_home folder where the applications reads/stores info", SystemUtils.getUserHome(), false, true);
        kAppRuntimeHomeDir = new File(SystemUtils.getUserHome(), GSEA_HOME);
        boolean exists = kAppRuntimeHomeDir.exists();
        if (!exists && !(made = kAppRuntimeHomeDir.mkdir())) {
            klog.error(MarkerFactory.getMarker((String)"FATAL"), "Could not make gsea_home dir at: >{}<", (Object)kAppRuntimeHomeDir);
        }
        RESOURCES_DATA_FILE_NAME = "RdfGseaApp.txt";
        klog.debug("kAppRuntimeHomeDir: {} exists: {}", (Object)kAppRuntimeHomeDir, (Object)exists);
        kEmail = new StringPreference("Email Address", "Users email address", SystemUtils.getUserName() + "@change_this.edu", false, false);
        kAskBeforeAppShutdown = new BooleanPreference("Prompt before closing application", "Display a prompt asking for confirmation before shutting down the application", false, false, false);
        kOnlineMode = new BooleanPreference("Connect over the Internet", "You can connect to the GSEA website over the Internet. This ensures you always get the current version of gene sets and chip annotations. ", true, false, false);
        kDefaultReportsOutputDir = new DirPreference("Default reports output folder", "Default location of the output_directory where tool reports are stored", new File(kAppRuntimeHomeDir, "output"), false, false);
        kSplitFileExplorerDisplay = new BooleanPreference("Split file explorer display", "Show one or two different windows in the File Explorer", false, false, false);
        kTabPlacement = new TabPlacementPreference("Tab Placement", "Display location of the tabbed windows created when viewing data / tools", 1);
        kToolDisplayComponent = new BooleanPreference("Display tool in table", "Display the tool in a Table container", false, false, true);
        kToolSelectorComponent = new BooleanPreference("Display tool selector in a tree", "Display the tool selector in a Tree", false, false, true);
        kMakeGseaUpdateCheck = new BooleanPreference("Check for new GSEA version on startup", "Check for new GSEA version on startup", true, false, true);
        kGeneralCategory = new PreferenceCategory(new Preference[]{kEmail, kAskBeforeAppShutdown, kDefaultReportsOutputDir, kTabPlacement, kToolDisplayComponent, kToolSelectorComponent, kMakeGseaUpdateCheck});
        kLastToolName = new StringPreference("Last Tool Run", "Dont change me", "", true, true);
        screenSize = null;
        try {
            screenSize = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getScreenSize() : new Dimension(800, 600);
        }
        catch (Throwable t) {
            klog.error(MarkerFactory.getMarker((String)"FATAL"), "Unexpected trouble", t);
        }
        kAppWidth = new IntPreference("Last app width", "Dont change me", XPreferencesFactory.screenSize.width - 400, false, true);
        kAppHeight = new IntPreference("Last app height", "Dont change me", XPreferencesFactory.screenSize.height - 400, false, true);
        kAppMaximized = new BooleanPreference("app was maximized", "dummy", false, false, true);
        kMedian = new BooleanPreference("Use median instead of mean for class metrics", "Median or mean for distance metrics (such as s2n)", false, false, false);
        kFixLowVar = new BooleanPreference("Fix metrics for low variance", "Adjust for low variances", true, false, false);
        kBiasedVar = new BooleanPreference("Use biased variances", "Use biased mode to calculate variances", false, false, false);
        kAlgCategory = new PreferenceCategory(new Preference[]{kMedian, kFixLowVar, kBiasedVar});
        ALL_CATEGORIES = new PreferenceCategory[]{kGeneralCategory, kAlgCategory};
    }

    static class GenericPrefAction
    extends XAction {
        Preference fPref;

        GenericPrefAction(Preference pref) {
            this(pref, null);
        }

        GenericPrefAction(Preference pref, Icon customIcon) {
            super("GenericPrefAction", pref.getName(), pref.getDesc(), customIcon);
            this.fPref = pref;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            XPreferencesFactory.showSetPreferenceDialog(this.fPref);
        }
    }
}

