/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.reports.NullSafeStringBuffer;
import edu.mit.broad.genome.utils.ImmutedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MappingEtiology {
    private boolean fImmuted;
    private List<OneMap> fOneMaps = new ArrayList<OneMap>();
    private String fGeneSetName;
    private String fTargetChipName;

    public MappingEtiology(String gsetName, String targetChipName) {
        this.fGeneSetName = gsetName;
        this.fTargetChipName = targetChipName;
    }

    public int getTotalNumOfSourceMembersActuallyMapped() {
        int cnt_with_at_least_one_match = 0;
        for (OneMap one : this.fOneMaps) {
            if (one.size() <= 0) continue;
            ++cnt_with_at_least_one_match;
        }
        return cnt_with_at_least_one_match;
    }

    public void add(String sourceMember, Set<String> targets) {
        this.checkImmuted();
        this.fOneMaps.add(new OneMap(sourceMember, targets));
    }

    public void setImmutable() {
        this.fImmuted = true;
    }

    private void checkImmuted() {
        if (this.fImmuted) {
            throw new ImmutedException();
        }
    }

    public String getStory() {
        HashSet<String> uniq = new HashSet<String>();
        int cnt_with_at_least_one_match = 0;
        for (int i = 0; i < this.fOneMaps.size(); ++i) {
            OneMap one = this.fOneMaps.get(i);
            uniq.addAll(one.mappedProbeNames);
            if (one.size() <= 0) continue;
            ++cnt_with_at_least_one_match;
        }
        NullSafeStringBuffer buf = new NullSafeStringBuffer(false);
        buf.append("Mapping for gene set: " + this.fGeneSetName).append('\n');
        buf.append("Mapping to " + this.fTargetChipName).append('\n');
        buf.append("Total number of source probes to map: " + this.fOneMaps.size()).append('\n');
        buf.append("Total number of target probes got : " + uniq.size()).append('\n');
        buf.append("Total number of source probes actualy used : " + cnt_with_at_least_one_match).append('\n');
        buf.append('\n');
        buf.append('\n');
        buf.append("SOURCE_ID\tTARGET_ID(s)\n");
        for (OneMap one : this.fOneMaps) {
            buf.append(one.sourceProbeName).append('\t').append(one.toString()).append('\n');
        }
        return buf.toString();
    }

    static class OneMap {
        String sourceProbeName;
        Set<String> mappedProbeNames;

        OneMap(String probeName, Set<String> mappedProbeNames) {
            if (probeName == null) {
                throw new IllegalArgumentException("Parameter probeName cannot be null");
            }
            this.sourceProbeName = probeName;
            this.mappedProbeNames = mappedProbeNames;
        }

        public int size() {
            if (this.mappedProbeNames != null) {
                return this.mappedProbeNames.size();
            }
            return 0;
        }

        public String toString() {
            if (this.mappedProbeNames == null || this.mappedProbeNames.isEmpty()) {
                return "Invalid probe for source chip";
            }
            String sep = "";
            StringBuilder buf = new StringBuilder();
            for (String o : this.mappedProbeNames) {
                buf.append(sep).append(o.toString());
                sep = ",";
            }
            return buf.toString();
        }
    }
}

