/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import com.jidesoft.grid.SortableTable;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.viewers.AbstractViewer;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.NullSymbolModes;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenuBar;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ChipViewer
extends AbstractViewer {
    public static final Icon ICON = JarResources.getIcon("Chip16.png");
    public static final String NAME = "ChipViewer";
    private Chip fChip;

    public ChipViewer(Chip chip) {
        super(NAME, ICON, chip);
        this.fChip = chip;
        Model model = new Model(this.fChip);
        SortableTable table = ChipViewer.createTable(model, true, true);
        ChipViewer.setColumnSize(100, 1, (JTable)table, false);
        this.setLayout(new BorderLayout());
        this.add((Component)ChipViewer.createAlwaysScrollPane((JTable)table), "Center");
        this.revalidate();
    }

    @Override
    public JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    public static class Model
    extends AbstractTableModel {
        private final Chip fChip;
        private static String[] COL_NAMES = new String[]{"FEATURE", "SYMBOL", "TITLE"};
        private boolean once = false;

        public Model(Chip chip) {
            this.fChip = chip;
        }

        @Override
        public int getColumnCount() {
            return COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            try {
                return this.fChip.getNumProbes();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        @Override
        public String getColumnName(int col) {
            return COL_NAMES[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                String probeName = this.fChip.getProbeName(row);
                if (col == 0) {
                    return probeName;
                }
                if (col == 1) {
                    return this.fChip.getSymbol(probeName, NullSymbolModes.OmitNulls);
                }
                return this.fChip.getTitle(probeName, NullSymbolModes.OmitNulls);
            }
            catch (Exception e) {
                if (!this.once) {
                    e.printStackTrace();
                    this.once = true;
                }
                return null;
            }
        }

        public Class getColumnClass(int col) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

