/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtility {
    private static final Logger klog = LoggerFactory.getLogger(ZipUtility.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(File zipArchive, File targetDirectory) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipArchive);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                File targetFile = new File(targetDirectory, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    targetFile.mkdirs();
                    continue;
                }
                targetFile.getParentFile().mkdirs();
                targetFile.createNewFile();
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                     InputStream in = zipFile.getInputStream(zipEntry);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipDir(File sourceDir, File outputFile) throws IOException {
        klog.info("Zipping: {} to {}", (Object)sourceDir.getName(), (Object)outputFile.getAbsolutePath());
        Path rootPath = Paths.get(sourceDir.getAbsolutePath(), new String[0]);
        try (ZipOutputStream zipFile = new ZipOutputStream(new FileOutputStream(outputFile));){
            this.addDirContentsToZip(sourceDir, sourceDir, zipFile, rootPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirContentsToZip(File rootDir, File sourceDir, ZipOutputStream out, Path rootPath) throws IOException {
        String pathFromRoot = "";
        if (rootDir != sourceDir) {
            Path sourcePath = Paths.get(sourceDir.getAbsolutePath(), new String[0]);
            Path relativeSourcePath = rootPath.relativize(sourcePath);
            pathFromRoot = relativeSourcePath.toString();
        }
        for (File file : sourceDir.listFiles()) {
            if (file.isDirectory()) {
                this.addDirContentsToZip(rootDir, file, out, rootPath);
                continue;
            }
            String entryPath = FilenameUtils.normalize((String)FilenameUtils.concat((String)pathFromRoot, (String)file.getName()), (boolean)true);
            ZipEntry entry = new ZipEntry(entryPath);
            out.putNextEntry(entry);
            try (FileInputStream in = new FileInputStream(file);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }
}

