/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.dnd;

import edu.mit.broad.genome.swing.dnd.DndTarget;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public class DropTargetDecorator
implements DropTargetListener {
    private DropTarget fDropTarget;
    private DndTarget fTarget;
    private final int fAcceptActions = 3;

    public DropTargetDecorator(DndTarget target) {
        if (target == null) {
            throw new IllegalArgumentException("DndTarget cannot be null");
        }
        this.fTarget = target;
        this.fDropTarget = new DropTarget(this.fTarget.getDroppableIntoComponent(), this.fAcceptActions, this, true);
    }

    private boolean isDragFlavorSupported(DropTargetDragEvent e) {
        DataFlavor[] flavors = this.fTarget.getDroppableFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!e.isDataFlavorSupported(flavors[i])) continue;
            return true;
        }
        return false;
    }

    private DataFlavor chooseDropFlavor(DropTargetDropEvent e) {
        DataFlavor[] flavors = this.fTarget.getDroppableFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!e.isDataFlavorSupported(flavors[i])) continue;
            return flavors[i];
        }
        return null;
    }

    private boolean isDragOk(DropTargetDragEvent e) {
        if (!this.isDragFlavorSupported(e)) {
            return false;
        }
        int da = e.getDropAction();
        return (da & 3) != 0;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (!this.isDragOk(e)) {
            e.rejectDrag();
            return;
        }
        e.acceptDrag(e.getDropAction());
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (!this.isDragOk(e)) {
            DropTargetContext context = e.getDropTargetContext();
            context.getComponent().setCursor(DragSource.DefaultCopyNoDrop);
            context.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            e.rejectDrag();
            return;
        }
        e.acceptDrag(e.getDropAction());
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        if (!this.isDragOk(e)) {
            e.rejectDrag();
            return;
        }
        e.acceptDrag(e.getDropAction());
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        DataFlavor chosen = this.chooseDropFlavor(e);
        if (chosen == null) {
            e.rejectDrop();
            return;
        }
        int sa = e.getSourceActions();
        if ((sa & 3) == 0) {
            e.rejectDrop();
            return;
        }
        Object data = null;
        try {
            e.acceptDrop(this.fAcceptActions);
            data = e.getTransferable().getTransferData(chosen);
            if (data == null) {
                throw new NullPointerException("Tarnsferable data was null");
            }
            this.fTarget.setDropData(data);
            e.dropComplete(true);
        }
        catch (Throwable t) {
            Application.getWindowManager().showError("Bad drop -- couldn't get transfer data", t);
            e.dropComplete(false);
        }
    }
}

