/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JComponent;

public class ImageComponent
extends JComponent {
    private Image image = null;
    private boolean scaled = false;
    private Dimension size = null;
    private Insets insets = new Insets(0, 0, 0, 0);

    public ImageComponent(Image image, boolean scaled) {
        this.image = image;
        this.scaled = scaled;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.insets = this.getInsets(this.insets);
        this.size = this.getSize(this.size);
        if (this.image == null) {
            return;
        }
        if (this.scaled) {
            g.drawImage(this.image, this.insets.left, this.insets.top, this.size.width - this.insets.left - this.insets.right, this.size.height - this.insets.top - this.insets.bottom, this);
        } else {
            g.drawImage(this.image, this.insets.left, this.insets.top, this);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        int imgw = 32;
        int imgh = 32;
        if (this.image != null) {
            imgw = this.image.getWidth(this);
            imgh = this.image.getHeight(this);
        }
        this.insets = this.getInsets(this.insets);
        return new Dimension(this.insets.left + Math.max(32, imgw / 10) + this.insets.right, this.insets.top + Math.max(32, imgh / 10) + this.insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        int imgw = 32;
        int imgh = 32;
        if (this.image != null) {
            imgw = this.image.getWidth(this);
            imgh = this.image.getHeight(this);
        }
        this.insets = this.getInsets(this.insets);
        return new Dimension(this.insets.left + imgw + this.insets.right, this.insets.top + imgh + this.insets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

