/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.distrib.RangeFactory;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartImpl;
import edu.mit.broad.genome.math.ColorSchemes;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.models.XYDatasetProxy2;
import edu.mit.broad.genome.objects.ColorDataset;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.xy.XYDataset;

public class RankedListCharts {
    private static ColorSchemes.ColorScheme RED = new ColorSchemes.BroadCancerRed();
    private static ColorSchemes.ColorScheme BLUE = new ColorSchemes.BroadCancerBlue();

    public static XChart createRankedListChart(RankedList rl, String classAName_opt, String classBName_opt) {
        String title = "Ranked Gene List Correlation Profile";
        XYPlot plot = RankedListCharts._createRankedListChart(rl, classAName_opt, classBName_opt);
        MetricWeightStruc mws = rl.getMetricWeightStruc();
        if (mws != null) {
            ValueMarker midLine = new ValueMarker((double)mws.getTotalPosLength());
            midLine.setPaint((Paint)Color.BLACK);
            midLine.setStroke((Stroke)new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{10.0f, 5.0f, 5.0f, 5.0f}, 0.0f));
            float abias = mws.getTotalPosWeight_frac() * 100.0f;
            String abias_s = Printf.format(abias, 1);
            String cl = Printf.format(mws.getTotalPosLength_frac() * 100.0f, 1);
            String label = "Corr. area bias to " + classAName_opt + " = " + abias_s + "% & Zero crossing at rank " + mws.getTotalPosLength() + " (" + cl + "%)";
            midLine.setLabel(label);
            midLine.setLabelBackgroundColor(Color.WHITE);
            midLine.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            plot.addDomainMarker((Marker)midLine);
        }
        return new XChartImpl("ranked_list_corr", title, "Ranked list correlations for " + rl.getName(), (Plot)plot);
    }

    public static XChart createRankedListChart(RankedList rl, String classAName_opt, String classBName_opt, int peakAt) {
        String title = "Ranked Gene List Correlation Profile";
        XYPlot plot = RankedListCharts._createRankedListChart(rl, classAName_opt, classBName_opt);
        MetricWeightStruc mws = rl.getMetricWeightStruc();
        if (mws != null) {
            ValueMarker midLine = new ValueMarker((double)mws.getTotalPosLength());
            midLine.setPaint((Paint)Color.BLACK);
            midLine.setStroke((Stroke)new BasicStroke(0.25f, 0, 0, 3.0f, new float[]{5.0f, 3.0f, 3.0f, 3.0f}, 0.0f));
            String label = "Zero cross at " + mws.getTotalPosLength();
            midLine.setLabel(label);
            midLine.setLabelBackgroundColor(Color.WHITE);
            midLine.setLabelAnchor(RectangleAnchor.CENTER);
            plot.addDomainMarker((Marker)midLine);
        }
        return new XChartImpl("ranked_list_corr", title, "Ranked list correlations for " + rl.getName(), (Plot)plot);
    }

    private static XYPlot _createRankedListChart(RankedList rl, String classAName_opt, String classBName_opt) {
        Object axis_title = "Ranked list metric";
        MetricWeightStruc mws = rl.getMetricWeightStruc();
        if (mws != null && mws.getMetricName() != null) {
            axis_title = (String)axis_title + " (" + mws.getMetricName() + ")";
        }
        NumberAxis xAxis = new NumberAxis("Gene list location");
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis((String)axis_title);
        yAxis.setTickMarksVisible(false);
        yAxis.setTickLabelsVisible(true);
        Vector scores = Vector.infinityAdjustRankedScoreVector(rl.getScoresV(false));
        XYDatasetProxy2 data = new XYDatasetProxy2(scores, "Ranking metric scores");
        StandardXYItemRenderer rend = new StandardXYItemRenderer(10);
        XYPlot plot = new XYPlot((XYDataset)data, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)rend);
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.LIGHT_GRAY);
        if (classAName_opt != null || classBName_opt != null) {
            IntervalMarker target;
            if (classAName_opt != null && classAName_opt.length() > 0) {
                float max = scores.max();
                target = new IntervalMarker((double)max, (double)max);
                target.setLabel("'" + classAName_opt + "' (positively correlated)");
                target.setLabelFont(new Font("SansSerif", 0, 10));
                target.setLabelAnchor(RectangleAnchor.LEFT);
                target.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
                target.setLabelPaint((Paint)Color.RED);
                target.setLabelBackgroundColor(Color.WHITE);
                target.setOutlineStroke((Stroke)new BasicStroke(0.0f));
                target.setOutlinePaint((Paint)new Color(0, 0, 0, 0));
                plot.addRangeMarker((Marker)target);
            }
            if (classBName_opt != null && classBName_opt.length() > 0) {
                float min = scores.min();
                target = new IntervalMarker((double)min, (double)min);
                target.setLabel("'" + classBName_opt + "' (negatively correlated)");
                target.setLabelFont(new Font("SansSerif", 0, 10));
                target.setLabelAnchor(RectangleAnchor.BOTTOM);
                target.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
                target.setLabelPaint((Paint)Color.BLUE);
                target.setLabelBackgroundColor(Color.WHITE);
                target.setOutlineStroke((Stroke)new BasicStroke(0.0f));
                target.setOutlinePaint((Paint)new Color(0, 0, 0, 0));
                plot.addRangeMarker((Marker)target);
            }
        }
        return plot;
    }

    public static IntervalMarker[] createIntervalMarkers(int numRanges, RankedList rl) {
        ArrayList<IntervalMarker> list = new ArrayList<IntervalMarker>();
        RankedList rl_pos = rl.extractRanked(ScoreMode.POS_ONLY);
        Range[] ranges_on_full_list = RangeFactory.createRanges(numRanges, 0.0, rl_pos.getSize());
        IntervalMarker[] markers = RankedListCharts._createIntervalMarkers(numRanges, rl_pos, ranges_on_full_list, 0, RED);
        list.addAll(Arrays.asList(markers));
        RankedList rl_neg = rl.extractRanked(ScoreMode.NEG_ONLY);
        ranges_on_full_list = RangeFactory.createRanges(numRanges, rl_pos.getSize(), rl.getSize());
        markers = RankedListCharts._createIntervalMarkers(numRanges, rl_neg, ranges_on_full_list, rl_pos.getSize() + 1, BLUE);
        list.addAll(Arrays.asList(markers));
        return list.toArray(new IntervalMarker[list.size()]);
    }

    private static IntervalMarker[] _createIntervalMarkers(int numRanges, RankedList rl, Range[] rangesForMarkers, int startX, ColorSchemes.ColorScheme cs) {
        ColorDataset cds = new DatasetGenerators().createColorDataset(numRanges, rl, cs);
        IntervalMarker[] markers = new IntervalMarker[numRanges];
        double prev_start = startX;
        for (int c = 0; c < rangesForMarkers.length; ++c) {
            markers[c] = new IntervalMarker(prev_start, rangesForMarkers[c].getMax());
            prev_start = rangesForMarkers[c].getMin();
            markers[c].setPaint((Paint)cds.getColor(0, c));
        }
        return markers;
    }
}

