/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetSignal;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import gnu.trove.TIntArrayList;
import java.util.HashSet;

public class GeneSetSignalImpl
implements GeneSetSignal {
    private TIntArrayList fCoreRanks;
    private EnrichmentResult fEr;
    private GeneSet fCoreGeneSet;

    public GeneSetSignalImpl(EnrichmentResult er) {
        this.fEr = er;
        this.fCoreRanks = new TIntArrayList();
        int[] hitIndices = er.getScore().getHitIndices();
        int coreRank = er.getScore().getRankAtES();
        float es = er.getScore().getES();
        for (int i = 0; i < hitIndices.length; ++i) {
            if (XMath.isPositive(es)) {
                if (hitIndices[i] > coreRank) continue;
                this.fCoreRanks.add(hitIndices[i]);
                continue;
            }
            if (hitIndices[i] < coreRank) continue;
            this.fCoreRanks.add(hitIndices[i]);
        }
    }

    public String getName() {
        return this.fEr.getGeneSetName() + "_signal";
    }

    @Override
    public int getSize() {
        return this.fCoreRanks.size();
    }

    @Override
    public GeneSet getAsGeneSet() {
        if (this.fCoreGeneSet == null) {
            RankedList rl = this.fEr.getRankedList();
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < this.fCoreRanks.size(); ++i) {
                set.add(rl.getRankName(this.fCoreRanks.get(i)));
            }
            this.fCoreGeneSet = new GeneSet(this.getName(), set);
        }
        return this.fCoreGeneSet;
    }

    @Override
    public int getRankAtMax() {
        float es = this.fEr.getScore().getES();
        if (XMath.isPositive(es)) {
            return this.fEr.getScore().getRankAtES();
        }
        return this.fEr.getRankedList().getSize() - this.fEr.getScore().getRankAtES();
    }

    @Override
    public float getTagFraction() {
        return (float)this.getSize() / (float)this.fEr.getGeneSet().getNumMembers();
    }

    @Override
    public float getListFraction() {
        return (float)this.getRankAtMax() / (float)this.fEr.getRankedList().getSize();
    }

    @Override
    public float getSignalStrength() {
        float tag = this.getTagFraction();
        float list = this.getListFraction();
        float numr = tag / (1.0f - list);
        float N = this.fEr.getRankedList().getSize();
        float Nh = this.fEr.getGeneSet().getNumMembers();
        float denr = N / (N - Nh);
        return numr / denr;
    }
}

