/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TemplateImplFromSampleNames
extends AbstractObject
implements Template {
    private Template fCreatedTemplate;
    private String fClassAName;
    private String[] fClassASampleNames;
    private String fClassBName;
    private String[] fClassBSampleNames;

    public TemplateImplFromSampleNames(String name, String classAName, String[] classASampleNames, String classBName, String[] classBSampleNames) {
        if (classAName == null || classAName.length() == 0) {
            throw new IllegalArgumentException("Param classAName cannot be null or zero length");
        }
        if (classBName == null || classBName.length() == 0) {
            throw new IllegalArgumentException("Param classBName cannot be null or zero length");
        }
        super.initialize(name);
        if (classAName.equalsIgnoreCase(classBName)) {
            throw new IllegalArgumentException("Class names cannot be the same classAName: " + classAName + " classBName: " + classBName);
        }
        List<String> ca = Arrays.asList(classASampleNames);
        Errors errors = new Errors();
        for (int i = 0; i < classBSampleNames.length; ++i) {
            if (!ca.contains(classBSampleNames[i])) continue;
            errors.add("This sample is in both classes: " + classBSampleNames[i]);
        }
        errors.barfIfNotEmptyRuntime();
        this.fClassAName = classAName;
        this.fClassASampleNames = TemplateImplFromSampleNames._toUniques(classASampleNames);
        this.fClassBName = classBName;
        this.fClassBSampleNames = TemplateImplFromSampleNames._toUniques(classBSampleNames);
    }

    public Template createTemplate(Dataset ds) {
        this.fCreatedTemplate = TemplateFactory.createCategoricalTemplate(NamingConventions.removeExtension(this.getName()) + "_" + ds.getName(), ds, this.fClassAName, this.fClassASampleNames, this.fClassBName, this.fClassBSampleNames);
        return this.fCreatedTemplate;
    }

    @Override
    public Template cloneDeep(String newName) {
        if (this._got_ct()) {
            return this._ct().cloneDeep(newName);
        }
        return new TemplateImplFromSampleNames(newName, this.fClassAName, this.fClassASampleNames, this.fClassBName, this.fClassBSampleNames);
    }

    public Template cloneDeepReversed(String newName) {
        return new TemplateImplFromSampleNames(newName, this.fClassBName, this.fClassBSampleNames, this.fClassAName, this.fClassASampleNames);
    }

    @Override
    public void makeImmutable() {
        if (this._got_ct()) {
            this._ct().makeImmutable();
        }
    }

    @Override
    public String getQuickInfo() {
        if (this._got_ct()) {
            return this.fCreatedTemplate.getQuickInfo();
        }
        return this.fClassAName + " (" + this.fClassASampleNames.length + ") " + this.fClassBName + " (" + this.fClassBSampleNames.length + ")";
    }

    @Override
    public boolean isAux() {
        return false;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isCategorical() {
        return true;
    }

    @Override
    public String getClassName(int classIndex) {
        if (classIndex == 0) {
            return this.fClassAName;
        }
        if (classIndex == 1) {
            return this.fClassBName;
        }
        throw new IllegalArgumentException("Too large: " + classIndex);
    }

    public int getClassIndex(String name) {
        if (name.equals(this.fClassAName)) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getClassIndex(Template.Class cl) {
        return this.getClassIndex(cl.getName());
    }

    @Override
    public int getNumClasses() {
        return 2;
    }

    @Override
    public boolean isMemberClass(Template.Class cl) {
        return cl.getName().equals(this.fClassAName) || cl.getName().equals(this.fClassBName);
    }

    private Template _ct() {
        if (this.fCreatedTemplate == null) {
            throw new IllegalArgumentException("Dataset not set!!");
        }
        return this.fCreatedTemplate;
    }

    private boolean _got_ct() {
        return this.fCreatedTemplate != null;
    }

    @Override
    public Color getItemColor(int itemProfilePos) {
        return this._ct().getItemColor(itemProfilePos);
    }

    @Override
    public boolean isAscendingProfilePositions() {
        return this._ct().isAscendingProfilePositions();
    }

    @Override
    public Template.Class getClass(Template.Item item) {
        return this._ct().getClass(item);
    }

    @Override
    public Template.Class getClass(int classIndex) {
        return this._ct().getClass(classIndex);
    }

    @Override
    public String getClassOfInterestName() {
        return this._ct().getClassOfInterestName();
    }

    @Override
    public int getClassOfInterestIndex() {
        return this._ct().getClassOfInterestIndex();
    }

    @Override
    public int[] getProfilePositionsOrdered() {
        return this._ct().getProfilePositionsOrdered();
    }

    @Override
    public Template.Item getItemByProfilePos(int profilePos) {
        return this._ct().getItemByProfilePos(profilePos);
    }

    @Override
    public Template.Item[] getItemsOrderedByProfilePos() {
        return this._ct().getItemsOrderedByProfilePos();
    }

    @Override
    public Template.Item[] getItemsOrderedByClassFirstAndThenProfilePos() {
        return this._ct().getItemsOrderedByClassFirstAndThenProfilePos();
    }

    @Override
    public int getNumItems() {
        return this._ct().getNumItems();
    }

    @Override
    public Vector toVector() {
        return this._ct().toVector();
    }

    @Override
    public String getAsString(boolean gcFormat) {
        return this._ct().getAsString(gcFormat);
    }

    @Override
    public Vector[] splitByTemplateClass(Vector profile) {
        return this._ct().splitByTemplateClass(profile);
    }

    @Override
    public Vector synchProfile(Vector profile) {
        return this._ct().synchProfile(profile);
    }

    private static String[] _toUniques(String[] ss) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i].trim();
            if (s.length() == 0 || list.contains(s)) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }
}

