/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateDerivative;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import java.io.File;

public class TemplateDerivatives {

    public static class AuxTemplateDerivative
    implements TemplateDerivative {
        private String fAuxName;
        private String fJustName;
        private Template fMainTemplate;

        public AuxTemplateDerivative(String auxName, Template mainTemplate) {
            if (auxName == null) {
                throw new IllegalArgumentException("Parameter auxName cannot be null");
            }
            if (mainTemplate == null) {
                throw new IllegalArgumentException("Parameter mainTemplate cannot be null");
            }
            this.fAuxName = auxName;
            this.fMainTemplate = mainTemplate;
            this.fJustName = AuxUtils.getAuxNameOnlyNoHash(this.fAuxName);
        }

        @Override
        public String getName(boolean parentNamePlusMyName, boolean fullPath) {
            Object ret = fullPath ? ParserFactory.getCache().getSourcePath(this.fMainTemplate) + "#" : (parentNamePlusMyName ? this.fMainTemplate.getName() + "#" : "");
            return (String)ret + this.fJustName;
        }
    }

    public static class PseudoTemplateDerivative
    implements TemplateDerivative {
        private Template fMainTemplate;

        public PseudoTemplateDerivative(Template mainTemplate) {
            if (mainTemplate == null) {
                throw new IllegalArgumentException("Parameter mainTemplate cannot be null");
            }
            this.fMainTemplate = mainTemplate;
        }

        @Override
        public String getName(boolean parentNamePlusMyName, boolean fullPath) {
            if (fullPath) {
                return ParserFactory.getCache().getSourcePath(this.fMainTemplate);
            }
            return this.fMainTemplate.getName();
        }
    }

    public static class ContTemplateDerivative
    implements TemplateDerivative {
        private String fAuxName;
        private String fJustName;
        private File fMainTemplateFile;

        public ContTemplateDerivative(String auxName, File mainTemplateFile) {
            if (auxName == null) {
                throw new IllegalArgumentException("Parameter auxName cannot be null");
            }
            if (mainTemplateFile == null) {
                throw new IllegalArgumentException("Parameter mainTemplateFile cannot be null");
            }
            this.fAuxName = auxName;
            this.fMainTemplateFile = mainTemplateFile;
            this.fJustName = AuxUtils.getAuxNameOnlyNoHash(this.fAuxName);
        }

        @Override
        public String getName(boolean parentNamePlusMyName, boolean fullPath) {
            Object ret = fullPath ? this.fMainTemplateFile.getPath() + "#" : (parentNamePlusMyName ? this.fMainTemplateFile.getName() + "#" : "");
            return (String)ret + this.fJustName;
        }
    }
}

