/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.MSigDBSpecies;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class MSigDBVersion {
    private static AtomicInteger unknownTrackingCounter = new AtomicInteger(0);
    private final MSigDBSpecies msigDBSpecies;
    private final String versionString;
    private final DefaultArtifactVersion artifactVersion;

    public static MSigDBVersion createUnknownTrackingVersion(String id) {
        String trackingString = id + "-unknown-" + unknownTrackingCounter.incrementAndGet();
        return new MSigDBVersion(MSigDBSpecies.Unknown, trackingString){

            @Override
            public boolean isUnknownVersion() {
                return true;
            }
        };
    }

    public MSigDBVersion(MSigDBSpecies msigDBSpecies, String versionString) {
        if (msigDBSpecies == null || StringUtils.isBlank((CharSequence)versionString)) {
            throw new IllegalArgumentException("msigDBSpecies and versionString must not be null or blank.");
        }
        this.msigDBSpecies = msigDBSpecies;
        this.versionString = versionString;
        this.artifactVersion = new DefaultArtifactVersion(versionString);
    }

    public MSigDBSpecies getMsigDBSpecies() {
        return this.msigDBSpecies;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public DefaultArtifactVersion getArtifactVersion() {
        return this.artifactVersion;
    }

    public boolean isUnknownVersion() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.msigDBSpecies, this.versionString});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MSigDBVersion other = (MSigDBVersion)obj;
        return this.msigDBSpecies == other.msigDBSpecies && Objects.equals(this.versionString, other.versionString);
    }
}

