/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

public class SortMode {
    public static final SortMode REAL = new SortMode("real");
    public static final SortMode ABSOLUTE = new SortMode("abs");
    public static final SortMode[] ALL = new SortMode[]{REAL, ABSOLUTE};
    private final String fType;

    private SortMode(String type) {
        this.fType = type;
    }

    public String toString() {
        return this.fType;
    }

    public boolean equals(Object obj) {
        return obj instanceof SortMode && ((SortMode)obj).fType.equals(this.fType);
    }

    public int hashCode() {
        return this.fType.hashCode();
    }

    public boolean isAbsolute() {
        return this.fType.equals(SortMode.ABSOLUTE.fType);
    }

    public static SortMode lookup(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Null mode not allowed");
        }
        if (obj instanceof SortMode) {
            return (SortMode)obj;
        }
        String s = obj.toString();
        if (s.equalsIgnoreCase(SortMode.REAL.fType)) {
            return REAL;
        }
        if (s.equalsIgnoreCase(ABSOLUTE.toString())) {
            return ABSOLUTE;
        }
        throw new IllegalArgumentException("Unable to lookup direction String: " + obj);
    }
}

