/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import java.io.PrintWriter;
import java.io.StringWriter;

public class TraceUtils {
    public static String getAsString(Throwable e) {
        if (e == null) {
            return "null exception";
        }
        if (e.getMessage() != null && e.getMessage().equalsIgnoreCase("No stack trace available")) {
            return e.getMessage();
        }
        StringWriter buf = new StringWriter();
        e.printStackTrace(new PrintWriter(buf));
        return buf.toString();
    }

    public static String getAsString(Throwable[] errors) {
        if (errors == null || errors.length == 0) {
            return "There were no exception stack traces available";
        }
        StringBuffer buf = new StringBuffer("# of exceptions: ").append(errors.length).append('\n');
        for (int i = 0; i < errors.length; ++i) {
            if (errors[i] == null) {
                buf.append("null exception at: ").append(i).append('\n');
                continue;
            }
            buf.append("------").append(errors[i].getMessage()).append("------\n");
            buf.append(TraceUtils.getAsString(errors[i])).append('\n').append('\n');
        }
        return buf.toString();
    }

    public static void showTrace() {
        try {
            throw new Exception("");
        }
        catch (Exception t) {
            System.out.print("\n");
            t.printStackTrace();
            return;
        }
    }
}

