/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class Errors {
    private List<String> fErrors_as_strings = new ArrayList<String>();
    private List<Throwable> fErrors_as_throwables = new ArrayList<Throwable>();
    private String fErrorName;

    public Errors() {
        this("ERROR(S)");
    }

    public Errors(String errorName) {
        this.fErrorName = errorName;
    }

    public String getName() {
        return this.fErrorName;
    }

    public void add(String s) {
        if (!this.fErrors_as_strings.contains(s)) {
            this.fErrors_as_strings.add(s);
        }
    }

    public void add(Throwable t) {
        this.fErrors_as_strings.add(Errors.getAsString(t));
        if (t != null && !this.fErrors_as_throwables.contains(t)) {
            this.fErrors_as_throwables.add(t);
        }
    }

    public void add(String msg, Throwable t) {
        this.fErrors_as_strings.add(msg + "\n" + Errors.getAsString(t));
        if (t != null && !this.fErrors_as_throwables.contains(t)) {
            this.fErrors_as_throwables.add(t);
        }
    }

    public boolean isEmpty() {
        return this.fErrors_as_strings.isEmpty() && this.fErrors_as_throwables.isEmpty();
    }

    public Throwable[] getErrors() {
        return this.fErrors_as_throwables.toArray(new Throwable[this.fErrors_as_throwables.size()]);
    }

    public String[] getErrorsAsStrings() {
        return this.fErrors_as_strings.toArray(new String[this.fErrors_as_strings.size()]);
    }

    public String getErrors(boolean html) {
        StringBuilder buf = new StringBuilder("There were errors: ").append(this.fErrorName).append(" #:").append(this.fErrors_as_strings.size());
        String lineBreak = html ? "<br>" : "\n";
        buf.append(lineBreak);
        for (int i = 0; i < this.fErrors_as_strings.size(); ++i) {
            buf.append(this.fErrors_as_strings.get(i));
            buf.append(lineBreak);
        }
        return buf.toString();
    }

    public void barfIfNotEmptyRuntime() throws RuntimeException {
        this.barfIfNotEmptyRuntime(null);
    }

    public void barfIfNotEmptyRuntime(String msg) throws RuntimeException {
        if (!this.fErrors_as_strings.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            if (msg != null && msg.length() > 0) {
                buf.append(msg).append('\n');
            }
            buf.append("There were errors: ").append(this.fErrorName).append(" #:").append(this.fErrors_as_strings.size()).append("\n");
            for (int i = 0; i < this.fErrors_as_strings.size(); ++i) {
                buf.append(this.fErrors_as_strings.get(i).toString()).append('\n');
            }
            throw new RuntimeException(buf.toString());
        }
    }

    private static String getAsString(Throwable e) {
        if (e == null) {
            return "null exception";
        }
        StringWriter buf = new StringWriter();
        e.printStackTrace(new PrintWriter(buf));
        return buf.toString();
    }
}

