/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AbstractFTPInputStream;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

class FTPBinaryInputStream
extends AbstractFTPInputStream {
    private static Logger log = Logger.getLogger("FTPBinaryInputStream");
    private static int SKIP_THRESHOLD = 65536;
    private long mark = -1L;
    private int skipThreshold = SKIP_THRESHOLD;

    public FTPBinaryInputStream(FTPClient client, String remoteFile) throws IOException, FTPException {
        this(client, remoteFile, 0L);
    }

    public FTPBinaryInputStream(FTPClient client, String remoteFile, long offset) throws IOException, FTPException {
        super(client, remoteFile);
        this.pos = offset;
    }

    public int read() throws IOException {
        byte[] b;
        if (!this.started) {
            this.start();
        }
        if (this.client.readChunk(this.in, b = new byte[1], 0, b.length) < 0) {
            return -1;
        }
        ++this.monitorCount;
        ++this.pos;
        this.checkMonitor();
        return 0xFF & b[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.started) {
            this.start();
        }
        int count = this.client.readChunk(this.in, b, off, len);
        this.monitorCount += (long)count;
        this.pos += (long)count;
        this.checkMonitor();
        return count;
    }

    public long skip(long n) throws IOException {
        log.debug("Skipping " + n + " bytes");
        if (this.started) {
            this.stop();
        }
        long bytes = n;
        long len = 0L;
        this.pos += n;
        try {
            len = this.client.size(this.getRemoteFile());
            if (this.pos > len) {
                bytes = len - this.pos;
                this.pos = len;
            }
        }
        catch (FTPException ex) {
            throw new IOException(ex.getMessage());
        }
        return bytes;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
        log.debug("Mark set at " + this.pos + " bytes in file");
    }

    public synchronized void reset() throws IOException {
        log.debug("Reset called - resetting to " + this.mark + " bytes");
        if (this.mark < 0L) {
            throw new IOException("mark not called before reset()");
        }
        if (this.started) {
            this.stop();
        }
        this.pos = this.mark;
        this.mark = -1L;
    }

    public boolean markSupported() {
        return true;
    }

    private void stop() throws IOException {
        this.client.closeDataSocket(this.in);
        try {
            this.client.readReply();
        }
        catch (FTPException ex) {
            throw new IOException(ex.getMessage());
        }
        this.started = false;
        this.closed = true;
    }
}

