/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.mail;

import java.io.Closeable;
import java.security.Security;
import java.util.Arrays;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.listmatrix.ListMatrix;
import org.ujmp.core.util.DummySSLSocketFactory;
import org.ujmp.mail.MessagesMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapUtil
implements Closeable {
    private String host = null;
    private String user = null;
    private String password = null;
    private final int connectiontimeout = 5000;
    private final int timeout = 5000;
    private final String protocol = "imaps";
    private final boolean sslEnable = true;
    private final int port = 993;
    private final boolean ignoreCertificate = true;
    private Session session = null;
    private Store store = null;

    public ImapUtil(String host, String user, String password) {
        this.host = host;
        this.user = user;
        this.password = password;
        Properties props = System.getProperties();
        props.setProperty("mail.imap.host", host);
        props.setProperty("mail.imap.port", "993");
        props.setProperty("mail.imap.connectiontimeout", "5000");
        props.setProperty("mail.imap.timeout", "5000");
        props.setProperty("mail.store.protocol", "imaps");
        props.setProperty("mail.imap.ssl.enable", "true");
        Security.setProperty("ssl.SocketFactory.provider", DummySSLSocketFactory.class.getName());
        this.session = Session.getDefaultInstance((Properties)System.getProperties(), null);
    }

    public ListMatrix<Folder> getPersonalFolders() throws Exception {
        Folder[] folders = this.getStore().getPersonalNamespaces();
        DefaultListMatrix<Folder> folderMatrix = new DefaultListMatrix<Folder>(Arrays.asList(folders));
        return folderMatrix;
    }

    public ListMatrix<Folder> getSubFolders(Folder folder) throws Exception {
        Folder[] folders = folder.list();
        DefaultListMatrix<Folder> folderMatrix = new DefaultListMatrix<Folder>(Arrays.asList(folders));
        return folderMatrix;
    }

    public MessagesMatrix getMessages(String folderName) throws Exception {
        Folder folder = this.getStore().getFolder(folderName);
        return this.getMessages(folder);
    }

    public Folder getFolder(String folderName) throws Exception {
        Folder folder = this.getStore().getFolder(folderName);
        return folder;
    }

    public ListMatrix<Folder> getSubFolders(String folderName) throws Exception {
        Folder folder = this.getStore().getFolder(folderName);
        return this.getSubFolders(folder);
    }

    public MessagesMatrix getMessages(Folder folder) throws Exception {
        return new MessagesMatrix(folder);
    }

    private Store getStore() throws Exception {
        if (this.store == null) {
            this.store = this.session.getStore("imaps");
        }
        if (!this.store.isConnected()) {
            this.store.connect(this.host, this.user, this.password);
        }
        return this.store;
    }

    @Override
    public void close() {
        if (this.store != null && this.store.isConnected()) {
            try {
                this.store.close();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }

    public ListMatrix<Folder> getSharedFolders() throws Exception {
        Folder[] folders = this.getStore().getSharedNamespaces();
        DefaultListMatrix<Folder> folderMatrix = new DefaultListMatrix<Folder>(Arrays.asList(folders));
        this.store.close();
        return folderMatrix;
    }
}

