/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.DBType;

public abstract class ExportMatrixJDBC {
    public static void toDatabase(Matrix matrix, String url, String tablename, String username, String password) throws ClassNotFoundException, SQLException {
        if (matrix == null) {
            return;
        }
        if (matrix.isEmpty()) {
            return;
        }
        if (url.startsWith("jdbc:mysql://")) {
            Class.forName("com.mysql.jdbc.Driver");
        } else if (url.startsWith("jdbc:postgresql://")) {
            Class.forName("org.postgresql.Driver");
        } else {
            throw new RuntimeException("Database format not supported: " + url);
        }
        System.out.print("exporting...");
        String[] fields = url.split("/");
        if (fields.length == 4) {
            String[] params = fields[3].split("\\?");
            Connection connection = DriverManager.getConnection(fields[0] + "/" + fields[1] + "/" + fields[2], username, password);
            Statement statement = connection.createStatement();
            String db = "CREATE DATABASE IF NOT EXISTS " + params[0];
            statement.executeUpdate(db);
            statement.close();
            connection.close();
        }
        Connection connection = DriverManager.getConnection(url, username, password);
        Statement statement = connection.createStatement();
        System.out.println("done");
    }

    private static DBType getDBTypeFromUrl(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("jdbc:mysql")) {
            return DBType.MySQL;
        }
        return null;
    }

    public static void toDatabase(Matrix matrix, DBType type, String host, int port, String databasename, String tablename, String username, String password) throws ClassNotFoundException, SQLException {
        switch (type) {
            case MySQL: {
                ExportMatrixJDBC.toDatabase(matrix, "jdbc:mysql://" + host + ":" + port + "/" + databasename, tablename, username, password);
                break;
            }
            default: {
                throw new RuntimeException("not supported: " + (Object)((Object)type));
            }
        }
    }
}

