/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.ujmp.core.util.ReflectionUtil;
import org.ujmp.core.util.SerializationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopMap<K, V>
implements Map<K, V>,
Closeable {
    private MapFile.Reader reader = null;
    private MapFile.Writer writer = null;
    private Configuration conf = new Configuration();
    private Path dirName = new Path("/tmp/test.hadoop");
    private FileSystem fs = FileSystem.getLocal((Configuration)this.conf);
    private Path qualifiedDirName = this.fs.makeQualified(this.dirName);

    public HadoopMap() throws IOException {
        MapFile.Writer.setIndexInterval((Configuration)this.conf, (int)3);
    }

    @Override
    public void clear() {
    }

    private void prepareReader() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.reader == null) {
            this.reader = new MapFile.Reader(this.fs, this.qualifiedDirName.toString(), this.conf);
        }
    }

    private void prepareWriter() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.writer == null) {
            this.writer = new MapFile.Writer(this.conf, this.fs, this.qualifiedDirName.toString(), Text.class, Text.class);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    @Override
    public V get(Object key) {
        try {
            this.prepareReader();
            Text k = new Text(SerializationUtil.serialize((Serializable)key));
            Text v = new Text();
            Text t = (Text)this.reader.get((WritableComparable)k, (Writable)v);
            if (t == null || t.getBytes() == null || t.getBytes().length == 0) {
                return null;
            }
            return (V)SerializationUtil.deserialize(t.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("could not get value for key: " + key, e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return null;
    }

    @Override
    public V put(K key, V value) {
        try {
            this.prepareWriter();
            Text k = new Text(SerializationUtil.serialize((Serializable)key));
            Text v = new Text(SerializationUtil.serialize((Serializable)value));
            this.writer.append((WritableComparable)k, (Writable)v);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("could not store value: " + key + ", " + value, e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K k : m.keySet()) {
            this.put(k, m.get(k));
        }
    }

    @Override
    public V remove(Object key) {
        return null;
    }

    @Override
    public int size() {
        try {
            this.prepareWriter();
            return (int)((Long)ReflectionUtil.extractPrivateField(MapFile.Writer.class, this.writer, "size")).longValue();
        }
        catch (Exception e) {
            throw new RuntimeException("could not query size", e);
        }
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

