/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.statusbar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.ujmp.core.Coordinates;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.util.UJMPTimer;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.statusbar.MemoryUsage;
import org.ujmp.gui.util.TaskQueue;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = -92341245296146976L;
    private final JLabel statusLabel = new JLabel();
    private final GUIObject guiObject;
    private final JProgressBar jProgressBar = new JProgressBar();
    private final UJMPTimer timer;

    public StatusBar(GUIObject o) {
        this.guiObject = o;
        this.setPreferredSize(new Dimension(1000, 30));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.statusLabel.setPreferredSize(new Dimension(2000, 30));
        this.statusLabel.setMinimumSize(new Dimension(200, 30));
        this.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new MemoryUsage(), new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jProgressBar.setStringPainted(false);
        this.jProgressBar.setMinimum(0);
        this.jProgressBar.setMaximum(1000);
        this.jProgressBar.setValue(1000);
        this.jProgressBar.setVisible(false);
        this.statusLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jProgressBar.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.jProgressBar, new GridBagConstraints(1, 0, 1, 1, 0.8, 1.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.timer = UJMPTimer.newInstance("StatusBar " + this.guiObject.getCoreObject().getClass().getSimpleName());
        this.timer.schedule((TimerTask)new UpdateTask(this), 200L, 200L);
    }

    public void setStatusString(String s) {
        this.statusLabel.setText(s);
    }

    public void setProgress(Double progress) {
        if (progress == null) {
            this.jProgressBar.setValue(0);
            this.jProgressBar.setIndeterminate(true);
            this.jProgressBar.setVisible(true);
        } else if (progress == 1.0) {
            this.jProgressBar.setValue(1000);
            this.jProgressBar.setVisible(false);
        } else {
            int value = (int)(progress * (double)this.jProgressBar.getMaximum());
            this.jProgressBar.setIndeterminate(false);
            this.jProgressBar.setValue(value);
            this.jProgressBar.setVisible(true);
        }
    }

    public GUIObject getObject() {
        return this.guiObject;
    }

    class UpdateTask
    extends TimerTask {
        private StatusBar statusBar = null;

        public UpdateTask(StatusBar statusBar2) {
            this.statusBar = statusBar2;
        }

        public void run() {
            StringBuilder s = new StringBuilder();
            if (StatusBar.this.guiObject instanceof MatrixGUIObject) {
                MatrixGUIObject matrix = (MatrixGUIObject)StatusBar.this.guiObject;
                long[] c = matrix.getMouseOverCoordinates();
                s.append("Position: ");
                s.append(Coordinates.toString(c));
                if (!matrix.getRowSelectionModel().isSelectionEmpty() || !matrix.getColumnSelectionModel().isSelectionEmpty()) {
                    long y0 = matrix.getRowSelectionModel().getMinSelectionIndex64();
                    long y1 = matrix.getRowSelectionModel().getMaxSelectionIndex64();
                    long x0 = matrix.getColumnSelectionModel().getMinSelectionIndex64();
                    long x1 = matrix.getColumnSelectionModel().getMaxSelectionIndex64();
                    long xSize = 1L + Math.abs(x1 - x0);
                    long ySize = 1L + Math.abs(y1 - y0);
                    s.append(" Selection: [" + y0 + "," + x0 + "] - [" + y1 + "," + x1 + "] = ");
                    s.append("[" + ySize + "x" + xSize + "]");
                }
                StatusBar.this.setStatusString(s.toString());
            }
            this.statusBar.setProgress(TaskQueue.getProgress());
        }
    }
}

