/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.JPanel;
import org.ujmp.gui.interfaces.CanBeRepainted;
import org.ujmp.gui.interfaces.CanBeUpdated;
import org.ujmp.gui.util.GraphicsExecutor;
import org.ujmp.gui.util.Preloader;
import org.ujmp.gui.util.UIDefaults;
import org.ujmp.gui.util.UpdateListener;

public class BufferedPanel
extends JPanel
implements CanBeRepainted,
ComponentListener,
UpdateListener,
MouseListener {
    private static final long serialVersionUID = 7495571585267828933L;
    private final JPanel panel;
    private BufferedImage bufferedImage = null;

    public BufferedPanel(JPanel panel) {
        this.panel = panel;
        this.addComponentListener(this);
        this.addMouseListener(this);
        panel.setLayout(new BorderLayout());
        panel.add((Component)new Preloader(), "Center");
        if (panel instanceof CanBeUpdated) {
            ((CanBeUpdated)((Object)panel)).addUpdateListener(this);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isShowing()) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.bufferedImage != null) {
                g2d.drawImage(this.bufferedImage, 0, 0, this.getWidth(), this.getHeight(), null);
            } else {
                g2d.addRenderingHints(UIDefaults.AALIAS);
                g2d.setColor(Color.gray);
                g2d.drawLine(0, 0, this.getWidth(), this.getHeight());
                g2d.drawLine(this.getWidth(), 0, 0, this.getHeight());
                GraphicsExecutor.scheduleUpdate(this);
            }
        }
    }

    private void paintUsingReflection(Graphics2D g2d) throws Exception {
        try {
            if (this.panel != null && g2d != null) {
                this.panel.paint(g2d);
            }
        }
        catch (Exception e) {
            Method m = this.panel.getClass().getMethod("paintComponent", Graphics.class);
            boolean accessible = m.isAccessible();
            m.setAccessible(true);
            m.invoke((Object)this.panel, g2d);
            m.setAccessible(accessible);
        }
    }

    public void repaintUI() {
        try {
            if (this.isShowing()) {
                int width = this.getWidth();
                width = width < 1 ? 1 : width;
                int height = this.getHeight();
                height = height < 1 ? 1 : height;
                BufferedImage tempBufferedImage = new BufferedImage(width, height, 1);
                this.panel.setSize(width, height);
                Graphics2D g2d = (Graphics2D)tempBufferedImage.getGraphics();
                this.paintUsingReflection(g2d);
                g2d.dispose();
                this.bufferedImage = tempBufferedImage;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void componentHidden(ComponentEvent e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void componentMoved(ComponentEvent e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void componentResized(ComponentEvent e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void componentShown(ComponentEvent e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void updated() {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.panel.getMouseListeners() != null && this.panel.getMouseListeners().length != 0) {
            MouseEvent e2 = new MouseEvent(this.panel, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (MouseListener m : this.panel.getMouseListeners()) {
                m.mouseClicked(e2);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.panel.getMouseListeners() != null && this.panel.getMouseListeners().length != 0) {
            MouseEvent e2 = new MouseEvent(this.panel, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (MouseListener m : this.panel.getMouseListeners()) {
                m.mousePressed(e2);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.panel.getMouseListeners() != null && this.panel.getMouseListeners().length != 0) {
            MouseEvent e2 = new MouseEvent(this.panel, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (MouseListener m : this.panel.getMouseListeners()) {
                m.mouseReleased(e2);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.panel.getMouseListeners() != null && this.panel.getMouseListeners().length != 0) {
            MouseEvent e2 = new MouseEvent(this.panel, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (MouseListener m : this.panel.getMouseListeners()) {
                m.mouseEntered(e2);
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.panel.getMouseListeners() != null && this.panel.getMouseListeners().length != 0) {
            MouseEvent e2 = new MouseEvent(this.panel, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (MouseListener m : this.panel.getMouseListeners()) {
                m.mouseExited(e2);
            }
        }
    }
}

