/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.HasMetaData;
import org.ujmp.core.objectmatrix.DenseObjectMatrix2D;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportMatrixATOM {
    public static final Matrix fromStream(InputStream stream, Object ... parameters) throws ParserConfigurationException, SAXException, IOException {
        Node n;
        int c;
        HasMetaData m = null;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(stream);
        NodeList items = doc.getElementsByTagName("entry");
        m = (HasMetaData)DenseObjectMatrix2D.Factory.zeros((long)items.getLength(), 5L);
        m.setColumnLabel(0L, "Id");
        m.setColumnLabel(1L, "Label");
        m.setColumnLabel(2L, "Link");
        m.setColumnLabel(3L, "Description");
        m.setColumnLabel(4L, "Date");
        for (int i = 0; i < items.getLength(); ++i) {
            Node item = items.item(i);
            for (c = 0; c < item.getChildNodes().getLength(); ++c) {
                n = item.getChildNodes().item(c);
                if (n.getNodeName().equalsIgnoreCase("id")) {
                    m.setAsObject(n.getTextContent(), i, 0L);
                    continue;
                }
                if (n.getNodeName().equalsIgnoreCase("title")) {
                    m.setAsObject(n.getTextContent(), i, 1L);
                    continue;
                }
                if (n.getNodeName().equalsIgnoreCase("link")) {
                    Node h = n.getAttributes().getNamedItem("href");
                    if (h != null) {
                        m.setAsObject(h.getTextContent(), i, 2L);
                        continue;
                    }
                    m.setAsObject(n.getTextContent(), i, 2L);
                    continue;
                }
                if (n.getNodeName().equalsIgnoreCase("summary")) {
                    m.setAsObject(n.getTextContent(), i, 3L);
                    continue;
                }
                if (!n.getNodeName().equalsIgnoreCase("updated")) continue;
                m.setAsObject(n.getTextContent(), i, 4L);
            }
        }
        NodeList channels = doc.getElementsByTagName("feed");
        if (channels.getLength() > 0) {
            Node channel = channels.item(0);
            for (c = 0; c < channel.getChildNodes().getLength(); ++c) {
                n = channel.getChildNodes().item(c);
                if (!n.getNodeName().equalsIgnoreCase("title")) continue;
                m.setLabel(n.getTextContent());
            }
        }
        return m;
    }

    public static final Matrix fromFile(File file, Object ... parameters) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream lr = new FileInputStream(file);
        Matrix m = ImportMatrixATOM.fromStream(lr, parameters);
        lr.close();
        return m;
    }
}

