/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.impl;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.ujmp.core.intmatrix.stub.AbstractDenseIntMatrix2D;
import org.ujmp.core.util.io.HttpUtil;

public class ImageMatrix
extends AbstractDenseIntMatrix2D {
    private static final long serialVersionUID = -1354524587823816194L;
    private final BufferedImage bufferedImage;

    public ImageMatrix(String filename) throws IOException {
        this(new File(filename));
    }

    public ImageMatrix(BufferedImage bufferedImage) {
        super((long)bufferedImage.getHeight(), (long)bufferedImage.getWidth());
        this.bufferedImage = bufferedImage;
    }

    public ImageMatrix(File file) throws IOException {
        this(ImageIO.read(file));
    }

    public ImageMatrix(byte[] bytes) throws IOException {
        this(ImageIO.read(new ByteArrayInputStream(bytes)));
    }

    public ImageMatrix(InputStream stream) throws IOException {
        this(ImageIO.read(stream));
    }

    public ImageMatrix(URL url) throws IOException {
        this(HttpUtil.getBytesFromUrl(url));
    }

    public int getInt(long row, long column) {
        return this.getInt((int)row, (int)column);
    }

    public void setInt(int value, long row, long column) {
        this.setInt(value, (int)row, (int)column);
    }

    public int getInt(int row, int column) {
        return this.bufferedImage.getRGB(column, row);
    }

    public void setInt(int value, int row, int column) {
        this.bufferedImage.setRGB(column, row, value);
    }
}

