/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.list;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.ujmp.core.collections.list.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA = new Object[0];
    private boolean hashCodeUpToDate = false;
    private int hashCode = -1;
    private transient Object[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public FastArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
    }

    public FastArrayList() {
        this.elementData = EMPTY_ELEMENTDATA;
    }

    public FastArrayList(Collection<? extends E> c) {
        this.elementData = c.toArray();
        this.size = this.elementData.length;
        if (this.elementData.getClass() != Object[].class) {
            this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
        }
    }

    public FastArrayList(E ... c) {
        this.elementData = (Object[])c.clone();
        this.size = this.elementData.length;
        if (this.elementData.getClass() != Object[].class) {
            this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
        }
    }

    public FastArrayList(Enumeration<E> enumeration) {
        this.elementData = EMPTY_ELEMENTDATA;
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
        }
    }

    @Override
    public int hashCode() {
        if (!this.hashCodeUpToDate) {
            this.hashCode = super.hashCode();
            this.hashCodeUpToDate = true;
        }
        return this.hashCode;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int minExpand;
        int n = minExpand = this.elementData != EMPTY_ELEMENTDATA ? 0 : 10;
        if (minCapacity > minExpand) {
            this.ensureExplicitCapacity(minCapacity);
        }
    }

    private void ensureCapacityInternal(int minCapacity) {
        if (this.elementData == EMPTY_ELEMENTDATA) {
            minCapacity = Math.max(10, minCapacity);
        }
        this.ensureExplicitCapacity(minCapacity);
    }

    private void ensureExplicitCapacity(int minCapacity) {
        ++this.modCount;
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = FastArrayList.hugeCapacity(minCapacity);
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            FastArrayList v = (FastArrayList)super.clone();
            v.elementData = Arrays.copyOf(this.elementData, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    E elementData(int index) {
        return (E)this.elementData[index];
    }

    @Override
    public E get(int index) {
        return (E)this.elementData[index];
    }

    @Override
    public E set(int index, E element) {
        this.hashCodeUpToDate = false;
        E oldValue = this.elementData(index);
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public boolean add(E e) {
        this.hashCodeUpToDate = false;
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.hashCodeUpToDate = false;
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.hashCodeUpToDate = false;
        ++this.modCount;
        E oldValue = this.elementData(index);
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        this.hashCodeUpToDate = false;
        if (o == null) {
            for (int index = 0; index < this.size; ++index) {
                if (this.elementData[index] != null) continue;
                this.fastRemove(index);
                return true;
            }
        } else {
            for (int index = 0; index < this.size; ++index) {
                if (!o.equals(this.elementData[index])) continue;
                this.fastRemove(index);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        this.hashCodeUpToDate = false;
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.hashCodeUpToDate = false;
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.hashCodeUpToDate = false;
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int newSize;
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        for (int i = newSize = this.size - (toIndex - fromIndex); i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = newSize;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.hashCodeUpToDate = false;
        return this.batchRemove(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.hashCodeUpToDate = false;
        return this.batchRemove(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> c, boolean complement) {
        boolean modified;
        int w;
        block8: {
            int r;
            Object[] elementData = this.elementData;
            w = 0;
            modified = false;
            try {
                for (r = 0; r < this.size; ++r) {
                    if (c.contains(elementData[r]) != complement) continue;
                    elementData[w++] = elementData[r];
                }
                Object var8_7 = null;
                if (r == this.size) break block8;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (r != this.size) {
                    System.arraycopy(elementData, r, elementData, w, this.size - r);
                    w += this.size - r;
                }
                if (w != this.size) {
                    for (int i = w; i < this.size; ++i) {
                        elementData[i] = null;
                    }
                    this.modCount += this.size - w;
                    this.size = w;
                    modified = true;
                }
                throw throwable;
            }
            System.arraycopy(elementData, r, elementData, w, this.size - r);
            w += this.size - r;
        }
        if (w != this.size) {
            for (int i = w; i < this.size; ++i) {
                elementData[i] = null;
            }
            this.modCount += this.size - w;
            this.size = w;
            modified = true;
        }
        return modified;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.modCount;
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.elementData = EMPTY_ELEMENTDATA;
        s.defaultReadObject();
        s.readInt();
        if (this.size > 0) {
            this.ensureCapacityInternal(this.size);
            Object[] a = this.elementData;
            for (int i = 0; i < this.size; ++i) {
                a[i] = s.readObject();
            }
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        FastArrayList.subListRangeCheck(fromIndex, toIndex, this.size);
        return new SubList(this, 0, fromIndex, toIndex);
    }

    static void subListRangeCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubList
    extends java.util.AbstractList<E>
    implements RandomAccess {
        private final FastArrayList<E> parent;
        private final int parentOffset;
        private final int offset;
        int size;

        SubList(FastArrayList<E> parent, int offset, int fromIndex, int toIndex) {
            this.parent = parent;
            this.parentOffset = fromIndex;
            this.offset = offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = FastArrayList.this.modCount;
        }

        @Override
        public E set(int index, E e) {
            Object oldValue = FastArrayList.this.elementData(this.offset + index);
            ((FastArrayList)FastArrayList.this).elementData[this.offset + index] = e;
            return oldValue;
        }

        @Override
        public E get(int index) {
            return FastArrayList.this.elementData(this.offset + index);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void add(int index, E e) {
            this.parent.add(this.parentOffset + index, e);
            this.modCount = this.parent.modCount;
            ++this.size;
        }

        @Override
        public E remove(int index) {
            Object result = this.parent.remove(this.parentOffset + index);
            this.modCount = this.parent.modCount;
            --this.size;
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.parent.removeRange(this.parentOffset + fromIndex, this.parentOffset + toIndex);
            this.modCount = this.parent.modCount;
            this.size -= toIndex - fromIndex;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.parent.addAll(this.parentOffset + index, c);
            this.modCount = this.parent.modCount;
            this.size += cSize;
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            final int offset = this.offset;
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != SubList.this.size;
                }

                @Override
                public E next() {
                    int i = this.cursor;
                    if (i >= SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = FastArrayList.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = FastArrayList.this.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    try {
                        SubList.this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    try {
                        FastArrayList.this.set(offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(E e) {
                    try {
                        int i = this.cursor;
                        SubList.this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object[] elementData = FastArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                FastArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            try {
                int i = this.cursor;
                FastArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != FastArrayList.this.size;
        }

        @Override
        public E next() {
            int i = this.cursor;
            if (i >= FastArrayList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] elementData = FastArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                FastArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

