/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.colt;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import cern.colt.matrix.linalg.LUDecomposition;
import cern.colt.matrix.linalg.QRDecomposition;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.jet.math.Functions;
import java.util.HashSet;
import java.util.Iterator;
import org.ujmp.colt.ColtDenseDoubleMatrix2D;
import org.ujmp.colt.ColtSparseDoubleMatrix2DFactory;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.CoordinateSetToLongWrapper;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColtSparseDoubleMatrix2D
extends AbstractSparseDoubleMatrix2D
implements Wrapper<SparseDoubleMatrix2D> {
    private static final long serialVersionUID = -3223474248020842822L;
    public static final ColtSparseDoubleMatrix2DFactory Factory = new ColtSparseDoubleMatrix2DFactory();
    private final SparseDoubleMatrix2D matrix;

    public ColtSparseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = new SparseDoubleMatrix2D(rows, columns);
    }

    public ColtSparseDoubleMatrix2D(SparseDoubleMatrix2D m) {
        super((long)m.rows(), (long)m.columns());
        this.matrix = m;
    }

    public ColtSparseDoubleMatrix2D(Matrix source) {
        super(source.getRowCount(), source.getColumnCount());
        this.matrix = new SparseDoubleMatrix2D((int)source.getRowCount(), (int)source.getColumnCount());
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
        if (source.getMetaData() != null) {
            this.setMetaData(source.getMetaData().clone());
        }
    }

    @Override
    public final void clear() {
        this.matrix.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int arg0, int arg1, double arg2) {
                return 0.0;
            }
        });
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getQuick(MathUtil.longToInt(row), MathUtil.longToInt(column));
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getQuick(row, column);
    }

    @Override
    public synchronized void setDouble(double value, long row, long column) {
        this.matrix.setQuick(MathUtil.longToInt(row), MathUtil.longToInt(column), value);
    }

    @Override
    public synchronized void setDouble(double value, int row, int column) {
        this.matrix.setQuick(row, column, value);
    }

    @Override
    public SparseDoubleMatrix2D getWrappedObject() {
        return this.matrix;
    }

    @Override
    public Matrix inv() {
        return new ColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)new Algebra().inverse((DoubleMatrix2D)this.matrix));
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new AvailableCoordinateIterable();
    }

    @Override
    public final boolean containsCoordinates(long ... coordinates) {
        return this.getAsDouble(coordinates) != 0.0;
    }

    @Override
    public Matrix transpose() {
        return new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.viewDice().copy());
    }

    @Override
    public Matrix plus(double value) {
        ColtSparseDoubleMatrix2D result = new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.copy().assign(Functions.plus((double)value)));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix[] qr() {
        if (this.getColumnCount() > this.getRowCount()) {
            throw new RuntimeException("matrix size must be m>=n");
        }
        QRDecomposition qr = new QRDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D q = new ColtDenseDoubleMatrix2D(qr.getQ());
        ColtDenseDoubleMatrix2D r = new ColtDenseDoubleMatrix2D(qr.getR());
        return new Matrix[]{q, r};
    }

    @Override
    public Matrix[] svd() {
        if (this.getColumnCount() > this.getRowCount()) {
            SingularValueDecomposition svd = new SingularValueDecomposition(this.matrix.viewDice());
            ColtDenseDoubleMatrix2D u = new ColtDenseDoubleMatrix2D(svd.getV());
            ColtDenseDoubleMatrix2D s = new ColtDenseDoubleMatrix2D(svd.getS());
            ColtDenseDoubleMatrix2D v = new ColtDenseDoubleMatrix2D(svd.getU());
            return new Matrix[]{u, s, v};
        }
        SingularValueDecomposition svd = new SingularValueDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D u = new ColtDenseDoubleMatrix2D(svd.getU());
        ColtDenseDoubleMatrix2D s = new ColtDenseDoubleMatrix2D(svd.getS());
        ColtDenseDoubleMatrix2D v = new ColtDenseDoubleMatrix2D(svd.getV());
        return new Matrix[]{u, s, v};
    }

    @Override
    public Matrix times(double value) {
        ColtSparseDoubleMatrix2D result = new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.copy().assign(Functions.mult((double)value)));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    public Matrix copy() {
        ColtSparseDoubleMatrix2D m = new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.copy());
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public Matrix chol() {
        CholeskyDecomposition chol = new CholeskyDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D r = new ColtDenseDoubleMatrix2D(chol.getL());
        return r;
    }

    @Override
    public Matrix divide(double value) {
        ColtSparseDoubleMatrix2D result = new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.copy().assign(Functions.div((double)value)));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix minus(double value) {
        ColtSparseDoubleMatrix2D result = new ColtSparseDoubleMatrix2D((SparseDoubleMatrix2D)this.matrix.copy().assign(Functions.minus((double)value)));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix solve(Matrix b) {
        if (b instanceof ColtDenseDoubleMatrix2D) {
            ColtDenseDoubleMatrix2D b2 = (ColtDenseDoubleMatrix2D)b;
            if (this.isSquare()) {
                DoubleMatrix2D ret = new LUDecomposition((DoubleMatrix2D)this.matrix).solve((DoubleMatrix2D)b2.getWrappedObject());
                return new ColtDenseDoubleMatrix2D(ret);
            }
            DoubleMatrix2D ret = new QRDecomposition((DoubleMatrix2D)this.matrix).solve((DoubleMatrix2D)b2.getWrappedObject());
            return new ColtDenseDoubleMatrix2D(ret);
        }
        return super.solve(b);
    }

    @Override
    public Matrix solveSPD(Matrix b) {
        if (b instanceof ColtDenseDoubleMatrix2D) {
            ColtDenseDoubleMatrix2D b2 = (ColtDenseDoubleMatrix2D)b;
            DoubleMatrix2D ret = new CholeskyDecomposition((DoubleMatrix2D)this.matrix).solve((DoubleMatrix2D)b2.getWrappedObject());
            return new ColtDenseDoubleMatrix2D(ret);
        }
        return super.solve(b);
    }

    @Override
    public Matrix invSPD() {
        DoubleMatrix2D ret = new CholeskyDecomposition((DoubleMatrix2D)this.matrix).solve(DoubleFactory2D.dense.identity(this.matrix.rows()));
        return new ColtDenseDoubleMatrix2D(ret);
    }

    @Override
    public Matrix[] eig() {
        EigenvalueDecomposition eig = new EigenvalueDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D v = new ColtDenseDoubleMatrix2D(eig.getV());
        ColtDenseDoubleMatrix2D d = new ColtDenseDoubleMatrix2D(eig.getD());
        return new Matrix[]{v, d};
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof ColtSparseDoubleMatrix2D) {
            SparseDoubleMatrix2D ret = new SparseDoubleMatrix2D((int)this.getRowCount(), (int)m.getColumnCount());
            this.matrix.zMult((DoubleMatrix2D)((ColtSparseDoubleMatrix2D)m).matrix, (DoubleMatrix2D)ret);
            return new ColtSparseDoubleMatrix2D(ret);
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix[] lu() {
        if (this.getColumnCount() > this.getRowCount()) {
            throw new RuntimeException("only supported for m>=n");
        }
        LUDecomposition lu = new LUDecomposition((DoubleMatrix2D)this.matrix);
        ColtDenseDoubleMatrix2D l = new ColtDenseDoubleMatrix2D(lu.getL());
        ColtDenseDoubleMatrix2D u = new ColtDenseDoubleMatrix2D(lu.getU().viewPart(0, 0, (int)this.getColumnCount(), (int)this.getColumnCount()));
        int[] piv = lu.getPivot();
        int m = (int)this.getRowCount();
        ColtDenseDoubleMatrix2D p = new ColtDenseDoubleMatrix2D(m, m);
        for (int i = 0; i < m; ++i) {
            p.setAsDouble(1.0, new long[]{i, piv[i]});
        }
        return new Matrix[]{l, u, p};
    }

    public ColtSparseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AvailableCoordinateIterable
    implements Iterable<long[]> {
        AvailableCoordinateIterable() {
        }

        @Override
        public Iterator<long[]> iterator() {
            HashSet<Coordinates> cset = new HashSet<Coordinates>();
            for (long r = ColtSparseDoubleMatrix2D.this.getRowCount() - 1L; r >= 0L; --r) {
                for (long c = ColtSparseDoubleMatrix2D.this.getColumnCount() - 1L; c >= 0L; --c) {
                    if (ColtSparseDoubleMatrix2D.this.getDouble(r, c) == 0.0) continue;
                    cset.add(Coordinates.wrap(r, c).clone());
                }
            }
            return new CoordinateSetToLongWrapper(cset).iterator();
        }
    }
}

