/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.Serializable;
import java.util.Arrays;

public abstract class TObjectHash
extends THash
implements Serializable,
TObjectHashingStrategy {
    protected transient Object[] _set;
    protected TObjectHashingStrategy _hashingStrategy;
    protected static final Object REMOVED = new Object();
    protected static final Object FREE = new Object();

    public TObjectHash() {
        this._hashingStrategy = this;
    }

    public TObjectHash(TObjectHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TObjectHash(int initialCapacity, TObjectHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TObjectHash(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    public Object clone() {
        TObjectHash h = (TObjectHash)super.clone();
        h._set = (Object[])this._set.clone();
        return h;
    }

    protected int capacity() {
        return this._set.length;
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._set[index] = REMOVED;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new Object[capacity];
        Arrays.fill(this._set, FREE);
        return capacity;
    }

    public boolean forEach(TObjectProcedure procedure) {
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == FREE || set[i] == REMOVED || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    protected int index(Object obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (!(cur == FREE || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != FREE && (cur == REMOVED || !this._hashingStrategy.equals(cur, obj)));
        }
        return cur == FREE ? -1 : index;
    }

    protected int insertionIndex(Object obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == FREE) {
            return index;
        }
        if (this._hashingStrategy.equals(cur, obj)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != FREE && cur != REMOVED && !this._hashingStrategy.equals(cur, obj));
        }
        if (cur == REMOVED) {
            int firstRemoved = index;
            while (!(cur == FREE || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != FREE && cur != REMOVED ? -index - 1 : firstRemoved;
        }
        return cur != FREE && cur != REMOVED ? -index - 1 : index;
    }

    public final int computeHashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + "; object #2 =" + o2);
    }
}

