/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.util.FloatMatrix;

public class AlgorithmData
implements Serializable {
    private HashMap matrixes = new HashMap();
    private HashMap intMatrices = new HashMap();
    private HashMap intArrays = new HashMap();
    private HashMap stringArrays = new HashMap();
    private HashMap objectMatrices = new HashMap();
    private AlgorithmParameters parameters = new AlgorithmParameters();
    private HashMap clusters = new HashMap();

    public void addMatrix(String string, FloatMatrix floatMatrix) {
        this.matrixes.put(string, floatMatrix);
    }

    public void addIntMatrix(String string, int[][] nArray) {
        this.intMatrices.put(string, nArray);
    }

    public void addCluster(String string, Cluster cluster) {
        this.clusters.put(string, cluster);
    }

    public Cluster getCluster(String string) {
        return (Cluster)this.clusters.get(string);
    }

    public void addParam(String string, String string2) {
        this.parameters.setProperty(string, string2);
    }

    public FloatMatrix getMatrix(String string) {
        return (FloatMatrix)this.matrixes.get(string);
    }

    public int[][] getIntMatrix(String string) {
        return (int[][])this.intMatrices.get(string);
    }

    public boolean containsMatrix(String string) {
        return this.matrixes.containsKey(string);
    }

    public void addIntArray(String string, int[] nArray) {
        this.intArrays.put(string, nArray);
    }

    public int[] getIntArray(String string) {
        return (int[])this.intArrays.get(string);
    }

    public void addStringArray(String string, String[] stringArray) {
        this.stringArrays.put(string, stringArray);
    }

    public String[] getStringArray(String string) {
        return (String[])this.stringArrays.get(string);
    }

    public void addObjectMatrix(String string, Object[][] objectArray) {
        this.objectMatrices.put(string, objectArray);
    }

    public Object[][] getObjectMatrix(String string) {
        return (Object[][])this.objectMatrices.get(string);
    }

    public int size() {
        return this.matrixes.size();
    }

    public String[] getMatrixNames() {
        return this.getKeys(this.matrixes);
    }

    public String[] getClusterNames() {
        return this.getKeys(this.clusters);
    }

    private String[] getKeys(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        String[] stringArray = new String[hashMap.size()];
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public AlgorithmParameters getParams() {
        return this.parameters;
    }

    public Map getProperties() {
        return this.parameters.getMap();
    }

    public Map getMatrixes() {
        return this.matrixes;
    }

    public Map getIntArrays() {
        return this.intArrays;
    }

    public Map getStringArrays() {
        return this.stringArrays;
    }

    public Map getObjectMatrices() {
        return this.objectMatrices;
    }

    public Map getClusters() {
        return this.clusters;
    }
}

