/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.matrix;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.ujmp.core.collections.map.SoftHashMap;
import org.ujmp.core.objectmatrix.DenseObjectMatrix2D;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;
import org.ujmp.jdbc.autoclose.AutoCloseConnection;

public abstract class AbstractDenseJDBCMatrix2D
extends AbstractDenseObjectMatrix2D
implements Closeable {
    private static final long serialVersionUID = -9077208839474846706L;
    private int chunkSize = 1000;
    private Map<Long, DenseObjectMatrix2D> dataCache = new SoftHashMap<Long, DenseObjectMatrix2D>();
    private String url = null;
    private String username = null;
    private String password = null;
    private String sqlStatement = null;
    private Connection connection = null;

    public AbstractDenseJDBCMatrix2D(String url, String sqlStatement, String username, String password) {
        super(0L, 0L);
        this.url = url;
        this.username = username;
        this.password = password;
        this.sqlStatement = sqlStatement;
    }

    public AbstractDenseJDBCMatrix2D(Connection connection, String sqlStatement) {
        super(0L, 0L);
        this.connection = connection;
        this.sqlStatement = sqlStatement;
    }

    public String getSQLStatement() {
        return this.sqlStatement;
    }

    public synchronized Object getObject(int row, int column) {
        return this.getObject((long)row, (long)column);
    }

    public synchronized Object getObject(long row, long column) {
        try {
            long chunkId = row / (long)this.chunkSize;
            DenseObjectMatrix2D m = this.dataCache.get(chunkId);
            if (m == null) {
                String sql = this.sqlStatement + " LIMIT ?,?";
                PreparedStatement ps = this.getConnection().prepareStatement(sql);
                System.out.println(row + " - " + chunkId);
                long offset = chunkId * (long)this.chunkSize;
                ps.setLong(1, offset);
                ps.setLong(2, this.chunkSize);
                ResultSet rs = ps.executeQuery();
                m = (DenseObjectMatrix2D)DenseObjectMatrix2D.Factory.zeros((long)this.chunkSize, this.getColumnCount());
                long r = 0L;
                while (rs.next()) {
                    int c = 0;
                    while ((long)c < this.getColumnCount()) {
                        block7: {
                            try {
                                m.setObject(rs.getObject(c + 1), r, (long)c);
                            }
                            catch (SQLException e) {
                                if ("S1009".equals(e.getSQLState())) break block7;
                                throw e;
                            }
                        }
                        ++c;
                    }
                    ++r;
                }
                this.dataCache.put(chunkId, m);
                rs.close();
                ps.close();
            }
            return m.getObject(row % (long)this.chunkSize, column);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final String getSelectString() {
        return this.sqlStatement;
    }

    public synchronized void setObject(Object value, long row, long column) {
    }

    public synchronized void setObject(Object value, int row, int column) {
    }

    public synchronized long[] getSize() {
        try {
            if (this.getRowCount() == 0L) {
                long rowCount = 0L;
                PreparedStatement ps = this.getConnection().prepareStatement("SELECT COUNT(1) FROM (" + this.sqlStatement + ") t");
                ResultSet rsRows = ps.executeQuery();
                if (rsRows.next()) {
                    rowCount = rsRows.getLong(1);
                }
                rsRows.close();
                ps.close();
                long columnCount = 0L;
                ps = this.getConnection().prepareStatement("SELECT * FROM (" + this.sqlStatement + ") t LIMIT 1");
                ResultSet rsCols = ps.executeQuery();
                if (rsCols.next()) {
                    columnCount = rsCols.getMetaData().getColumnCount();
                }
                if (this.getLabelObject() == null) {
                    this.setLabel(this.getUrl() + " " + this.getSelectString());
                    ResultSetMetaData rsm = rsCols.getMetaData();
                    for (int c = 0; c < rsm.getColumnCount(); ++c) {
                        this.setColumnLabel(c, rsm.getColumnLabel(c + 1));
                    }
                }
                rsCols.close();
                ps.close();
                this.size[0] = rowCount;
                this.size[1] = columnCount;
            }
            return this.size;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close() throws IOException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = new AutoCloseConnection(DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword()));
        }
        return this.connection;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

