/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ujmp.core.collections.map.AbstractMap;
import org.ujmp.core.collections.map.SoftHashMap;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedMap<K, V>
extends AbstractMap<K, V>
implements Wrapper<Map<K, V>>,
Flushable,
Closeable {
    private static final long serialVersionUID = 1383398694858918398L;
    private transient Map<K, V> source = null;
    private transient Map<K, V> cache = null;

    public CachedMap(Map<K, V> source) {
        this.setWrappedObject(source);
    }

    public CachedMap(Map<K, V> source, Map<K, V> cache) {
        this.setWrappedObject(source);
        this.cache = cache;
    }

    @Override
    public void clear() {
        this.getCache().clear();
        this.getWrappedObject().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.getCache().containsKey(key)) {
            return true;
        }
        return this.getWrappedObject().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.getCache().containsValue(value)) {
            return true;
        }
        return this.getWrappedObject().containsValue(value);
    }

    @Override
    public V get(Object key) {
        V value = this.getCache().get(key);
        if (value == null && (value = this.getWrappedObject().get(key)) != null) {
            this.getCache().put(key, value);
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        if (!this.getCache().isEmpty()) {
            return false;
        }
        return this.getWrappedObject().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.getWrappedObject().keySet();
    }

    @Override
    public V put(K key, V value) {
        this.getCache().put(key, value);
        return this.getWrappedObject().put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K k : m.keySet()) {
            this.put(k, m.get(k));
        }
    }

    @Override
    public V remove(Object key) {
        this.getCache().remove(key);
        return this.getWrappedObject().remove(key);
    }

    @Override
    public int size() {
        return this.getWrappedObject().size();
    }

    @Override
    public Map<K, V> getWrappedObject() {
        if (this.source == null) {
            this.source = new HashMap();
        }
        return this.source;
    }

    public void setWrappedObject(Map<K, V> object) {
        this.getCache().clear();
        this.source = object;
    }

    public Map<K, V> getCache() {
        if (this.cache == null) {
            this.cache = new SoftHashMap();
        }
        return this.cache;
    }

    @Override
    public void close() throws IOException {
        if (this.source instanceof Closeable) {
            ((Closeable)((Object)this.source)).close();
        }
        if (this.cache instanceof Closeable) {
            ((Closeable)((Object)this.cache)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.source instanceof Flushable) {
            ((Flushable)((Object)this.source)).flush();
        }
        if (this.cache instanceof Flushable) {
            ((Flushable)((Object)this.cache)).flush();
        }
    }
}

