/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;
import xtools.api.param.WChipChooserUI;

public class ChipOptParam
extends AbstractParam {
    private WChipChooserUI fChooser;

    public ChipOptParam(boolean reqd) {
        this("chip", "Chip platform", "Name of the chip to use - only 1 chip can be choosen", reqd);
    }

    public ChipOptParam(String name, String nameEnglish, String desc, boolean reqd) {
        super(name, nameEnglish, Chip.class, desc, null, (Object[])new Chip[0], reqd);
    }

    public Chip getChip() throws Exception {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        return VdbRuntimeResources.getChip(val.toString());
    }

    private String format(Object[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            this.log.debug("{}", vals[i].getClass());
            if (vals[i] instanceof PersistentObject) {
                String p = ParserFactory.getCache().getSourcePath(vals[i]);
                buf.append(p);
            } else {
                buf.append(vals[i].toString().trim());
            }
            if (i == vals.length - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Object[]) {
            Object[] objs = (Object[])val;
            return this.format(objs);
        }
        return this.format(new Object[]{val});
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new WChipChooserUI();
            MyPobActionListener actionListener = new MyPobActionListener();
            actionListener.setChooser(this.fChooser);
            this.fChooser.setCustomActionListener(actionListener);
            String text = this.getValueStringRepresentation(false);
            if (text == null) {
                text = this.format((Object[])this.getDefault());
            }
            this.fChooser.setText(text);
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    private static class MyPobActionListener
    implements ActionListener {
        private WChipChooserUI fChooser;

        public void setChooser(WChipChooserUI chooser) {
            this.fChooser = chooser;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fChooser == null) {
                return;
            }
            CharSequence[] selectedPaths = this.fChooser.getJListWindow().showDirectlyWithModels();
            if (selectedPaths != null && selectedPaths.length > 0) {
                this.fChooser.setText(String.join((CharSequence)",", selectedPaths));
            }
        }
    }
}

