/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions;

import edu.mit.broad.xbench.actions.XAction;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.Window;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.SwingWorker;
import javax.swing.event.InternalFrameListener;

public abstract class WidgetAction
extends XAction
implements MouseListener {
    protected boolean fOnlyDc;
    protected Dimension fExplicitSize;
    protected Window fWindow;

    protected WidgetAction(String id, String name, String description, Icon icon) {
        super(id, name, description, icon);
    }

    public abstract Widget getWidget() throws Exception;

    protected void setSize(int w, int h, boolean usedefaultifdefaultisbigger) {
        Dimension d;
        if (usedefaultifdefaultisbigger && (d = Application.getWindowManager().getExpectedWindowSize()) != null) {
            if (d.width > w) {
                w = d.width;
            }
            if (d.height > h) {
                h = d.height;
            }
        }
        this.fExplicitSize = new Dimension(w, h);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.fOnlyDc) {
            return;
        }
        this.createTask();
    }

    public void createTask() {
        SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    Widget widget = WidgetAction.this.getWidget();
                    if (widget != null) {
                        WidgetAction.this.fWindow = WidgetAction.this.fExplicitSize != null ? Application.getWindowManager().openWindow(widget, WidgetAction.this.fExplicitSize) : Application.getWindowManager().openWindow(widget);
                        if (WidgetAction.this.fWindow instanceof JInternalFrame) {
                            ((JInternalFrame)((Object)WidgetAction.this.fWindow)).setJMenuBar(widget.getJMenuBar());
                            InternalFrameListener ifl = WidgetAction.this.getInternalFrameListener();
                            if (ifl != null) {
                                ((JInternalFrame)((Object)WidgetAction.this.fWindow)).addInternalFrameListener(ifl);
                            }
                        }
                    } else {
                        WidgetAction.this.log.debug("null widget - no window opended");
                    }
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError("Trouble making widget", t);
                }
                return null;
            }
        };
        worker.execute();
    }

    protected InternalFrameListener getInternalFrameListener() {
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.fOnlyDc) {
            e.consume();
            return;
        }
        if (e.getClickCount() == 2) {
            this.fOnlyDc = false;
            this.actionPerformed(new ActionEvent(e.getSource(), e.getID(), WidgetAction.getActionId(this), e.getModifiers()));
            this.fOnlyDc = true;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

