/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserWorker
extends SwingWorker<Object, Void> {
    private static final Logger klog = LoggerFactory.getLogger(ParserWorker.class);
    private File[] files;

    public ParserWorker(File[] files) {
        this.files = files;
    }

    @Override
    protected Object doInBackground() throws Exception {
        StringBuilder buf_s = new StringBuilder("<html>Loading ... " + this.files.length + " files<br><br>");
        int sucess = 0;
        Errors errors = new Errors();
        boolean hadWarnings = false;
        for (int f = 0; f < this.files.length; ++f) {
            if (this.files[f].isDirectory()) {
                errors.add(new RuntimeException("Only files can be choosen - a directory was specified: " + this.files[f].getPath()));
                continue;
            }
            try {
                FileInputStream in = new FileInputStream(this.files[f]);
                ProgressMonitorInputStream pis = new ProgressMonitorInputStream(Application.getWindowManager().getRootFrame(), "Loading file " + this.files[f].getName(), in);
                PersistentObject pob = ParserFactory.read(this.files[f].getPath(), pis);
                if (pob == null || pis.getProgressMonitor().isCanceled()) {
                    throw new RuntimeException("Loading of file '" + this.files[f].getName() + "' canceled.");
                }
                klog.info("Loaded file: {}", (Object)this.files[f].getPath());
                if (!pob.getWarnings().isEmpty()) {
                    hadWarnings = true;
                }
                Application.getFileManager().registerRecentlyOpenedFile(this.files[f]);
                buf_s.append(this.files[f].getName()).append("\n");
                ++sucess;
                continue;
            }
            catch (Throwable t) {
                errors.add("Parsing trouble", t);
            }
        }
        buf_s.append("<br>Files loaded successfully: ").append(sucess).append(" / ").append(this.files.length).append("<br>");
        if (errors.isEmpty()) {
            buf_s.append("There were NO errors");
            if (hadWarnings) {
                buf_s.append("<br><br><b>There were warnings. See the [+] console log for details.</b>");
            }
            buf_s.append("</html>");
            Application.getWindowManager().showMessage(buf_s.toString());
        } else {
            Application.getWindowManager().showError(errors);
        }
        return null;
    }
}

