/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.strucs;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.vdb.chip.Chip;
import java.util.Map;

public class CollapsedDetails {
    public PersistentObject orig;
    public PersistentObject collapsed;
    public boolean wasCollapsed;
    public Chip chip;

    public String getChipName() {
        if (this.chip != null) {
            return this.chip.getName();
        }
        return "NA";
    }

    public int getNumRow_orig() {
        if (this.orig instanceof Dataset) {
            return ((Dataset)this.orig).getNumRow();
        }
        return ((RankedList)this.orig).getSize();
    }

    public int getNumRow_collapsed() {
        if (this.collapsed instanceof Dataset) {
            return ((Dataset)this.collapsed).getNumRow();
        }
        return ((RankedList)this.collapsed).getSize();
    }

    public static class Ranked
    extends CollapsedDetails {
        public Map<String, DatasetGenerators.CollapseStruc> collapseStrucMap;

        public RankedList getRankedList() {
            if (this.wasCollapsed) {
                return (RankedList)this.collapsed;
            }
            return (RankedList)this.orig;
        }
    }

    public static class Data
    extends CollapsedDetails {
        public Dataset getDataset() {
            if (this.wasCollapsed) {
                return (Dataset)this.collapsed;
            }
            return (Dataset)this.orig;
        }
    }
}

