/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.io;

import edu.mit.broad.genome.io.PobFlavor;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PobTransferable
implements Transferable,
ClipboardOwner {
    private final List fPobs;
    private final List fFiles;
    private final String fPaths;

    public PobTransferable(PersistentObject[] pobs) {
        if (pobs != null) {
            this.fPobs = new ArrayList(pobs.length);
            this.fFiles = new ArrayList(pobs.length);
            for (int i = 0; i < pobs.length; ++i) {
                this.fPobs.add(pobs[i]);
                File file = ParserFactory.getCache().getSourceFile(pobs[i]);
                this.fFiles.add(file);
            }
            this.fPaths = this.toPathString();
        } else {
            this.fPobs = new ArrayList();
            this.fFiles = new ArrayList();
            this.fPaths = "";
        }
    }

    public PobTransferable(Object[] objs) {
        if (objs != null) {
            this.fPobs = new ArrayList();
            this.fFiles = new ArrayList();
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] instanceof File) {
                    this.fFiles.add(objs[i]);
                    continue;
                }
                if (!(objs[i] instanceof PersistentObject)) continue;
                PersistentObject pob = (PersistentObject)objs[i];
                this.fPobs.add(pob);
                File file = ParserFactory.getCache().getSourceFile(pob);
                this.fFiles.add(file);
            }
            this.fPaths = this.toPathString();
        } else {
            this.fPobs = new ArrayList();
            this.fFiles = new ArrayList();
            this.fPaths = "";
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        if (flavor.equals(PobFlavor.pobListFlavor)) {
            return this.fPobs;
        }
        if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            return this.fFiles;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.fPaths;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor, PobFlavor.pobListFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.javaFileListFlavor) || flavor.equals(DataFlavor.stringFlavor) || flavor.equals(PobFlavor.pobListFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private String toPathString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.fFiles.size(); ++i) {
            File file = (File)this.fFiles.get(i);
            buf.append(file.getAbsolutePath()).append('\n');
        }
        return buf.toString();
    }
}

