/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.poi;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.ujmp.core.objectmatrix.DenseObjectMatrix2D;
import org.ujmp.core.objectmatrix.impl.DefaultDenseObjectMatrix2D;

public abstract class AbstractMatrixExcelImporter {
    public DenseObjectMatrix2D importFromSheet(Sheet sheet) throws InvalidFormatException, IOException {
        int rowCount = sheet.getLastRowNum();
        int columnCount = 0;
        Iterator rowIterator = sheet.rowIterator();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (row.getLastCellNum() <= columnCount) continue;
            columnCount = row.getLastCellNum();
        }
        DefaultDenseObjectMatrix2D matrix = new DefaultDenseObjectMatrix2D(rowCount, columnCount);
        matrix.setLabel(sheet.getSheetName());
        for (int r = 0; r < rowCount; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            block10: for (int c = 0; c < columnCount; ++c) {
                Cell cell = row.getCell(c);
                if (cell == null) continue;
                switch (cell.getCellType()) {
                    case 3: {
                        continue block10;
                    }
                    case 4: {
                        matrix.setAsBoolean(cell.getBooleanCellValue(), r, c);
                        continue block10;
                    }
                    case 5: {
                        continue block10;
                    }
                    case 2: {
                        matrix.setAsString(cell.getCellFormula(), r, c);
                        continue block10;
                    }
                    case 0: {
                        matrix.setAsDouble(cell.getNumericCellValue(), r, c);
                        continue block10;
                    }
                    case 1: {
                        matrix.setAsString(cell.getStringCellValue(), r, c);
                        continue block10;
                    }
                }
            }
        }
        return matrix;
    }

    public DenseObjectMatrix2D importFromWorkbook(Workbook workbook, int sheetNumber) throws InvalidFormatException, IOException {
        Sheet sheet = workbook.getSheetAt(sheetNumber);
        return this.importFromSheet(sheet);
    }
}

