/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLUtil {
    public static final String URL = "URL";
    public static final String TABLENAME = "TableName";
    public static final String DATABASENAME = "DatabaseName";
    public static final String KEYCOLUMNNAME = "KeyColumnName";
    public static final String VALUECOLUMNNAME = "ValueColumnName";
    public static final String KEYCLASS = "KeyClass";
    public static final String VALUECLASS = "ValueClass";
    public static final String SQLDIALECT = "SQLDialect";
    public static final Properties DEFAULTPROPERTIES = new Properties();
    public static final Properties MYSQLPROPERTIES = new Properties();
    public static final Properties DERBYPROPERTIES = new Properties();
    public static final String MYSQLDEFAULTCHARSET = "utf8";
    protected final int maxKeyLength = 1024;

    public static SQLDialect getSQLDialect(String url) {
        if (url.startsWith("jdbc:mysql:")) {
            return SQLDialect.MYSQL;
        }
        if (url.startsWith("jdbc:hsqldb:")) {
            return SQLDialect.HSQLDB;
        }
        if (url.startsWith("jdbc:postgresql:")) {
            return SQLDialect.POSTGRESQL;
        }
        if (url.startsWith("jdbc:oracle:")) {
            return SQLDialect.ORACLE;
        }
        if (url.startsWith("jdbc:sqlserver:")) {
            return SQLDialect.MSSQL;
        }
        if (url.startsWith("jdbc:derby:")) {
            return SQLDialect.DERBY;
        }
        if (url.startsWith("jdbc:hive:")) {
            return SQLDialect.HIVE;
        }
        if (url.startsWith("jdbc:db2:")) {
            return SQLDialect.DB2;
        }
        if (url.startsWith("jdbc:sqlite:")) {
            return SQLDialect.SQLITE;
        }
        if (url.startsWith("jdbc:h2:")) {
            return SQLDialect.H2;
        }
        throw new IllegalArgumentException("SQL dialect unknown for URL: " + url);
    }

    public static void loadDriver(String url) {
        try {
            switch (SQLUtil.getSQLDialect(url)) {
                case SQLITE: {
                    Class.forName("org.sqlite.JDBC");
                    break;
                }
                case H2: {
                    Class.forName("org.h2.Driver");
                    break;
                }
                case HSQLDB: {
                    Class.forName("org.hsqldb.jdbc.JDBCDriver");
                    break;
                }
                case MYSQL: {
                    Class.forName("com.mysql.jdbc.Driver");
                    break;
                }
                case DERBY: {
                    Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                    break;
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("JDBC driver not found", e);
        }
    }

    public static Properties createProperties(String url, String username, String password) {
        Properties properties = new Properties();
        if (username != null) {
            properties.put("user", username);
        }
        if (password != null) {
            properties.put("password", password);
        }
        properties.putAll((Map<?, ?>)DEFAULTPROPERTIES);
        switch (SQLUtil.getSQLDialect(url)) {
            case MYSQL: {
                properties.putAll((Map<?, ?>)MYSQLPROPERTIES);
                break;
            }
            case DERBY: {
                properties.putAll((Map<?, ?>)DERBYPROPERTIES);
                break;
            }
        }
        return properties;
    }

    public static String getDropTableSQL(SQLDialect sqlDialect, String tableName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "DROP TABLE `" + tableName + "`";
            }
        }
        return "DROP TABLE \"" + tableName + "\"";
    }

    public static PreparedStatement getDropTableStatement(Connection connection, SQLDialect sqlDialect, String tableName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getDropTableSQL(sqlDialect, tableName));
    }

    public static PreparedStatement getTruncateTableStatement(Connection connection, SQLDialect sqlDialect, String tableName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getTruncateTableSQL(sqlDialect, tableName));
    }

    public static String getTruncateTableSQL(SQLDialect sqlDialect, String tableName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "TRUNCATE TABLE `" + tableName + "`";
            }
            case SQLITE: {
                return "DELETE FROM \"" + tableName + "\"";
            }
        }
        return "TRUNCATE TABLE \"" + tableName + "\"";
    }

    public static PreparedStatement getCountStatement(Connection connection, SQLDialect sqlDialect, String tableName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getCountSQL(sqlDialect, tableName));
    }

    public static String getCountSQL(SQLDialect sqlDialect, String tableName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "SELECT COUNT(1) FROM `" + tableName + "`";
            }
        }
        return "SELECT COUNT(1) FROM \"" + tableName + "\"";
    }

    public static PreparedStatement getDeleteIdStatement(Connection connection, SQLDialect sqlDialect, String tableName, String keyColumnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getDeleteIdSQL(sqlDialect, tableName, keyColumnName));
    }

    public static String getDeleteIdSQL(SQLDialect sqlDialect, String tableName, String keyColumnName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "DELETE FROM `" + tableName + "` WHERE `" + keyColumnName + "` = ?";
            }
        }
        return "DELETE FROM \"" + tableName + "\" WHERE \"" + keyColumnName + "\" = ?";
    }

    public static PreparedStatement getSelectIdsStatement(Connection connection, SQLDialect sqlDialect, String tableName, String keyColumnName) throws SQLException {
        PreparedStatement ps = connection.prepareStatement(SQLUtil.getSelectIdsSQL(sqlDialect, tableName, keyColumnName), 1003, 1007);
        ps.setFetchSize(100);
        return ps;
    }

    public static String getSelectIdsSQL(SQLDialect sqlDialect, String tableName, String keyColumnName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "SELECT `" + keyColumnName + "` FROM `" + tableName + "`";
            }
        }
        return "SELECT \"" + keyColumnName + "\" FROM \"" + tableName + "\"";
    }

    public static PreparedStatement getInsertKeyValueStatement(Connection connection, SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getInsertKeyValueSQL(sqlDialect, tableName, keyColumnName, valueColumnName));
    }

    public static String getInsertKeyValueSQL(SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "INSERT INTO `" + tableName + "` (`" + keyColumnName + "`, `" + valueColumnName + "`) VALUES (?,?)";
            }
        }
        return "INSERT INTO \"" + tableName + "\" (\"" + keyColumnName + "\", \"" + valueColumnName + "\") VALUES (?,?)";
    }

    public static PreparedStatement getInsertIdStatement(Connection connection, SQLDialect sqlDialect, String tableName, String columnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getInsertIdSQL(sqlDialect, tableName, columnName));
    }

    public static String getInsertIdSQL(SQLDialect sqlDialect, String tableName, String columnName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "INSERT INTO `" + tableName + "` (`" + columnName + "`) VALUES (?)";
            }
        }
        return "INSERT INTO \"" + tableName + "\" (\"" + columnName + "\") VALUES (?)";
    }

    public static PreparedStatement getUpdateKeyValueStatement(Connection connection, SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getUpdateKeyValueSQL(sqlDialect, tableName, keyColumnName, valueColumnName));
    }

    public static String getUpdateKeyValueSQL(SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "UPDATE `" + tableName + "` SET `" + valueColumnName + "` = ? WHERE `" + keyColumnName + "` = ?";
            }
        }
        return "UPDATE \"" + tableName + "\" SET \"" + valueColumnName + "\" = ? WHERE \"" + keyColumnName + "\" = ?";
    }

    public static PreparedStatement getValueForKeyStatement(Connection connection, SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getValueForKeySQL(sqlDialect, tableName, keyColumnName, valueColumnName));
    }

    public static String getValueForKeySQL(SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "SELECT `" + valueColumnName + "` FROM `" + tableName + "` WHERE `" + keyColumnName + "` = ? LIMIT 1";
            }
            case DERBY: {
                return "SELECT \"" + valueColumnName + "\" FROM \"" + tableName + "\" WHERE \"" + keyColumnName + "\" = ?";
            }
            case H2: {
                return "SELECT \"" + valueColumnName + "\" FROM \"" + tableName + "\" WHERE \"" + keyColumnName + "\" = ? LIMIT 1";
            }
        }
        return "SELECT \"" + valueColumnName + "\" FROM \"" + tableName + "\" WHERE \"" + keyColumnName + "\" = ? LIMIT 1";
    }

    public static PreparedStatement getExistsStatement(Connection connection, SQLDialect sqlDialect, String tableName, String valueColumnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getExistsSQL(sqlDialect, tableName, valueColumnName));
    }

    public static String getExistsSQL(SQLDialect sqlDialect, String tableName, String columnName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "SELECT EXISTS(SELECT 1 FROM `" + tableName + "` WHERE `" + columnName + "` = ? LIMIT 1)";
            }
            case DERBY: {
                return "SELECT COUNT(1)>0 FROM \"" + tableName + "\" WHERE CAST(\"" + columnName + "\" AS VARCHAR(128)) = CAST(? AS VARCHAR(128))";
            }
            case HSQLDB: {
                return "SELECT COUNT(1) FROM (SELECT 1 FROM \"" + tableName + "\" WHERE \"" + columnName + "\" = ? LIMIT 1)";
            }
        }
        return "SELECT EXISTS(SELECT 1 FROM \"" + tableName + "\" WHERE \"" + columnName + "\" = ? LIMIT 1)";
    }

    public static String getDatabaseName(String url) {
        String[] fields = url.split("/");
        fields = fields[fields.length - 1].split("\\?");
        return fields[0];
    }

    public static boolean tableExists(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet tables = dbm.getTables(null, null, tableName, null);
        boolean exists = false;
        if (tables.next()) {
            exists = true;
        }
        tables.close();
        return exists;
    }

    public static PreparedStatement getCreateKeyValueStringTableStatement(Connection connection, SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getCreateKeyValueStringTableSQL(sqlDialect, tableName, keyColumnName, valueColumnName));
    }

    public static PreparedStatement getCreateKeyValueByteTableStatement(Connection connection, SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getCreateKeyValueByteTableSQL(sqlDialect, tableName, keyColumnName, valueColumnName));
    }

    public static String getCreateKeyValueStringTableSQL(SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) {
        StringBuilder sql = new StringBuilder();
        switch (sqlDialect) {
            case MYSQL: {
                sql.append("CREATE TABLE `" + tableName + "`");
                sql.append(" (");
                sql.append("`" + keyColumnName + "` VARCHAR(1024) ");
                sql.append("COLLATE utf8_bin NOT NULL, ");
                sql.append("`" + valueColumnName + "` LONGTEXT ");
                sql.append("COLLATE utf8_bin NOT NULL, ");
                sql.append("PRIMARY KEY (`" + keyColumnName + "`(190))");
                sql.append(") ");
                sql.append("DEFAULT CHARSET=utf8 COLLATE=utf8_bin ROW_FORMAT=compressed");
                break;
            }
            case HSQLDB: {
                sql.append("CREATE TABLE \"" + tableName + "\"");
                sql.append(" (");
                sql.append("\"" + keyColumnName + "\" VARCHAR(255) PRIMARY KEY, ");
                sql.append("\"" + valueColumnName + "\" LONGVARCHAR ");
                sql.append(") ");
                break;
            }
            case DERBY: {
                sql.append("CREATE TABLE \"" + tableName + "\"");
                sql.append(" (");
                sql.append("\"" + keyColumnName + "\" VARCHAR(255) PRIMARY KEY, ");
                sql.append("\"" + valueColumnName + "\" LONG VARCHAR ");
                sql.append(") ");
                break;
            }
            case H2: {
                sql.append("CREATE TABLE \"" + tableName + "\"");
                sql.append(" (");
                sql.append("\"" + keyColumnName + "\" VARCHAR(255) PRIMARY KEY, ");
                sql.append("\"" + valueColumnName + "\" VARCHAR(1024) ");
                sql.append(") ");
                break;
            }
            default: {
                sql.append("CREATE TABLE \"" + tableName + "\"");
                sql.append(" (");
                sql.append("\"" + keyColumnName + "\" VARCHAR(255) PRIMARY KEY, ");
                sql.append("\"" + valueColumnName + "\" TEXT ");
                sql.append(") ");
            }
        }
        return sql.toString();
    }

    public static String getColumnTypeSQL(SQLDialect sqlDialect, Class<?> columnClass, boolean isKeyColumn) {
        switch (sqlDialect) {
            case MYSQL: {
                if (columnClass == String.class) {
                    return isKeyColumn ? "VARCHAR(1024) COLLATE utf8_bin NOT NULL" : "LONGTEXT COLLATE utf8_bin NOT NULL";
                }
                if (columnClass == Integer.class) {
                    return isKeyColumn ? "INT NOT NULL" : "INT";
                }
                if (columnClass == Long.class) {
                    return isKeyColumn ? "LONGINT NOT NULL" : "LONGINT";
                }
                if (columnClass == Float.class) {
                    return isKeyColumn ? "FLOAT NOT NULL" : "FLOAT";
                }
                if (columnClass == Double.class) {
                    return isKeyColumn ? "DOUBLE NOT NULL" : "DOUBLE";
                }
                return isKeyColumn ? "VARBINARY(1024) NOT NULL" : "LONGBLOB";
            }
        }
        if (columnClass == String.class) {
            return isKeyColumn ? "VARCHAR(255) NOT NULL" : "TEXT";
        }
        return isKeyColumn ? "VARBINARY(255) NOT NULL" : "TEXT";
    }

    public static String getCreateKeyValueTableSQL(SQLDialect sqlDialect, String tableName, String keyColumnName, Class<?> keyClass, String valueColumnName, Class<?> valueClass) {
        StringBuilder sql = new StringBuilder();
        switch (sqlDialect) {
            case MYSQL: {
                sql.append("CREATE TABLE `" + tableName + "` (");
                sql.append("`" + keyColumnName + "` " + SQLUtil.getColumnTypeSQL(sqlDialect, keyClass, true) + ", ");
                sql.append("`" + valueColumnName + "` " + SQLUtil.getColumnTypeSQL(sqlDialect, valueClass, false) + ", ");
                sql.append("PRIMARY KEY (`" + keyColumnName + "`(190))");
                sql.append(") DEFAULT CHARSET=utf8 COLLATE=utf8_bin ROW_FORMAT=compressed");
                break;
            }
            case HSQLDB: {
                sql.append("CREATE TABLE \"" + tableName + "\" (");
                sql.append("\"" + keyColumnName + "\" VARCHAR(255) PRIMARY KEY, ");
                sql.append("\"" + valueColumnName + "\" LONGVARCHAR ");
                sql.append(") ");
                break;
            }
            case DERBY: {
                sql.append("CREATE TABLE \"" + tableName + "\" (");
                sql.append("\"" + keyColumnName + "\" VARCHAR(255) PRIMARY KEY, ");
                sql.append("\"" + valueColumnName + "\" LONG VARCHAR ");
                sql.append(") ");
                break;
            }
            default: {
                sql.append("CREATE TABLE \"" + tableName + "\" (");
                sql.append("\"" + keyColumnName + "\" VARCHAR(255) PRIMARY KEY, ");
                sql.append("\"" + valueColumnName + "\" TEXT ");
                sql.append(") ");
            }
        }
        return sql.toString();
    }

    public static String getCreateKeyValueByteTableSQL(SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) {
        StringBuilder sql = new StringBuilder();
        switch (sqlDialect) {
            case MYSQL: {
                sql.append("CREATE TABLE `" + tableName + "`");
                sql.append(" (");
                sql.append("`" + keyColumnName + "` VARCHAR(1024) ");
                sql.append("COLLATE utf8_bin NOT NULL, ");
                sql.append("`" + valueColumnName + "` LONGBLOB ");
                sql.append("NOT NULL, ");
                sql.append("PRIMARY KEY (`" + keyColumnName + "`(190))");
                sql.append(") ");
                sql.append("DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
                break;
            }
            case HSQLDB: {
                sql.append("CREATE TABLE \"" + tableName + "\"");
                sql.append(" (");
                sql.append("\"" + keyColumnName + "\" VARCHAR(255) PRIMARY KEY, ");
                sql.append("\"" + valueColumnName + "\" LONGVARBINARY ");
                sql.append(") ");
                break;
            }
            default: {
                sql.append("CREATE TABLE \"" + tableName + "\"");
                sql.append(" (");
                sql.append("\"" + keyColumnName + "\" VARCHAR(255) PRIMARY KEY, ");
                sql.append("\"" + valueColumnName + "\" TEXT ");
                sql.append(") ");
            }
        }
        return sql.toString();
    }

    public static void createKeyValueStringTable(Connection connection, SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        PreparedStatement statement = SQLUtil.getCreateKeyValueStringTableStatement(connection, sqlDialect, tableName, keyColumnName, valueColumnName);
        statement.execute();
        statement.close();
    }

    public static void createKeyValueByteTable(Connection connection, SQLDialect sqlDialect, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        PreparedStatement statement = SQLUtil.getCreateKeyValueByteTableStatement(connection, sqlDialect, tableName, keyColumnName, valueColumnName);
        statement.execute();
        statement.close();
    }

    public static List<String> getColumnNames(Connection connection, String tableName) throws SQLException {
        LinkedList<String> columnNames = new LinkedList<String>();
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet rs = dbm.getColumns(null, null, tableName, null);
        while (rs.next()) {
            String keyColumnName = rs.getString("COLUMN_NAME");
            columnNames.add(keyColumnName);
        }
        rs.close();
        return columnNames;
    }

    public static PreparedStatement getSelectAllLimit1Statement(Connection connection, SQLDialect sqlDialect, String tableName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getSelectAllLimit1SQL(sqlDialect, tableName));
    }

    public static String getSelectAllLimit1SQL(SQLDialect sqlDialect, String tableName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "SELECT * FROM `" + tableName + "` LIMIT 1";
            }
        }
        return "SELECT * FROM \"" + tableName + "\" LIMIT 1";
    }

    public static List<String> getPrimaryKeyColumnNames(Connection connection, String tableName) throws SQLException {
        LinkedList<String> primaryKeyColumnNames = new LinkedList<String>();
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet rs = dbm.getPrimaryKeys(null, null, tableName);
        while (rs.next()) {
            String keyColumnName = rs.getString("COLUMN_NAME");
            primaryKeyColumnNames.add(keyColumnName);
        }
        rs.close();
        return primaryKeyColumnNames;
    }

    public static void createKeyStringTable(Connection connection, SQLDialect sqlDialect, String tableName, String columnName) throws SQLException {
        PreparedStatement statement = SQLUtil.getCreateKeyStringTableStatement(connection, sqlDialect, tableName, columnName);
        statement.execute();
        statement.close();
    }

    public static PreparedStatement getCreateKeyStringTableStatement(Connection connection, SQLDialect sqlDialect, String tableName, String columnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getCreateKeyStringTableSQL(sqlDialect, tableName, columnName));
    }

    public static String getCreateKeyStringTableSQL(SQLDialect sqlDialect, String tableName, String columnName) {
        StringBuilder sql = new StringBuilder();
        switch (sqlDialect) {
            case MYSQL: {
                sql.append("CREATE TABLE `" + tableName + "`");
                sql.append(" (");
                sql.append("`" + columnName + "` VARCHAR(255) ");
                sql.append("COLLATE utf8_bin NOT NULL, ");
                sql.append("PRIMARY KEY (`" + columnName + "`)");
                sql.append(") ");
                sql.append("DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
                break;
            }
            default: {
                sql.append("CREATE TABLE \"" + tableName + "\"");
                sql.append(" (");
                sql.append("\"" + columnName + "\" VARCHAR(255) PRIMARY KEY ");
                sql.append(") ");
            }
        }
        return sql.toString();
    }

    public static PreparedStatement getSelectIdStatement(Connection connection, SQLDialect sqlDialect, String tableName, String columnName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getSelectIdSQL(sqlDialect, tableName, columnName));
    }

    public static String getSelectIdSQL(SQLDialect sqlDialect, String tableName, String columnName) {
        switch (sqlDialect) {
            case MYSQL: {
                return "SELECT `" + columnName + "` FROM `" + tableName + "` WHERE `" + columnName + "` = ? LIMIT 1";
            }
        }
        return "SELECT \"" + columnName + "\" FROM \"" + tableName + "\" WHERE \"" + columnName + "\" = ? LIMIT 1";
    }

    public static PreparedStatement getCreateDatabaseStatement(Connection connection, SQLDialect sqlDialect, String databaseName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getCreateDatabaseSQL(sqlDialect, databaseName));
    }

    public static String getCreateDatabaseSQL(SQLDialect sqlDialect, String databaseName) {
        switch (sqlDialect) {
            case SQLITE: 
            case H2: 
            case MYSQL: {
                return "CREATE DATABASE `" + databaseName + "`";
            }
        }
        return "CREATE DATABASE \"" + databaseName + "\"";
    }

    public static PreparedStatement getDropDatabaseStatement(Connection connection, SQLDialect sqlDialect, String databaseName) throws SQLException {
        return connection.prepareStatement(SQLUtil.getDropDatabaseSQL(sqlDialect, databaseName));
    }

    public static String getDropDatabaseSQL(SQLDialect sqlDialect, String databaseName) {
        switch (sqlDialect) {
            case SQLITE: 
            case H2: 
            case MYSQL: {
                return "DROP DATABASE `" + databaseName + "`";
            }
        }
        return "DROP DATABASE \"" + databaseName + "\"";
    }

    public static Object getObject(ResultSet rs, int position, Class<?> objectClass) throws SQLException {
        Object object = rs.getObject(position);
        if (objectClass == null) {
            return object;
        }
        if (objectClass == String.class) {
            return String.valueOf(object);
        }
        if (objectClass == Integer.class) {
            if (object instanceof Integer) {
                return (int)((Integer)object);
            }
            if (object instanceof Long) {
                return ((Long)object).intValue();
            }
            if (object instanceof Double) {
                return ((Double)object).intValue();
            }
            if (object instanceof Float) {
                return ((Float)object).intValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).intValue();
            }
            if (object instanceof Short) {
                return ((Short)object).intValue();
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).intValue();
            }
            if (object instanceof BigInteger) {
                return ((BigInteger)object).intValue();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof String) {
                return MathUtil.getInt(object);
            }
        } else if (objectClass == Long.class) {
            if (object instanceof Integer) {
                return ((Integer)object).longValue();
            }
            if (object instanceof Long) {
                return (long)((Long)object);
            }
            if (object instanceof Double) {
                return ((Double)object).longValue();
            }
            if (object instanceof Float) {
                return ((Float)object).longValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).longValue();
            }
            if (object instanceof Short) {
                return ((Short)object).longValue();
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).longValue();
            }
            if (object instanceof BigInteger) {
                return ((BigInteger)object).longValue();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof String) {
                return MathUtil.getLong(object);
            }
        } else if (objectClass == Double.class) {
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue();
            }
            if (object instanceof Double) {
                return (double)((Double)object);
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).doubleValue();
            }
            if (object instanceof Short) {
                return ((Short)object).doubleValue();
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).doubleValue();
            }
            if (object instanceof BigInteger) {
                return ((BigInteger)object).doubleValue();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof String) {
                return MathUtil.getDouble(object);
            }
        } else if (objectClass == Float.class) {
            if (object instanceof Integer) {
                return Float.valueOf(((Integer)object).floatValue());
            }
            if (object instanceof Long) {
                return Float.valueOf(((Long)object).floatValue());
            }
            if (object instanceof Double) {
                return Float.valueOf(((Double)object).floatValue());
            }
            if (object instanceof Float) {
                return Float.valueOf(((Float)object).floatValue());
            }
            if (object instanceof Byte) {
                return Float.valueOf(((Byte)object).floatValue());
            }
            if (object instanceof Short) {
                return Float.valueOf(((Short)object).floatValue());
            }
            if (object instanceof BigDecimal) {
                return Float.valueOf(((BigDecimal)object).floatValue());
            }
            if (object instanceof BigInteger) {
                return Float.valueOf(((BigInteger)object).floatValue());
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof String) {
                return Float.valueOf(MathUtil.getFloat(object));
            }
        } else if (objectClass == Short.class) {
            if (object instanceof Integer) {
                return ((Integer)object).shortValue();
            }
            if (object instanceof Long) {
                return ((Long)object).shortValue();
            }
            if (object instanceof Double) {
                return ((Double)object).shortValue();
            }
            if (object instanceof Float) {
                return ((Float)object).shortValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).shortValue();
            }
            if (object instanceof Short) {
                return (short)((Short)object);
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).shortValue();
            }
            if (object instanceof BigInteger) {
                return ((BigInteger)object).shortValue();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof String) {
                return MathUtil.getShort(object);
            }
        }
        throw new RuntimeException("cannot convert object " + object + " to " + objectClass);
    }

    static {
        DEFAULTPROPERTIES.put("createDatabaseIfNotExist", "true");
        DEFAULTPROPERTIES.put("useUnicode", "true");
        DEFAULTPROPERTIES.put("characterEncoding", MYSQLDEFAULTCHARSET);
        DEFAULTPROPERTIES.put("zeroDateTimeBehavior", "convertToNull");
        MYSQLPROPERTIES.put("useCompression", "true");
        DERBYPROPERTIES.put("create", "true");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SQLDialect {
        MYSQL,
        POSTGRESQL,
        MSSQL,
        HSQLDB,
        ORACLE,
        DERBY,
        HIVE,
        DB2,
        SQLITE,
        H2;

    }
}

