/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NetworkUtil {
    public static final List<String> getIPAddresses() throws SocketException {
        ArrayList<String> ips = new ArrayList<String>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress currentAddress = addresses.nextElement();
                if (currentAddress.isLoopbackAddress()) continue;
                ips.add(currentAddress.getHostAddress());
            }
        }
        return ips;
    }

    public static int getRandomLocalPort() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        int port = serverSocket.getLocalPort();
        serverSocket.close();
        return port;
    }

    public static String getHostName(String address) {
        try {
            InetAddress addr = InetAddress.getByName(address);
            return addr.getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

