/*
 * Decompiled with CFR 0.152.
 */
package xtools.api;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.reports.api.Report;
import java.io.File;
import java.net.URI;
import java.util.Date;
import java.util.Properties;

public class DefaultReport
extends AbstractObject
implements Report {
    private Class fProducerClass;
    private long fTimestamp;
    private transient Date fDate;
    private File[] fFiles;
    private Properties fParams;
    private File fReportDir;

    public DefaultReport(String name, long timestamp, Class producerClass, File[] files, Properties params, boolean shared) throws ClassNotFoundException {
        super(name);
        DefaultReport._runParamChecks(producerClass, files, params);
        if (shared) {
            this.fTimestamp = timestamp;
            this.fProducerClass = producerClass;
            this.fFiles = files;
            this.fParams = params;
        } else {
            this.fTimestamp = timestamp;
            this.fProducerClass = Class.forName(producerClass.getName());
            this.fParams = (Properties)params.clone();
            this.fFiles = new File[files.length];
            for (int i = 0; i < files.length; ++i) {
                this.fFiles[i] = new File(files[i].getPath());
            }
        }
        String val = this.fParams.getProperty("out");
        File baseDir = new File(val);
        this.fReportDir = new File(baseDir, NamingConventions.removeExtension(name));
    }

    private static void _runParamChecks(Class cl, File[] files, Properties params) {
        if (files == null) {
            throw new IllegalArgumentException("Param files cannot be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("Param params cannot be null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Param cl cannot be null");
        }
    }

    @Override
    public Class getProducer() {
        return this.fProducerClass;
    }

    @Override
    public long getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public Date getDate() {
        if (this.fDate == null) {
            this.fDate = new Date(this.fTimestamp);
        }
        return this.fDate;
    }

    @Override
    public File[] getFilesProduced() {
        File[] files = new File[this.fFiles.length];
        for (int f = 0; f < this.fFiles.length; ++f) {
            files[f] = this.fFiles[f];
        }
        return files;
    }

    @Override
    public int getNumPagesMade() {
        return this.fFiles.length;
    }

    @Override
    public Properties getParametersUsed() {
        return (Properties)this.fParams.clone();
    }

    @Override
    public void setErroredOut() {
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer().append(this.fFiles.length).append(" files");
        return buf.toString();
    }

    @Override
    public URI getReportIndex() {
        return this.fFiles[0].toURI();
    }

    @Override
    public File getReportDir() {
        return this.fReportDir;
    }
}

