/* math.h (emx+gcc) */

#if !defined (_MATH_H)
#define _MATH_H

#if defined (__cplusplus)
extern "C" {
#endif

extern double _HUGE_VAL;

#define HUGE_VAL _HUGE_VAL

double acos (double);
double asin (double);
double atan (double);
double atan2 (double, double);
double ceil (double);
double cos (double);
double cosh (double);
double exp (double);
double fabs (double);
double floor (double);
double fmod (double, double);
double frexp (double, int *);
double ldexp (double, int);
double log (double);
double log10 (double);
double modf (double, double *);
double pow (double, double);
double sin (double);
double sinh (double);
double sqrt (double);
double tan (double);
double tanh (double);

#if !defined (__STRICT_ANSI__)

#define HUGE _HUGE_VAL

double atof (__const__ char *);
double cbrt (double);
double hypot (double, double);
double rint (double);
double trunc (double);

#if !defined (_ABS)                                    /* see also stdlib.h */
#define _ABS
#if !defined (__GNUC__) || __GNUC__ >= 2
extern int abs (int);
extern long labs (long);
#else
static __inline__ int abs (int _n) { return (_n < 0 ? -_n : _n); }
static __inline__ long labs (long _n) { return (_n < 0 ? -_n : _n); }
#endif
#endif

#endif


#if !defined (__STRICT_ANSI__) || defined (_WITH_UNDERSCORE)

extern long double _LHUGE_VAL;
#define _LHUGE_VAL _LHUGE_VAL
#define _LHUGE     _LHUGE_VAL

long double _acosl (long double);
long double _asinl (long double);
long double _atanl (long double);
long double _atan2l (long double, long double);
long double _atofl (__const__ char *);
long double _cbrtl (long double);
long double _ceill (long double);
long double _cosl (long double);
long double _coshl (long double);
long double _hypotl (long double, long double);
long double _expl (long double);
long double _fabsl (long double);
long double _floorl (long double);
long double _fmodl (long double, long double);
long double _frexpl (long double, int *);
long double _ldexpl (long double, int);
long double _logl (long double);
long double _log10l (long double);
long double _modfl (long double, long double *);
long double _powl (long double, long double);
long double _rintl (long double);
long double _sinl (long double);
long double _sinhl (long double);
long double _sqrtl (long double);
long double _tanl (long double);
long double _tanhl (long double);
long double _truncl (long double);

#endif


#if defined (__cplusplus)
}
#endif

#endif /* !defined (_MATH_H) */
