	INCLUDE REGS386.INC
	INCLUDE TRANS.INC

	.386p

DGROUP group _DATA

_DATA segment word public 'DATA' use16
	extrn _cs16real: word
	extrn _ds16real: word
	trs TRANS  <>		      ; translation struct for r-mode switch
	goProtectMode	dd	?     ; Location of far call routine
_DATA ends

_TEXT segment byte public 'CODE' use16
	assume cs:_TEXT,ds:DGROUP

;
;	void RealModeSwitch(void)
;
public	_RealModeSwitch
_RealModeSwitch proc near
	pop	bx			;Where to return from this procedure

	movzx	ebx, bx
	movzx	esi, si
	movzx	edi, di
	movzx	ebp, bp
	mov	dword ptr trs.T_EBX, ebx
	mov	dword ptr trs.T_ESI, esi
	mov	dword ptr trs.T_EDI, edi
	mov	dword ptr trs.T_EBP, ebp

	mov	word ptr trs.T_SP, sp
	sub	word ptr trs.T_SP, 512
	mov	word ptr trs.T_IP, offset _TEXT:@@realModeEntry
	mov	word ptr trs.T_FLAGS, 0202h
	mov	ax, _cs16real
	mov	word ptr trs.T_CS, ax
	mov	ax, _ds16real
	mov	word ptr trs.T_DS, ax
	mov	word ptr trs.T_ES, ax
	mov	word ptr trs.T_SS, ax

	xor	ebx, ebx
	xor	ecx, ecx
	push	ds
	pop	es
	mov	di, offset DGROUP:trs
	movzx	edi, di
	mov	ax,0301h
	int	31h

	mov	esi, dword ptr trs.T_ESI
	mov	edi, dword ptr trs.T_EDI
	mov	ebp, dword ptr trs.T_EBP
	mov	sp, word ptr trs.T_SP
	jmp	word ptr trs.T_EBX    ; stored by DPMIprotectedMode() below
@@realModeEntry:
	pop	goProtectMode	; Address to return from real mode callback
	push	bx		; Address stored in realRegs above
	ret			; RealModeSwitch()
_RealModeSwitch   endp

;
;	void ProtectedModeSwitch(void)
;
public	_ProtectedModeSwitch
_ProtectedModeSwitch proc near
	pop	bx			  ;Return point (will be used in
	mov	dword ptr trs.T_EBX, ebx  ;  RealModeSwitch above)
	mov	dword ptr trs.T_ESI, esi
	mov	dword ptr trs.T_EDI, edi
	mov	dword ptr trs.T_EBP, ebp
	mov	word ptr trs.T_SP, sp
	jmp	goProtectMode	;Saved retf address from real mode callback
_ProtectedModeSwitch endp

_TEXT	ends

	end
