# letters menu 
#
# Copyright (C) 1997  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

set vv(ledne) "existiert nicht oder ist ohne Schreibberechtigung";# ""
set vv(le1c)  "Auswahlliste fr Brieftyp etc.:";# ""
set vv(le2c)  "Auswahlliste fr Brief/Dateinamen:";# ""
set vv(le2cn)  "*** neue Datei";# ""
set vv(le2aed) "ausgewhlte Datei editieren";# ""
set vv(le2asv) "aktuellen Stand speichern in Datei";# ""
set vv(le3c)   "Auswahlliste fr Eingabe:";# ""
set vv(le4ae)  "Ende mit bernahme des Textes";# ""
set vv(le4aq)  "Ende ohne bernahme der nderungen";# ""
set vv(lesemp) "Leeren String anstelle der gewnschten Ersetzung eingesetzt";# ""
set vv(leerr1) "bislang nicht in der execpre-Liste enthalten;";# ""
set vv(leerr2) "bislang nicht in der execpost-Liste enthalten;";# ""
set vv(leerr3) "falls wirklich bentigt,";# ""
set vv(le4are) "Ende mit Neusetzen";# ""
set vv(le4arq) "Ende ohne Neusetzen";# ""
set vv(le4art) "des aktuellen Inhalts";# ""
set vv(le4bt)  "der Felder";# ""
set vv(leerr4) "ist nicht in diesem Brieftyp als Feld enthalten";# ""
set vv(leerr5) "ist nicht erlaubt, da Feld mit dem externen Editor bearbeitet wird!";# ""
set vv(leerr6) "Block-End fr Block";#  ""
set vv(leerr7) "Inhalt dieses Blockes perprfen,";#  ""
set vv(leerr8) "nach erneutem Speichern der Datei ist die Dateistruktur wieder korrekt!";#  ""
###set vv(lenp)  "Anzahl der Parameter in `letter.vst' zu klein";# ""
###set vv(letnf)  "Keiner der Brieftypen in `letters.vst' pat zu:";# ""
#set vv(le)  "";# ""
#set vv(le)  "";# ""


set letterdir /home/l44/x11/xtemallgdir/letters/
set leanextModifier "Alt-"; set leanextKey "n"


# Tests! Nur die letzte Zeile ist wirksam!
set lettercom "exec emacs $main_file$texsuffix"   ;# emacs im Vordergrund mit Hauptdatei
set lettercom "exec emacs $main_file$texsuffix &" ;# emacs im Hintergrund mit Hauptdatei
set lettercom ".c.1.ed invoke"                    ;# Editor-Button-Invoke
set lettercom ".c.1.la invoke; .c.1.pr invoke"    ;# TeX-Button-, danach Preview-Button-Invoke
set lettercom "latex $main_file$texsuffix; xdvi $main_file";# LaTeX-Lauf, danach xdvi
set lettercom ""                                  ;# keine Befehlsausfhrung beim Verlassen
##### if {$lettercom!=""} {SigChldB; eval $lettercom; SigChldU; lock}

























proc letters {w austext} {



proc leExecPre {block} {# runs execpre commands
 global vv Wq Wle leBCont leBComPre leBDspC leIdTexts email
 TestPut 3 "<$block><$leBComPre($block)><$leBCont($block)>"
 set ind0 [lindex $leBComPre($block) 0]
 set errtxt "\n*** $vv(aerr): `$ind0'\n$vv(leerr1)\n$vv(leerr3) $email\n"
 if		{$ind0=="remove-comment-framework"} {
   set ret $leBCont($block)
   regsub -all "$leIdTexts(grep1)" "$ret" "" ret
   regsub -all "$leIdTexts(grep2)" "$ret" "" ret
   regsub -all "\n" "$ret" "$leBDspC(-NewLine)" ret
 } elseif	{$ind0=="remove-2backslashes-at-end-of-line"} {
   set zl [split "$leBCont($block)" "\n"]
   TestPut 1 "$zl"
   set ret ""
   foreach z $zl {
     set zt [string trim $z]; set p [string last {\\} $zt]; set l [string length $zt]
     if {$p==$l-2} {set z [string range $zt 0 [expr $l-3]]}
     if {$ret==""} {set ret "$z"} else {set ret "$ret\n$z"}
   }
 } elseif	{$ind0=="remove-command-and-braces"} {
   set ret [string trim $leBCont($block)]; set lg [string length $ret]
   set lc [string length [lindex $leBComPre($block) 1]]
   TestPut 4 "<$lg><$lc><$ret>"
   set ret [string range $ret [expr $lc+2] [expr $lg-2]]
   TestPut 4 "          <$ret>"
 } elseif	{$ind0=="remove-newcommand-and-braces"} {
   set ret [string trim $leBCont($block)]; set lg [string length $ret]
   set lc1 [string length [lindex $leBComPre($block) 1]]
   set lc2 [string length [lindex $leBComPre($block) 2]]
   TestPut 4 "<$lg><$lc1><$lc2><$ret>"
   set ret [string range $ret [expr $lc1+$lc2+5] [expr $lg-2]]
   TestPut 4 "          <$ret>"
 } else {mybell 4; BoxWaitOK $Wq "$errtxt" $Wle.a.e; set ret "$leBCont($block)"}
 TestPut 3 "$ret"
 return "$ret"
}

proc leUpdListWidget {incrsel} {
 global Wle leBDspC leBVarList leBCont
 TestPut 3 "$incrsel"
 if {$incrsel!=""} {$Wle.c.s.f.f.li delete 0 end} 
 foreach block $leBVarList {
   set l 50; # length of display string in block select list $Wle.c.s.f.f.li
   set txt [string trim [string range $leBCont($block) 0 $l]]
   if {[string trim [string range $leBCont($block) [expr $l+1] 400]]!=""} {set txt "$txt..."}
   regsub -all "\n" "$txt" "$leBDspC(-NewLine)" txt
   $Wle.c.s.f.f.li insert end " $leBDspC($block)  $block   $txt"
 }
}

proc leSetBDspC {block} {# updates block display character according to leBDspC
 global Wle leBDspC leBVarList leBCont
 set i [lsearch $leBVarList $block]
 set txt [string trim [string range $leBCont($block) 0 30]]
 regsub -all "\n" "$txt" "$leBDspC(-NewLine)" txt
 TestPut 2 "<$block><$i><$leBDspC($block)><txt>"
 $Wle.c.s.f.f.li delete $i; $Wle.c.s.f.f.li insert $i  " $leBDspC($block)  $block   $txt"
}

proc leBExecSetCont {} {# do execset (after end block edit)
 global vv Wq Wle leBSel leBCont leBSetCont leBVar leBDspC leSelType lesep letterdir
 TestPut 3 "<$leBSel><$leBCont($leBSel)><$leBSetCont($leBSel)>"
 set progcall [lindex $leBSetCont($leBSel) 0]
 SigChldB; set res [catch "exec $progcall $leBCont($leBSel)" mes]; SigChldU
 set errtxt "$vv(acall): $progcall $leBCont($leBSel)\n\n$vv(aerr):\n$mes"
 if {$res!=0} {mybell 3; BoxWaitOK $Wq "$errtxt" ""}
 TestPut 2 "<$res><$mes>"
 if {$res==0} {set values $mes} else {set values ""}
 set bl [lrange $leBSetCont($leBSel) 1 end]
 foreach b $bl {
   TestPut 3 "<$b>[lsearch $bl $b]<[lindex $values [lsearch $bl $b]]>"
   set errt "$vv(errf) letter.vst,\n [getvalue $leSelType 0 $lesep] : $leBSel : execset\n"
   set errt1 "${errt} $b $vv(leerr4);\n $vv(tsrt2)"
   set errt2 "${errt} $b $vv(leerr5);\n $vv(tsrt2)"
   TestPut 3 "<[info exists leBCont($b)]><[lindex $leBVar($leBSel) 0]>"
   if ![info exists leBCont($b)]		{mybell 3; BoxWaitOK $Wq "$errt1" $Wle.a.e} \
   elseif {[lindex $leBVar($b) 0]=="extern"} 	{mybell 3; BoxWaitOK $Wq "$errt2" $Wle.a.e} \
   else {set leBCont($b) [lindex $values [lsearch $bl $b]]}
   set leBDspC($b) "$leBDspC(-AutoChg)"; leSetBDspC "$b"
 }
}

proc leEndBlockEditNext {save} {TestPut 4 "$save"; leEndBlockEdit $save; leEditBlockSelected}

proc leEndBlockEdit {save} {
 global Wle Wleed leBSel leBCont leModified leBType leBVarList leBSetCont leBDspC leBNonEmpt
 TestPut 4 "<$save><$leBSel> <$leBSetCont($leBSel)>"
 if {$save==1} {
   if {$leBType=="entry"} {
     set txt [$Wleed.d.tt get]
   } elseif {$leBType=="text"} {
     set l [$Wleed.d.tt get "end -1c" end]
     if {$l=="\n"} {set txt [$Wleed.d.tt get 1.0 end-1c]} {set txt [$Wleed.d.tt get 1.0 end]}
   } elseif {$leBType=="radiobuttons"} {
     set txt "$leBCont($leBSel)"
   }
   TestPut 2 "$txt"
   set leBCont($leBSel) "$txt"
   leUpdListWidget $leBSel
   set leModified 1
   if {$leBSetCont($leBSel)!=""} {leBExecSetCont}
 }
 if [winfo exists $Wleed] {destros $Wleed}
 set bnum [lsearch $leBVarList $leBSel]; set b $leBSel
 $Wle.c.s.f.f.li selection clear $bnum
 if {($leBNonEmpt($b)==1)&&([string trim $leBCont($b)]=="")} {set i -Missing} {set i -NoExcpt}
 set leBDspC($leBSel) "$leBDspC($i)"
 leSetBDspC $leBSel
 if {$bnum<[expr [llength $leBVarList]-1]} {incr bnum}
 set leBSel [lindex $leBVarList $bnum]; $Wle.c.s.f.f.li selection set $bnum
 TestPut 3 "$leBSel"
}

proc leEditBlockSelected {} {
 global Wleed vv textxscroll
 global leBSel leBVar leBType leBCont leBSetCont leBAlt leEditCFN leBEdited
 TestPut 4 "########<$leBSel><$leBVar($leBSel)>\n\t\t\t<$leBCont($leBSel)>"
 leSelLevel 4
 set editTyp [lindex $leBVar($leBSel) 0]
 lappend leBEdited $leBSel
 if {$editTyp=="extern"} {					    # editor according $editor
   set leBType extern
   unlink -nocomplain $leEditCFN
   SigChldB; exec echo "$leBCont($leBSel)" >$leEditCFN; SigChldU; lock
   editor letter-edit $leEditCFN
   set leBCont($leBSel) [leExec "cat $leEditCFN"]
   unlink -nocomplain $leEditCFN
   leEndBlockEdit 0
 } elseif {$editTyp=="radiobuttons"} {				    # alternatives
   set leBType radiobuttons
   TestPut 2 "$leBAlt($leBSel)"
   set width [lindex $leBVar($leBSel) 1]
   toplevel_init $Wleed "$vv(ain): $leBSel" 550 400
   # top buttons
   frame $Wleed.a; pack configure $Wleed.a -pady 3 -anchor nw
   if {$leBSetCont($leBSel)==""} {
     button $Wleed.a.e -text "$vv(ae)" -command "leEndBlockEdit 1"
     Bind2P $Wleed.a.e 1 leEndBlockEditNext 1
     pack configure $Wleed.a.e -side left -padx 3 -pady 3
   } else {
     button $Wleed.a.e -text "$vv(le4are)" -command "leEndBlockEdit 1"
     Bind2P $Wleed.a.e 1 leEndBlockEditNext 1
     button $Wleed.a.q -text "$vv(le4arq)" -command "leEndBlockEdit 0"
     Bind2P $Wleed.a.q 1 leEndBlockEditNext 0
     label $Wleed.a.t -text "$vv(le4art)"
     pack configure $Wleed.a.e $Wleed.a.q $Wleed.a.t -side left -padx 3 -pady 3 -anchor w
     frame $Wleed.b;  pack configure $Wleed.b -anchor nw
     label $Wleed.b.t -text "$vv(le4bt): [lrange $leBSetCont($leBSel) 1 end]"
     frame $Wleed.b.d -height 20
     pack configure $Wleed.b.t $Wleed.b.d  -padx 3 -anchor nw
   }
   # edit area
   frame $Wleed.d -relief raised -borderwidth 2
   pack configure $Wleed.d -anchor nw -fill both -expand true -side top
   set i 0; set foundi ""
   foreach b $leBAlt($leBSel) {
     radiobutton $Wleed.d.$i -width $width -anchor w -text "$b" -variable leBCont($leBSel) \
	-value "$b" -command {if [winfo exists $Wleed.l] {destroy $Wleed.l}}
     bind $Wleed.d.$i <Button-2> "$Wleed.d.$i invoke; after 300; $Wleed.a.e invoke"
     pack configure $Wleed.d.$i -anchor nw
     if {$leBCont($leBSel)=="$b"} {set foundi $i}
     incr i
   }
 } elseif {$editTyp=="intern"}  {				    # free input in $Weed
   set width [lindex $leBVar($leBSel) 1]
   set height [lindex $leBVar($leBSel) 2]
   toplevel_init $Wleed "$vv(asel): $leBSel" 600 400
   # top buttons
   frame $Wleed.a;  pack configure $Wleed.a -pady 3 -anchor nw
   button $Wleed.a.e -text "$vv(le4ae)" -command "leEndBlockEdit 1"
   Bind2P $Wleed.a.e 1 leEndBlockEditNext 1
   button $Wleed.a.q -text "$vv(le4aq)" -command "leEndBlockEdit 0"
   Bind2P $Wleed.a.q 1 leEndBlockEditNextt 0
   pack configure $Wleed.a.e $Wleed.a.q -side left -padx 3 -pady 3
   # edit area
   frame $Wleed.d -relief raised -borderwidth 2
   pack configure $Wleed.d -anchor nw -fill both -expand true
   if {$height==1} {						      # 1 input line
     set leBType entry
     entry $Wleed.d.tt -width $width
     pack configure $Wleed.d.tt -anchor nw -fill x -expand true
   } else {							      # text-widget+scrollbar
     set leBType text
     if {$textxscroll>1} {
       text $Wleed.d.tt -height $height -width $width -yscrollcommand [list $Wleed.d.yb set] \
		-wrap none -xscrollcommand [list $Wleed.d.xb set]
       scrollbar $Wleed.d.xb -orient horizontal -command [list $Wleed.d.tt xview]
       pack configure $Wleed.d.xb -side bottom -fill x
       Bind3HF $Wleed.d.xb z_textfeld $Wleed.d.tt
     } else {
       text $Wleed.d.tt -height $height -width $width -yscrollcommand [list $Wleed.d.yb set]
     }
     scrollbar $Wleed.d.yb -orient vertical -command [list $Wleed.d.tt yview]
     pack configure $Wleed.d.yb -side right -fill y
     pack configure $Wleed.d.tt -side left -fill both -expand true
     bind $Wleed.d.tt <Key-Up>		"$Wleed.d.tt yview scroll -1 units"
     bind $Wleed.d.tt <Key-Down>	"$Wleed.d.tt yview scroll  1 units"
   }
   $Wleed.d.tt insert insert "$leBCont($leBSel)"
   focus $Wleed.d.tt
   update
 }
}

proc leBlockSelected {sel} {
 global Wleed leBList leBSel leBSetCont leBEdited
 set sold [lindex $leBEdited end]
 if {[string trim [string range $sel 0 2]]==""} {set el 0} else {set el 1}
 set leBSel [lindex $sel $el]
 TestPut 3 "<$sel><$sold><$leBSel>"
 if {[winfo exists $Wleed]&&($sold!="")&&($leBSetCont($sold)!="")} {set rais 1} {set rais 0}
 if {$rais==1} {raise $Wleed} else {leEditBlockSelected}
}

proc leGetNECont {block cont} {# gets block contents from vst for non-variable block
 global letterdir leBCont
 TestPut 3 "<$block><$cont>"
 set contents ""
 foreach conte $cont {
   TestPut 3 "$conte"
   regsub -all {\$letterdir} "$conte" "$letterdir" conte
   TestPut 3 "$conte"
   if {$contents!=""} {set contents "$contents\n"}
   set s0 [lindex $conte 0]; set s1 [lrange "$conte" 1 end]
   if		{$s0=="exececho"}	{set contents "$contents$s1"} \
   elseif	{$s0=="execcat"}	{set contents "$contents[leExec "cat $s1"]"} \
   else					{set contents "$contents$conte"}
 }
 set leBCont($block) "$contents"
 TestPut 3 "<$leBCont($block)>"
}

proc leReadBlockCont {block eofenc} {# reads block contents from file, execpre if requested
 global vv Wq leFId leFIdEOF leBCont leBDefault leBSetCont leBComPre leIdTexts leBSel
 TestPut 3 "0<$block><$leFId><$eofenc>"
 set found 0; set contents ""
 set getret [gets $leFId z]
 while {$getret>=0} {# positioning to start ob block (found=1 if really found)
   TestPut 1 "1<$z>"
   if {$z=="$leIdTexts(nomod) $leIdTexts(start) $block"} {set found 1; break}
   set getret [gets $leFId z]
 }
 if {$getret>=0} {set getret [gets $leFId z]}
 while {($getret>=0)&&($found==1)} {# if block start found: read until end of block; 
				    # (found=2 if block start *and* block end really 
   TestPut 1 "2<$z>"
   if {$z=="$leIdTexts(nomod) $leIdTexts(end) $block"}			{set found 2; break} \
   elseif {[string first "$leIdTexts(nomod) $leIdTexts(end)" $z]==0}	{break} \
   elseif {$contents==""}		{set contents "$z"} \
   else					{set contents "$contents\n$z"}
   set getret [gets $leFId z]
 }
 if {$getret<0} {incr eofenc}; # increment "EOF encountered" at EOF (should not happen!)
 if {($found==2)} {# OK, block found correctly
   set leBCont($block) "$contents"
   if {$leBComPre($block)!=""} {set leBCont($block) [leExecPre $block]}
 } elseif {($found==1)&&($eofenc==0)} {#block start OK; end found, but wasn't end of this block
   set leBCont($block) "$contents"
   if {$leBComPre($block)!=""} {set leBCont($block) [leExecPre $block]}
   mybell 3
   BoxWaitOK $Wq "$vv(errf) `'\n$vv(leerr6) `$block' $vv(anf)\n$vv(leerr7)\n$vv(leerr8)" ""
 } elseif {($eofenc=1)} {# perhaps block order changed: try one more run from the file start
   set  leBCont($block) ""
   close $leFId; set leFId [open $leSelFile]; set leFIdEOF 0
   leReadBlockCont $block 1
 } else {# set to default value
   set leBCont($block) "$leBDefault($block)"
   if {$leBSetCont($block)!=""} {set leBSel "$block"; leBExecSetCont; set leBsel ""}
   mybell 3
   BoxWaitOK $Wq "$vv(errf) `'\n$vv(leerr6) `$block' $vv(anf)\n$vv(leerr7)\n$vv(leerr8)" ""  
 }
 TestPut 2 "4<$leBCont($block)"
}

proc leLoadFile {} {# fills leF...(...): from existing file, or defaults otherwise
 global leSelFile leSelType lesep leFId leFIdRegular leBList leBVar leBVarList leBAlt leBDspC
 global leBName leBNonEmpt leBText leBCont leBDefault leBSetCont leBComPre leBComPost leBRep
 global leBEdited leBSel
 if {$leSelFile==""} {return}
 if [file exists $leSelFile] {set exists 1} else {set exists 0}
 TestPut 4 "<$leSelFile><exists>"
 if {$exists==1} {set leFId [open $leSelFile]; set leFIdEOF 0}
 set leBEdited ""; set execsetcontafter ""
 #
 # set leB...($bn)
 set leBList ""; set leBVarList "";
 set bnum 1; set s [getvalue $leSelType [expr $bnum+2] $lesep]
 while {$s!=""} {
   TestPut 3 "-------------------------------------------------\n\t\t<$s>"
   set s0 [lindex $s 0]; set bn [lindex $s0 1]; set leBName($bn) $bn; lappend leBList $bn
   set leBCont($bn) ""; set leBRep($bn) ""; set leBDspC($bn) "$leBDspC(-NonTchd)"
   set leBSetCont($bn) ""; set leBNonEmpt($bn) 0
   set leBComPre($bn) ""; set leBComPost($bn) ""
   if {[lindex [lindex $s0 0] 0]=="variable"} {
     set leBVar($bn) "[lrange [lindex $s0 0] 1 end]"
     if {$leBVar($bn)==""} {set leBVar($bn) "intern 40 1"}
   } else {
     set leBVar($bn) ""
   }
   if {$leBVar($bn)!=""} {lappend leBVarList $bn}
   TestPut 2 "$bnum:<$leBName($bn)><$leBVar($bn)>"
   if {$leBVar($bn)==""} {# non-variable block
     if {$exists==1} {leReadBlockCont $bn 0} else {leGetNECont $bn [lrange $s 1 end]}
   } else {# variable block
     set leBText($bn) [lindex $s 1]
     if {[lindex [lindex $s0 2] 0]=="non-empty"} {set leBNonEmpt($bn) 1}
     if {[lindex [lindex $s 2] 0]=="alternatives"} \
		{set leBAlt($bn) [lrange [lindex $s 2] 1 end]} else {set leBAlt($bn) ""}
     set i 3; set ll [llength $s]
     while {$i<$ll} {
	set si [lindex $s $i]
	if {[lindex $si 0]=="execset"}	{set leBSetCont($bn)	[lrange $si 1 end]}
	if {[lindex $si 0]=="execpre"}	{set leBComPre($bn)	[lrange $si 1 end]}
	if {[lindex $si 0]=="execpost"}	{set leBComPost($bn)	[lrange $si 1 end]}
	incr i
     }
     set leBDefault($bn) [lindex [lindex $s 2] 1]
     if {$exists==1} {
	 leReadBlockCont $bn 0
     } else {
	 set leBCont($bn) $leBDefault($bn)
	 if {$leBSetCont($bn)!=""} {lappend execsetcontafter "$bn"}
     }
     if {[string first "exec" [lindex $s 3]]!=0} {set leBRep($bn) [lindex $s 3]}
     TestPut 2 "<$leBText($bn)>\n\t\t\t<$leBNonEmpt($bn)><$leBAlt($bn)>"
     TestPut 2 "<$leBRep($bn)>\n\t\t\t<$leBSetCont($bn)><$leBComPre($bn)><$leBComPost($bn)>"
   }
   TestPut 2 "$leBCont($bn)"
   incr bnum; set s [getvalue $leSelType [expr $bnum+2] $lesep]
   if {($leBNonEmpt($bn)==1)&&([string trim $leBCont($bn)]=="")} \
	{set leBDspC($bn) "$leBDspC(-Missing)"}
 }
 #
 if {$exists==1} {close $leFId}
 if {$execsetcontafter!=""} \
	 {foreach bn $execsetcontafter {set leBSel "$bn"; leBExecSetCont}; set leBsel ""}
 TestPut 4 "<$leBList>\n\t\t<$leBVarList>"
}

proc leExec {cmd} {# executes cmd via exec and returns result
 global Wle Wq vv xtem_path letterdir
 set res ""; set ret ""
 if {[string trim $cmd]!=""} {
   if {[lindex $cmd 0]=="echo"} {
     set res [lrange $cmd 1 end]
     #SigChldB; catch "exec echo [lrange $cmd 1 end]" res; SigChldU; lock;#####@@@@@?????
   } else {
     SigChldB; eval set ret [catch "exec $cmd" res]; SigChldU; lock
     set errtxt "$res\n\n$vv(errf): $xtem_path/letters.vst\n$vv(adm)\n\n$vv(lesemp)\n($cmd)"
     if {$ret==1} {mybell 4; BoxWaitOK $Wq "$errtxt" $Wle.a.e; set res ""}
   }
 }
 TestPut 4 "<$cmd><$ret><$res>"
 return "$res"
}

proc leRepCont {block n} {#replacement $leBRep($n)->($n+1) in leBCont;returns 0 after last rp.
 global leBCont leBRep
 set str [lindex $leBRep($block) $n]; set rep [lindex $leBRep($block) [expr $n+1]]
 if {"$str$rep"!=""} {
   TestPut 2 "<$leBCont($block)> <$str><$rep>[string first "execrep " $rep]"
   if {([string first $str $leBCont($block)]>=0)&&([string first "execrep " $rep]>=0)} \
	{set rep [leExec [lrange $rep 1 end]]}
   if {$str!=""} {regsub -all "$str" "$leBCont($block)" "$rep" leBCont($block)} \
   elseif {[string trim $leBCont($block)]==""} {set leBCont($block) $rep}
   TestPut 2 "$leBCont($block)"
   return 1
 } else {
   return 0
 } 
}

proc leExecPost {block} {# runs execpost commands
 global vv Wq Wle leBCont leBComPost leBComPre leBDspC leIdTexts email
 TestPut 3 "<$block><$leBComPost($block)><$leBCont($block)>"
 if {[lindex $leBCont($block) 0]=="set-equal-to-block-contents"} \
	{set leBCont($block) "$leBCont([lindex $leBCont($block) 1])"}
 set ind0 [lindex $leBComPost($block) 0]
 set errtxt "\n*** $vv(aerr): `$ind0'\n$vv(leerr2)\n$vv(leerr3) $email\n"
 if		{$ind0=="insert-comment-framework"} {
   set ret "$leIdTexts(grep1)$leBCont($block)$leIdTexts(grep2)"
   regsub -all "\n" "$ret" "$leBDspC(-NewLine)" ret
 } elseif	{$ind0=="insert-2backslashes-at-end-of-line"} {
   set zl [split "$leBCont($block)" "\n"]
   TestPut 1 "$zl"
   set ret ""
   foreach z $zl {
     if {$ret==""} {set ret "$z"} else {set ret "$ret\n$z"}
     if {[string trim $z]!=""} {set ret "$ret\\\\"}
   }
 } elseif	{$ind0=="insert-command-and-braces"} {
   TestPut 4 "          <$leBCont($block)>"
   set ret "\\[lindex $leBComPre($block) 1]\{$leBCont($block)\}"
   TestPut 4 "          <$ret>"
 } elseif	{$ind0=="insert-newcommand-and-braces"} {
   TestPut 4 "          <$leBCont($block)>"
   set ret \
     "\\[lindex $leBComPre($block) 1]\{\\[lindex $leBComPre($block) 2]\}\{$leBCont($block)\}"
   TestPut 4 "          <$ret>"
 } else {mybell 4; BoxWaitOK $Wq "$errtxt" $Wle.a.e; set ret "$leBCont($block)"}
 TestPut 3 "$ret"
 return "$ret"
}

proc leKnoepfe {} {# sets main_file, efile and suffixes, then calls knoepfe
 global leSelFile main_file texsuffix tsuff efile esuff dir
 set main_file [string range $leSelFile 0 [expr [string length $leSelFile]-5]]
 set tsuff $texsuffix; set efile $main_file; set esuff $tsuff; knoepfe
}

proc leWriteFile {} {# writes block contents into file, and does execpost if requested
 global leSelFile leSelType lesep leIdTexts leBList leBCont leBRep leBComPost leModified
 if [file exists $leSelFile] {set exists 1} else {set exists 0}
 if {$exists==1} {file rename -force -- $leSelFile $leSelFile.bak}
 set leFId [open $leSelFile w]
 set type "$leIdTexts(nomod) $leIdTexts(type) [getvalue $leSelType 0 $lesep]"
 TestPut 4 "<exists=$exists><$leSelFile><$leBList>\n$type"
 puts $leFId "$type"
 foreach block $leBList {
   if {[info exists leBRep($block)]&&($leBRep($block)!="")} \
	{set n 0; while {[leRepCont $block $n]!=0} {incr n 2}}
   set pre  "%\n$leIdTexts(nomod) $leIdTexts(start) $block\n"
   if {$leBComPost($block)==""} {set text $leBCont($block)}  {set text [leExecPost $block]}
   set post "\n$leIdTexts(nomod) $leIdTexts(end) $block"
   TestPut 2 "<$block>:\n$pre$text$post"
   puts $leFId "$pre$text$post"
 }
 close $leFId
 set leModified 0
}

proc leWle2aedit {} {
 global vv Wle leModified leSelFile leBList leSelLev
 TestPut 4 ""
 leSelLevel 3
 leLoadFile
 #
 # add "block edit list":
 foreach w "a.edit c" {if [winfo exists $Wle.$w] {destroy $Wle.$w}}
 set leModified 0
 button $Wle.a.save -text "$vv(le2asv) $leSelFile" -command "leWriteFile; leKnoepfe"
 pack configure $Wle.a.save -side left -padx 3 -pady 3
 frame $Wle.c; pack $Wle.c -anchor w -fill x -expand yes
 frame $Wle.c.s; pack $Wle.c.s -anchor w -padx 4 -fill x -expand yes
 CreateLSBox $Wle.c.s "$vv(le3c)" top 80 40 2 "" "" "" "" leBlockSelected sel Dummy
 leUpdListWidget ""
}

proc leFileSelected {sel} {global leSelFile; TestPut 4 "$sel"; set leSelFile [lindex $sel 0]}

proc leGrepFileIdTexts {files} {# greps for file identifia=cation texts --> leIdTexts
 global leIdTexts
 TestPut 4 "<[pwd]><$files>"
 SigChldB; set r [catch "exec grep \"$leIdTexts(grep1)\" $files" m]; SigChldU; lock
 TestPut 4 "<<<$r><$m>>>"
 if {$r==0} {set leIdTexts(grepall) $m} else {set leIdTexts(grepall) ""}
 if {[llength $files]==1} {set leIdTexts(grepall) "$files:$leIdTexts(grepall)"}
}

proc leFileIdText {file} {# returns file identification text for $file
 global leIdTexts
 set t1 "$file:$leIdTexts(grep1)"; set t2 "$leIdTexts(grep2)"
 TestPut 4 "$t1...$t2"
 set p1 [string first $t1 $leIdTexts(grepall)]
 if {$p1>=0} {
   set ret [string range $leIdTexts(grepall) [expr $p1+[string length $t1]] end]
   set p2 [string first $t2 $ret]
   if {$p2>=0} {set ret [string range $ret 0 [expr $p2-1]]}
 } else {set ret ""}
 return "$ret"
}

proc leSelectFile {sel} {# type just selected ($sel); create filename selection window
 global vv Wle Wq env leSelType lesep texsuffix leSelLev leSelFile
 TestPut 4 "<$sel>"
 leSelLevel 2
 set leSelType "$sel"
 set leNewDir [getvalue $leSelType 1 $lesep]
 set fns [getvalue $leSelType 2 $lesep]
 set HOME $env(HOME); set leNewDir "[eval concat $leNewDir]";	# Substitution von $HOME
 regsub ^~ $leNewDir $env(HOME) leNewDir;			# Substitution von ~
 TestPut 3 "<$leNewDir><$fns>"
 set errtxt "$vv(fs20) $leNewDir\n$vv(ledne)\n"
 if {[file isdirectory $leNewDir]&&[file writable $leNewDir]} {cd $leNewDir} \
 else {mybell 3; BoxWaitOK $Wq "$errtxt" ""; set leSelFile ""; return}
 #
 # looks for old file list:
 set res [catch "glob ${fns}????????-*$texsuffix" erg]
 if {$res==1} {set fold ""} else {set fold [lsort $erg]}
 TestPut 3 "<$fold>"
 #
 # grep file ident texts form old files:
 if {$fold!=""} {leGrepFileIdTexts "$fold"}
 #
 # set new file name
 set fn "$fns[clock format [clock seconds] -format %Y%m%d]-"
 for {set n 1} {$n<100} {incr n} {
   if {$n<10} {set fnew ${fn}0$n$texsuffix} else {set fnew ${fn}$n$texsuffix}
   if ![file exists $fnew] break
 }
 TestPut 3 "<$fnew>";
 #
 # sets file list including ident texts
 set flist ""; set flist [linsert $flist 0 "$fnew    $vv(le2cn)"]
 foreach fn $fold {set flist [linsert $flist 1 "$fn    [leFileIdText $fn]"]}
 TestPut 3 "<$flist>";
 #
 # add "edit selected file" button and selection list:
 foreach w "c" {if [winfo exists $Wle.$w] {destroy $Wle.$w}}
 button $Wle.a.edit -text "$vv(le2aed)" -command "leWle2aedit"
 pack configure $Wle.a.edit -side left -padx 3 -pady 3
 frame $Wle.c; pack $Wle.c -anchor w -fill x -expand yes
 frame $Wle.c.s; pack $Wle.c.s -anchor w -padx 4 -fill x -expand yes
 CreateLSBox $Wle.c.s "$vv(le2c)" top 80 40 2 "" "" "" "$flist" leFileSelected sel leWle2aedit
 $Wle.c.s.f.f.li selection set 0; set leSelFile $fnew
}

proc leWleae {} {# ends letter window
 global Wle leOldDir leModified
 FehltNoch "in leWleae fehlt Abfrage leModified";#####@@@@@
 destros $Wle; unlock_list; #if {$leOldDir!=[pwd]} {cd $leOldDir}
}

proc leSelLevel {lev} {global leSelLev; set leSelLev $lev; TestPut 3 "@@@@@@@@@@<$leSelLev>"}

proc leSelectTyp {} {# creates "select letter type" window
 global Wle vv b_letters lesep
 TestPut 4 ""
 leSelLevel 1
 toplevel_init $Wle "$vv(amen) [string range $b_letters 1 end]" 600 500
 # top buttons
 frame $Wle.a;  pack configure $Wle.a -pady 3 -anchor nw
 button $Wle.a.e -text "$vv(ae)" -command "leWleae"
 pack configure $Wle.a.e -side left -padx 3 -pady 3
 # display area
 frame $Wle.c; pack configure $Wle.c -anchor w -ipadx 2
 # select box/buttons
 CreateLSBox $Wle.c $vv(le1c) top 40 14 2 "" "" \
	"$lesep" [vst2list "letters.vst" 1 "$lesep" "" leSel_v] leSelectFile "" leWle2aedit
 focus $Wle
}

global vv env letterdir leOldDir leIdTexts leBDspC lesep

upvar 1 $austext a; set a ""

set leOldDir [pwd]; TestPut 4 "$leOldDir"
set HOME $env(HOME); set leNewDir "[eval concat $letterdir]";	# Substitution von $HOME
regsub ^~ $letterdir $env(HOME) letterdir;			# Substitution von ~
set lesep [getsep letters.vst]
set leIdTexts(grep1) "%%%%%%%%%%_identification_text_<"
set leIdTexts(grep2)					">_don't_modify_in_general_%%%%%%%%%%"
set leIdTexts(nomod) "%%%%%%%%%%_don't modify this line"
set leIdTexts(start) "start:"
set leIdTexts(end)   "end:  "
set leIdTexts(type)  "letter type:"
set leBDspC(-Missing) "M" ; # non-blank contents requested (`missing contents')
set leBDspC(-AutoChg) "*" ; # block contents changed automatically by `execset'
set leBDspC(-NonTchd) "." ; # other non-toched blocks
set leBDspC(-NoExcpt) " " ; # no exception (after `touch') --> display `blank'
set leBDspC(-NewLine) { \\\\ } ; # no exception (after `touch') --> display `blank'

leSelectTyp
}
