/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.wizards;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.wizards.TexlipseProjectAttributes;
import net.sourceforge.texlipse.wizards.TexlipseWizardPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;

public class TexlipseProjectFilesWizardPage
extends TexlipseWizardPage {
    private Text outputDirNameField;
    private Text outputFileNameField;
    private Text sourceDirNameField;
    private Text sourceFileNameField;
    private Text tempDirNameField;
    private Tree dirTree;
    private TreeItem projectDirItem;
    private TreeItem outputDirItem;
    private TreeItem outputFileItem;
    private TreeItem sourceDirItem;
    private TreeItem sourceFileItem;
    private TreeItem tempDirItem;
    private TreeItem tempFileItem;
    private ISharedImages images = TexlipsePlugin.getDefault().getWorkbench().getSharedImages();

    public TexlipseProjectFilesWizardPage(TexlipseProjectAttributes attributes) {
        super(1, attributes);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.projectDirItem.setText(this.attributes.getProjectName());
        this.outputFileNameField.setText(this.attributes.getOutputFile());
        this.outputFileItem.setText(this.attributes.getOutputFile());
    }

    public void createComponents(Composite parent) {
        this.addSpacer(parent, 2);
        Label label = new Label(parent, 16384);
        label.setText(TexlipsePlugin.getResourceString("projectWizardDirTreeLabel"));
        label.setLayoutData((Object)new GridData());
        this.addSpacer(parent, 1);
        this.createTreeControl(parent);
        Composite right = new Composite(parent, 4);
        right.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        right.setLayout((Layout)gl);
        this.createOutputDirControl(right);
        this.createOutputFileControl(right);
        this.createMainDirControl(right);
        this.createMainFileControl(right);
        this.createTempDirControl(right);
    }

    private void createTreeControl(Composite parent) {
        this.dirTree = new Tree(parent, 2052);
        this.dirTree.setToolTipText(TexlipsePlugin.getResourceString("projectWizardDirTreeTooltip"));
        this.dirTree.setLayoutData((Object)new GridData(1808));
        this.recreateSubTree();
    }

    private void recreateSubTree() {
        this.dirTree.removeAll();
        this.projectDirItem = new TreeItem(this.dirTree, 16384);
        this.projectDirItem.setText(this.attributes.getProjectName());
        this.projectDirItem.setImage(this.images.getImage("IMG_OBJ_FOLDER"));
        String dir = this.attributes.getOutputDir();
        if (dir != null && dir.length() > 0) {
            this.outputDirItem = new TreeItem(this.projectDirItem, 16384);
            this.outputDirItem.setText(dir);
            this.outputDirItem.setImage(this.images.getImage("IMG_OBJ_FOLDER"));
            this.outputFileItem = new TreeItem(this.outputDirItem, 16384);
        } else {
            this.outputDirItem = null;
            this.outputFileItem = new TreeItem(this.projectDirItem, 16384);
        }
        this.outputFileItem.setText(this.attributes.getOutputFile());
        this.outputFileItem.setImage(this.images.getImage("IMG_OBJ_FILE"));
        dir = this.attributes.getSourceDir();
        if (dir != null && dir.length() > 0) {
            this.sourceDirItem = new TreeItem(this.projectDirItem, 16384);
            this.sourceDirItem.setText(dir);
            this.sourceDirItem.setImage(this.images.getImage("IMG_OBJ_FOLDER"));
            this.sourceFileItem = new TreeItem(this.sourceDirItem, 16384);
        } else {
            this.sourceDirItem = null;
            this.sourceFileItem = new TreeItem(this.projectDirItem, 16384);
        }
        this.sourceFileItem.setText(this.attributes.getSourceFile());
        this.sourceFileItem.setImage(this.images.getImage("IMG_OBJ_FILE"));
        dir = this.attributes.getTempDir();
        if (dir != null && dir.length() > 0) {
            this.tempDirItem = new TreeItem(this.projectDirItem, 16384);
            this.tempDirItem.setText(dir);
            this.tempDirItem.setImage(this.images.getImage("IMG_OBJ_FOLDER"));
            this.tempFileItem = new TreeItem(this.tempDirItem, 16384);
        } else {
            this.tempDirItem = null;
            this.tempFileItem = new TreeItem(this.projectDirItem, 16384);
        }
        this.tempFileItem.setText(this.attributes.getTempFile());
        this.tempFileItem.setImage(this.images.getImage("IMG_OBJ_FILE"));
        this.dirTree.showItem(this.outputFileItem);
        this.dirTree.showItem(this.sourceFileItem);
        this.dirTree.showItem(this.tempFileItem);
    }

    private void createOutputDirControl(Composite composite) {
        Label mainLabel = new Label(composite, 16384);
        mainLabel.setText(TexlipsePlugin.getResourceString("projectWizardOutputDirLabel"));
        mainLabel.setToolTipText(TexlipsePlugin.getResourceString("projectWizardOutputDirTooltip"));
        mainLabel.setLayoutData((Object)new GridData());
        this.outputDirNameField = new Text(composite, 2052);
        this.outputDirNameField.setText(this.attributes.getOutputDir());
        this.outputDirNameField.setToolTipText(TexlipsePlugin.getResourceString("projectWizardOutputDirTooltip"));
        this.outputDirNameField.setLayoutData((Object)new GridData(768));
        this.outputDirNameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                if (TexlipseProjectFilesWizardPage.this.outputDirItem != null) {
                    TexlipseProjectFilesWizardPage.this.dirTree.setSelection(new TreeItem[]{TexlipseProjectFilesWizardPage.this.outputDirItem});
                }
            }
        });
        this.outputDirNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TexlipseProjectFilesWizardPage.this.outputDirNameField.isDisposed()) {
                    String t = TexlipseProjectFilesWizardPage.this.outputDirNameField.getText();
                    TexlipseProjectFilesWizardPage.this.attributes.setOutputDir(t);
                    TexlipseProjectFilesWizardPage.this.validateDirName(TexlipseProjectFilesWizardPage.this.outputDirNameField, t);
                    if (t == null || t.length() == 0) {
                        TexlipseProjectFilesWizardPage.this.recreateSubTree();
                    } else if (TexlipseProjectFilesWizardPage.this.outputDirItem == null) {
                        TexlipseProjectFilesWizardPage.this.recreateSubTree();
                    }
                    if (TexlipseProjectFilesWizardPage.this.outputDirItem != null) {
                        TexlipseProjectFilesWizardPage.this.outputDirItem.setText(t);
                    }
                }
            }
        });
    }

    private void createOutputFileControl(Composite composite) {
        Label mainLabel = new Label(composite, 16384);
        mainLabel.setText(TexlipsePlugin.getResourceString("projectWizardOutputFileLabel"));
        mainLabel.setToolTipText(TexlipsePlugin.getResourceString("projectWizardOutputFileTooltip"));
        mainLabel.setLayoutData((Object)new GridData());
        this.outputFileNameField = new Text(composite, 2052);
        this.outputFileNameField.setText(this.attributes.getOutputFile());
        this.outputFileNameField.setToolTipText(TexlipsePlugin.getResourceString("projectWizardOutputFileTooltip"));
        this.outputFileNameField.setLayoutData((Object)new GridData(768));
        this.outputFileNameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                TexlipseProjectFilesWizardPage.this.dirTree.setSelection(new TreeItem[]{TexlipseProjectFilesWizardPage.this.outputFileItem});
            }
        });
        this.outputFileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TexlipseProjectFilesWizardPage.this.outputFileNameField.isDisposed()) {
                    String t = TexlipseProjectFilesWizardPage.this.outputFileNameField.getText();
                    TexlipseProjectFilesWizardPage.this.outputFileItem.setText(t);
                    TexlipseProjectFilesWizardPage.this.validateOutputFileName(t);
                }
            }
        });
    }

    private void createMainDirControl(Composite composite) {
        Label mainLabel = new Label(composite, 16384);
        mainLabel.setText(TexlipsePlugin.getResourceString("projectWizardMainDirLabel"));
        mainLabel.setToolTipText(TexlipsePlugin.getResourceString("projectWizardMainDirTooltip"));
        mainLabel.setLayoutData((Object)new GridData());
        this.sourceDirNameField = new Text(composite, 2052);
        this.sourceDirNameField.setText(this.attributes.getSourceDir());
        this.sourceDirNameField.setToolTipText(TexlipsePlugin.getResourceString("projectWizardMainDirTooltip"));
        this.sourceDirNameField.setLayoutData((Object)new GridData(768));
        this.sourceDirNameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                if (TexlipseProjectFilesWizardPage.this.sourceDirItem != null) {
                    TexlipseProjectFilesWizardPage.this.dirTree.setSelection(new TreeItem[]{TexlipseProjectFilesWizardPage.this.sourceDirItem});
                }
            }
        });
        this.sourceDirNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TexlipseProjectFilesWizardPage.this.sourceDirNameField.isDisposed()) {
                    String t = TexlipseProjectFilesWizardPage.this.sourceDirNameField.getText();
                    TexlipseProjectFilesWizardPage.this.attributes.setSourceDir(t);
                    TexlipseProjectFilesWizardPage.this.validateDirName(TexlipseProjectFilesWizardPage.this.sourceDirNameField, t);
                    if (t == null || t.length() == 0) {
                        TexlipseProjectFilesWizardPage.this.recreateSubTree();
                    } else if (TexlipseProjectFilesWizardPage.this.sourceDirItem == null) {
                        TexlipseProjectFilesWizardPage.this.recreateSubTree();
                    }
                    if (TexlipseProjectFilesWizardPage.this.sourceDirItem != null) {
                        TexlipseProjectFilesWizardPage.this.sourceDirItem.setText(t);
                    }
                }
            }
        });
    }

    private void createMainFileControl(Composite composite) {
        Label mainLabel = new Label(composite, 16384);
        mainLabel.setText(TexlipsePlugin.getResourceString("projectWizardMainFileLabel"));
        mainLabel.setToolTipText(TexlipsePlugin.getResourceString("projectWizardMainFileTooltip"));
        mainLabel.setLayoutData((Object)new GridData());
        this.sourceFileNameField = new Text(composite, 2052);
        this.sourceFileNameField.setText(this.attributes.getSourceFile());
        this.sourceFileNameField.setToolTipText(TexlipsePlugin.getResourceString("projectWizardMainFileTooltip"));
        this.sourceFileNameField.setLayoutData((Object)new GridData(768));
        this.sourceFileNameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                TexlipseProjectFilesWizardPage.this.dirTree.setSelection(new TreeItem[]{TexlipseProjectFilesWizardPage.this.sourceFileItem});
            }
        });
        this.sourceFileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TexlipseProjectFilesWizardPage.this.sourceFileNameField.isDisposed()) {
                    String t = TexlipseProjectFilesWizardPage.this.sourceFileNameField.getText();
                    TexlipseProjectFilesWizardPage.this.sourceFileItem.setText(t);
                    TexlipseProjectFilesWizardPage.this.tempFileItem.setText(String.valueOf(t.substring(0, t.lastIndexOf(46) + 1)) + "aux");
                    TexlipseProjectFilesWizardPage.this.validateMainFileName(t);
                }
            }
        });
    }

    private void createTempDirControl(Composite composite) {
        Label mainLabel = new Label(composite, 16384);
        mainLabel.setText(TexlipsePlugin.getResourceString("projectWizardTempDirLabel"));
        mainLabel.setToolTipText(TexlipsePlugin.getResourceString("projectWizardTempDirTooltip"));
        mainLabel.setLayoutData((Object)new GridData());
        this.tempDirNameField = new Text(composite, 2052);
        this.tempDirNameField.setText(this.attributes.getTempDir());
        this.tempDirNameField.setToolTipText(TexlipsePlugin.getResourceString("projectWizardTempDirTooltip"));
        this.tempDirNameField.setLayoutData((Object)new GridData(768));
        this.tempDirNameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                if (TexlipseProjectFilesWizardPage.this.tempDirItem != null) {
                    TexlipseProjectFilesWizardPage.this.dirTree.setSelection(new TreeItem[]{TexlipseProjectFilesWizardPage.this.tempDirItem});
                }
            }
        });
        this.tempDirNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TexlipseProjectFilesWizardPage.this.tempDirNameField.isDisposed()) {
                    String t = TexlipseProjectFilesWizardPage.this.tempDirNameField.getText();
                    TexlipseProjectFilesWizardPage.this.attributes.setTempDir(t);
                    TexlipseProjectFilesWizardPage.this.validateDirName(TexlipseProjectFilesWizardPage.this.tempDirNameField, t);
                    if (t == null || t.length() == 0) {
                        TexlipseProjectFilesWizardPage.this.recreateSubTree();
                    } else if (TexlipseProjectFilesWizardPage.this.tempDirItem == null) {
                        TexlipseProjectFilesWizardPage.this.recreateSubTree();
                    }
                    if (TexlipseProjectFilesWizardPage.this.tempDirItem != null) {
                        TexlipseProjectFilesWizardPage.this.tempDirItem.setText(t);
                    }
                }
            }
        });
    }

    private void validateDirName(Text field, String text) {
        IStatus status = null;
        status = text.indexOf(47) >= 0 || text.indexOf(92) >= 0 ? this.createStatus(4, TexlipsePlugin.getResourceString("projectWizardDirNameError")) : this.createStatus(0, TexlipsePlugin.getResourceString("projectWizardOutputFileNameOk"));
        this.updateStatus(status, field);
    }

    private void validateOutputFileName(String text) {
        String out = this.attributes.getOutputFormat();
        IStatus status = null;
        if (!text.toLowerCase().endsWith(String.valueOf('.') + out)) {
            status = this.createStatus(4, TexlipsePlugin.getResourceString("projectWizardOutputFileNameError").replaceFirst("%s", out));
        } else {
            status = this.createStatus(0, TexlipsePlugin.getResourceString("projectWizardOutputFileNameOk"));
            this.attributes.setOutputFile(text);
        }
        this.updateStatus(status, this.outputFileNameField);
    }

    private void validateMainFileName(String text) {
        IStatus status = null;
        if (!text.toLowerCase().endsWith(".tex") && !text.toLowerCase().endsWith(".ltx")) {
            status = this.createStatus(4, TexlipsePlugin.getResourceString("projectWizardFileNameError"));
        } else {
            status = this.createStatus(0, TexlipsePlugin.getResourceString("projectWizardFileNameOk"));
            this.attributes.setSourceFile(text);
        }
        this.updateStatus(status, this.sourceFileNameField);
    }
}

